/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FocusUtil {
    @NonNls
    private static final String SWING_FOCUS_OWNER_PROPERTY = "focusOwner";

    public static Component findFocusableComponentIn(Component searchIn, Component toSkip) {
        List components = UIUtil.uiTraverser(searchIn).toList();
        for (Component component : components) {
            if (component.equals(toSkip) || !component.isFocusable()) continue;
            return component;
        }
        return searchIn;
    }

    @Nullable
    public static Component getMostRecentComponent(Component component, Window ancestor) {
        if (ancestor == null) {
            return null;
        }
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle owner = lookup.findStatic(KeyboardFocusManager.class, "getMostRecentFocusOwner", MethodType.methodType(Component.class, Window.class));
            Component mostRecentFocusOwner = owner.invokeExact(ancestor);
            if (mostRecentFocusOwner != null && SwingUtilities.isDescendingFrom(mostRecentFocusOwner, component) && mostRecentFocusOwner.isShowing()) {
                return mostRecentFocusOwner;
            }
        }
        catch (Throwable e) {
            Logger.getInstance(FocusUtil.class).debug(e);
        }
        return null;
    }

    public static Component getDefaultComponentInPanel(Component component) {
        if (!(component instanceof JPanel)) {
            return null;
        }
        JPanel container = (JPanel)component;
        FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
        if (policy == null) {
            return container;
        }
        Component defaultComponent = policy.getDefaultComponent(container);
        if (defaultComponent == null) {
            return container;
        }
        return policy.getDefaultComponent(container);
    }

    public static void addFocusOwnerListener(@NotNull Disposable parentDisposable, @NotNull PropertyChangeListener listener2) {
        if (parentDisposable == null) {
            FocusUtil.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            FocusUtil.$$$reportNull$$$0(1);
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(SWING_FOCUS_OWNER_PROPERTY, listener2);
        Disposer.register((Disposable)parentDisposable, () -> KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(SWING_FOCUS_OWNER_PROPERTY, listener2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "listener";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/ui/FocusUtil";
        objectArray[2] = "addFocusOwnerListener";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

