/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class GraphicsConfig {
    private final Graphics2D myG;
    private final Map myHints;
    private final Composite myComposite;
    private final Stroke myStroke;

    public GraphicsConfig(@NotNull Graphics g) {
        if (g == null) {
            GraphicsConfig.$$$reportNull$$$0(0);
        }
        this.myG = (Graphics2D)g;
        this.myHints = (Map)this.myG.getRenderingHints().clone();
        this.myComposite = this.myG.getComposite();
        this.myStroke = this.myG.getStroke();
    }

    public GraphicsConfig setAntialiasing(boolean on) {
        this.myG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, on ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        return this;
    }

    public GraphicsConfig setAlpha(float alpha) {
        this.myG.setComposite(AlphaComposite.getInstance(3, alpha));
        return this;
    }

    public GraphicsConfig setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.myG.setRenderingHint(hintKey, hintValue);
        return this;
    }

    public Graphics2D getG() {
        return this.myG;
    }

    public GraphicsConfig setComposite(Composite composite) {
        this.myG.setComposite(composite);
        return this;
    }

    public GraphicsConfig setStroke(Stroke stroke) {
        this.myG.setStroke(stroke);
        return this;
    }

    public GraphicsConfig setupRoundedBorderAntialiasing() {
        return this.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE).setStroke(new BasicStroke(1.0f, 0, 2));
    }

    public GraphicsConfig setupAAPainting() {
        return this.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
    }

    public GraphicsConfig disableAAPainting() {
        return this.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
    }

    public GraphicsConfig paintWithAlpha(float alpha) {
        assert (0.0f <= alpha && alpha <= 1.0f) : "alpha should be in range 0.0f .. 1.0f";
        return this.setComposite(AlphaComposite.getInstance(3, alpha));
    }

    public void restore() {
        this.myG.setRenderingHints(this.myHints);
        this.myG.setComposite(this.myComposite);
        this.myG.setStroke(this.myStroke);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/ui/GraphicsConfig", "<init>"));
    }
}

