/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoaderKt;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.ui.icons.FilteredIconKt;
import com.intellij.ui.icons.IconReplacer;
import com.intellij.ui.icons.PaintNotifier;
import com.intellij.ui.icons.ReplaceableIcon;
import com.intellij.ui.icons.RgbImageFilterSupplier;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ui/icons/FilteredIcon;", "Lcom/intellij/ui/icons/ReplaceableIcon;", "baseIcon", "Ljavax/swing/Icon;", "filterSupplier", "Lcom/intellij/ui/icons/RgbImageFilterSupplier;", "<init>", "(Ljavax/swing/Icon;Lcom/intellij/ui/icons/RgbImageFilterSupplier;)V", "modificationCount", "", "iconToPaint", "currentScale", "", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "", "y", "replaceBy", "replacer", "Lcom/intellij/ui/icons/IconReplacer;", "calculateModificationCount", "getIconWidth", "getIconHeight", "TimestampSearcher", "intellij.platform.util.ui"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFilteredIcon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilteredIcon.kt\ncom/intellij/ui/icons/FilteredIcon\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,156:1\n23#2:157\n*S KotlinDebug\n*F\n+ 1 FilteredIcon.kt\ncom/intellij/ui/icons/FilteredIcon\n*L\n36#1:157\n*E\n"})
public final class FilteredIcon
implements ReplaceableIcon {
    @NotNull
    private final Icon baseIcon;
    @NotNull
    private final RgbImageFilterSupplier filterSupplier;
    private long modificationCount;
    @Nullable
    private Icon iconToPaint;
    private double currentScale;

    public FilteredIcon(@NotNull Icon baseIcon, @NotNull RgbImageFilterSupplier filterSupplier) {
        Intrinsics.checkNotNullParameter((Object)baseIcon, (String)"baseIcon");
        Intrinsics.checkNotNullParameter((Object)filterSupplier, (String)"filterSupplier");
        this.baseIcon = baseIcon;
        this.filterSupplier = filterSupplier;
        this.modificationCount = -1L;
        this.currentScale = 1.0;
        if (this.baseIcon instanceof EmptyIcon) {
            FilteredIcon $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(FilteredIcon.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Do not create FilteredIcon for EmptyIcon");
        }
    }

    public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
        Component component;
        long currentModificationCount;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        double scale = FilteredIconKt.access$getScaleToRenderIcon(this.baseIcon, c);
        Icon toPaint = this.iconToPaint;
        if ((toPaint == null || this.modificationCount != -1L) && (currentModificationCount = this.calculateModificationCount()) != -1L && currentModificationCount != this.modificationCount) {
            this.modificationCount = currentModificationCount;
            toPaint = null;
        }
        if (!(scale == this.currentScale)) {
            toPaint = null;
        }
        if (toPaint == null) {
            toPaint = FilteredIconKt.access$renderFilteredIcon(this.baseIcon, scale, this.filterSupplier, c);
            this.currentScale = scale;
            this.iconToPaint = toPaint;
        }
        if (c != null) {
            new PaintNotifier(c, x, y).replaceIcon(this.baseIcon);
        }
        if ((component = c) == null) {
            component = IconLoaderKt.getFakeComponent();
        }
        toPaint.paintIcon(component, g, x, y);
    }

    @NotNull
    public Icon replaceBy(@NotNull IconReplacer replacer) {
        Intrinsics.checkNotNullParameter((Object)replacer, (String)"replacer");
        Icon icon = replacer.replaceIcon(this.baseIcon);
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"replaceIcon(...)");
        return (Icon)((Object)new FilteredIcon(icon, this.filterSupplier));
    }

    private final long calculateModificationCount() {
        TimestampSearcher searcher = new TimestampSearcher();
        searcher.replaceIcon(this.baseIcon);
        return searcher.getModificationCount();
    }

    public int getIconWidth() {
        return this.baseIcon.getIconWidth();
    }

    public int getIconHeight() {
        return this.baseIcon.getIconHeight();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/ui/icons/FilteredIcon$TimestampSearcher;", "Lcom/intellij/ui/icons/IconReplacer;", "<init>", "()V", "modificationCount", "", "getModificationCount", "()J", "setModificationCount", "(J)V", "replaceIcon", "Ljavax/swing/Icon;", "icon", "intellij.platform.util.ui"})
    private static final class TimestampSearcher
    implements IconReplacer {
        private long modificationCount;

        public final long getModificationCount() {
            return this.modificationCount;
        }

        public final void setModificationCount(long l) {
            this.modificationCount = l;
        }

        @NotNull
        public Icon replaceIcon(@NotNull Icon icon) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            if (icon instanceof ModificationTracker) {
                this.modificationCount = this.modificationCount == -1L ? ((ModificationTracker)icon).getModificationCount() : (this.modificationCount += ((ModificationTracker)icon).getModificationCount());
            }
            ReplaceableIcon replaceableIcon = icon instanceof ReplaceableIcon ? (ReplaceableIcon)icon : null;
            if (replaceableIcon != null) {
                replaceableIcon.replaceBy((IconReplacer)this);
            }
            Icon icon2 = super.replaceIcon(icon);
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"replaceIcon(...)");
            return icon2;
        }
    }
}

