/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.ui.icons.ImageCacheKt;
import com.intellij.ui.icons.LoadIconParameters;
import com.intellij.ui.icons.PatchedImageDataLoader;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.SVGLoader;
import java.awt.Image;
import java.awt.image.ImageFilter;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00050\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ui/icons/FinalImageDataLoader;", "Lcom/intellij/ui/icons/PatchedImageDataLoader;", "path", "", "classLoader", "Ljava/lang/ClassLoader;", "<init>", "(Ljava/lang/String;Ljava/lang/ClassLoader;)V", "getPath", "()Ljava/lang/String;", "classLoaderRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "loadImage", "Ljava/awt/Image;", "parameters", "Lcom/intellij/ui/icons/LoadIconParameters;", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "isMyClassLoader", "", "getCoords", "Lkotlin/Pair;", "toString", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nImageDataByUrlLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageDataByUrlLoader.kt\ncom/intellij/ui/icons/FinalImageDataLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
final class FinalImageDataLoader
implements PatchedImageDataLoader {
    @NotNull
    private final String path;
    @NotNull
    private final WeakReference<ClassLoader> classLoaderRef;

    public FinalImageDataLoader(@NotNull String path, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.path = path;
        this.classLoaderRef = new WeakReference<ClassLoader>(classLoader);
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public Image loadImage(@NotNull LoadIconParameters parameters, @NotNull ScaleContext scaleContext) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        if (classLoader == null) {
            return null;
        }
        ClassLoader classLoader2 = classLoader;
        String string = this.getPath();
        boolean bl = parameters.isDark;
        List<ImageFilter> list = parameters.filters;
        SVGLoader.SvgElementColorPatcherProvider svgElementColorPatcherProvider = parameters.colorPatcher;
        return ImageCacheKt.loadImage$default(string, null, classLoader2, scaleContext, bl, svgElementColorPatcherProvider, list, false, false, 128, null);
    }

    @Override
    @Nullable
    public URL getUrl() {
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        return classLoader != null ? classLoader.getResource(this.getPath()) : null;
    }

    @Override
    public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return this.classLoaderRef.get() == classLoader;
    }

    @Override
    @Nullable
    public Pair<String, ClassLoader> getCoords() {
        Pair pair;
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        if (classLoader != null) {
            ClassLoader it = classLoader;
            boolean bl = false;
            pair = TuplesKt.to((Object)this.getPath(), (Object)it);
        } else {
            pair = null;
        }
        return pair;
    }

    @NotNull
    public String toString() {
        return "FinalImageDataLoader(classLoader=" + this.classLoaderRef.get() + ", path='" + this.getPath() + "')";
    }
}

