/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.ui.icons.IconTransformKt;
import com.intellij.util.ArrayUtil;
import java.awt.image.ImageFilter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bB)\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\rJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0006J\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0006H\u0007J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0003J(\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0018J=\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00182\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\b\u001a\u0004\u0018\u00010\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ui/icons/IconTransform;", "", "isDark", "", "patchers", "", "Lcom/intellij/openapi/util/IconPathPatcher;", "postPatchers", "filter", "Ljava/awt/image/ImageFilter;", "<init>", "(Z[Lcom/intellij/openapi/util/IconPathPatcher;[Lcom/intellij/openapi/util/IconPathPatcher;Ljava/awt/image/ImageFilter;)V", "dark", "(Z[Lcom/intellij/openapi/util/IconPathPatcher;Ljava/awt/image/ImageFilter;)V", "[Lcom/intellij/openapi/util/IconPathPatcher;", "withPathPatcher", "patcher", "withPostPathPatcher", "withoutPathPatcher", "withFilter", "withDark", "patchPath", "Lkotlin/Pair;", "", "Ljava/lang/ClassLoader;", "path", "classLoader", "applyPatchers", "(Ljava/lang/String;Ljava/lang/ClassLoader;[Lcom/intellij/openapi/util/IconPathPatcher;)Lkotlin/Pair;", "copy", "intellij.platform.util.ui"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIconTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IconTransform.kt\ncom/intellij/ui/icons/IconTransform\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,124:1\n60#2,5:125\n*S KotlinDebug\n*F\n+ 1 IconTransform.kt\ncom/intellij/ui/icons/IconTransform\n*L\n105#1:125,5\n*E\n"})
public final class IconTransform {
    @JvmField
    public final boolean isDark;
    @NotNull
    private final IconPathPatcher[] patchers;
    @NotNull
    private final IconPathPatcher[] postPatchers;
    @JvmField
    @Nullable
    public final ImageFilter filter;

    private IconTransform(boolean isDark, IconPathPatcher[] patchers, IconPathPatcher[] postPatchers, ImageFilter filter) {
        this.isDark = isDark;
        this.patchers = patchers;
        this.postPatchers = postPatchers;
        this.filter = filter;
    }

    public IconTransform(boolean dark, @NotNull IconPathPatcher[] patchers, @Nullable ImageFilter filter) {
        Intrinsics.checkNotNullParameter((Object)patchers, (String)"patchers");
        this(dark, patchers, new IconPathPatcher[0], filter);
    }

    @NotNull
    public final IconTransform withPathPatcher(@NotNull IconPathPatcher patcher) {
        Intrinsics.checkNotNullParameter((Object)patcher, (String)"patcher");
        return new IconTransform(this.isDark, (IconPathPatcher[])ArraysKt.plus((Object[])this.patchers, (Object)patcher), this.postPatchers, this.filter);
    }

    @ApiStatus.Internal
    @NotNull
    public final IconTransform withPostPathPatcher(@NotNull IconPathPatcher patcher) {
        Intrinsics.checkNotNullParameter((Object)patcher, (String)"patcher");
        Object[] objectArray = ArrayUtil.append((Object[])this.postPatchers, (Object)patcher);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"append(...)");
        return new IconTransform(this.isDark, this.patchers, (IconPathPatcher[])objectArray, this.filter);
    }

    @NotNull
    public final IconTransform withoutPathPatcher(@NotNull IconPathPatcher patcher) {
        Intrinsics.checkNotNullParameter((Object)patcher, (String)"patcher");
        Object[] objectArray = ArrayUtil.remove((Object[])this.patchers, (Object)patcher);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"remove(...)");
        IconPathPatcher[] newPatchers = (IconPathPatcher[])objectArray;
        IconPathPatcher[] newLastPatchers = this.postPatchers;
        if (newPatchers == this.patchers) {
            Object[] objectArray2 = ArrayUtil.remove((Object[])this.postPatchers, (Object)patcher);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"remove(...)");
            newLastPatchers = (IconPathPatcher[])objectArray2;
        }
        if (newPatchers == this.patchers && newLastPatchers == this.postPatchers) {
            return this;
        }
        return new IconTransform(this.isDark, newPatchers, this.postPatchers, this.filter);
    }

    @NotNull
    public final IconTransform withFilter(@NotNull ImageFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (filter == this.filter) {
            return this;
        }
        return new IconTransform(this.isDark, this.patchers, this.postPatchers, filter);
    }

    @NotNull
    public final IconTransform withDark(boolean dark) {
        if (dark == this.isDark) {
            return this;
        }
        return new IconTransform(dark, this.patchers, this.postPatchers, this.filter);
    }

    @Nullable
    public final Pair<String, ClassLoader> patchPath(@NotNull String path, @Nullable ClassLoader classLoader) {
        Pair<String, ClassLoader> pair;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Pair<String, ClassLoader> prePatchResult = this.applyPatchers(path, classLoader, this.patchers);
        if (prePatchResult == null) {
            pair = this.applyPatchers(path, classLoader, this.postPatchers);
        } else {
            pair = this.applyPatchers((String)prePatchResult.getFirst(), (ClassLoader)prePatchResult.getSecond(), this.postPatchers);
            if (pair == null) {
                pair = prePatchResult;
            }
        }
        return pair;
    }

    private final Pair<String, ClassLoader> applyPatchers(String path, ClassLoader classLoader, IconPathPatcher[] patchers) {
        Object pathWithLeadingSlash = path.charAt(0) == '/' ? path : "/" + path;
        for (IconPathPatcher patcher : patchers) {
            String newPath = null;
            try {
                newPath = patcher.patchPath((String)pathWithLeadingSlash, classLoader);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                IconTransformKt.access$getLOG$p().error(patcher + " cannot patch icon path", (Throwable)e);
                continue;
            }
            if (newPath == null) continue;
            Logger $this$debug_u24default$iv = IconTransformKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("replace '" + path + "' with '" + newPath + "'", e$iv);
            }
            ClassLoader contextClassLoader = patcher.getContextClassLoader((String)pathWithLeadingSlash, classLoader);
            if (contextClassLoader == null) {
                Class clazz = patcher.getContextClass((String)pathWithLeadingSlash);
                contextClassLoader = clazz != null ? clazz.getClassLoader() : null;
            }
            return new Pair((Object)newPath, (Object)contextClassLoader);
        }
        return null;
    }

    @NotNull
    public final IconTransform copy() {
        return new IconTransform(this.isDark, this.patchers, this.postPatchers, this.filter);
    }
}

