/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hashing;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.svg.IconValue;
import com.intellij.ui.svg.SvgCacheKeyType;
import com.intellij.ui.svg.SvgCacheValueType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.InsecureHashBuilder;
import com.intellij.util.io.mvstore.MvStoreHelperKt;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.type.DataType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.image.SunWritableRaster;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a2\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a)\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002\u001a)\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0002\u001a\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u0005H\u0002\"\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"getSvgIconCacheFile", "Ljava/nio/file/Path;", "openSvgCache", "Lorg/h2/mvstore/MVMap;", "", "Lcom/intellij/ui/svg/IconValue;", "store", "Lorg/h2/mvstore/MVStore;", "name", "", "logSupplier", "Lkotlin/Function0;", "Lcom/intellij/openapi/diagnostic/Logger;", "createPrecomputedIconCacheKey", "precomputedCacheKey", "", "compoundKey", "Lcom/intellij/ui/svg/SvgCacheClassifier;", "colorPatcherDigest", "createPrecomputedIconCacheKey-2Mr4RHQ", "(II[J)[J", "packTwoIntToLong", "", "v1", "v2", "createIconCacheKey", "imageBytes", "", "createIconCacheKey-2Mr4RHQ", "([BI[J)[J", "bgraBandOffsets", "", "colorModel", "Ljava/awt/image/ComponentColorModel;", "ZERO_POINT", "Ljava/awt/Point;", "writeImage", "image", "Ljava/awt/image/BufferedImage;", "readImage", "value", "intellij.platform.util.ui"})
public final class SvgCacheManagerKt {
    @NotNull
    private static final int[] bgraBandOffsets;
    @NotNull
    private static final ComponentColorModel colorModel;
    @NotNull
    private static final Point ZERO_POINT;

    @NotNull
    public static final Path getSvgIconCacheFile() {
        String[] stringArray = new String[]{"icon-cache-v1.db"};
        Path path = Path.of(PathManager.getSystemPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return path;
    }

    private static final MVMap<long[], IconValue> openSvgCache(MVStore store, String name, Function0<? extends Logger> logSupplier2) {
        MVMap.Builder mapBuilder = new MVMap.Builder();
        mapBuilder.setKeyType((DataType)SvgCacheKeyType.INSTANCE);
        mapBuilder.setValueType((DataType)SvgCacheValueType.INSTANCE);
        return MvStoreHelperKt.openOrResetMap((MVStore)store, (String)name, (MVMap.Builder)mapBuilder, logSupplier2);
    }

    @NotNull
    public static final long[] createPrecomputedIconCacheKey-2Mr4RHQ(int precomputedCacheKey, int n, @Nullable long[] colorPatcherDigest) {
        long[] lArray = new long[2];
        lArray[0] = SvgCacheManagerKt.packTwoIntToLong(precomputedCacheKey, n);
        HashStream64 hashStream64 = Hashing.komihash5_0().hashStream();
        long[] lArray2 = colorPatcherDigest;
        if (colorPatcherDigest == null) {
            lArray2 = ArrayUtilRt.EMPTY_LONG_ARRAY;
        }
        lArray[1] = hashStream64.putLongArray(lArray2).getAsLong();
        return lArray;
    }

    private static final long packTwoIntToLong(int v1, int v2) {
        return (long)v1 << 32 | (long)v2 & 0xFFFFFFFFL;
    }

    @ApiStatus.Internal
    @NotNull
    public static final long[] createIconCacheKey-2Mr4RHQ(@NotNull byte[] imageBytes, int n, @Nullable long[] colorPatcherDigest) {
        Intrinsics.checkNotNullParameter((Object)imageBytes, (String)"imageBytes");
        HashStream64 hashStream = Hashing.komihash5_0().hashStream();
        HashStream64 hashStream2 = InsecureHashBuilder.seededHasher.hashStream();
        long[] lArray = colorPatcherDigest;
        if (colorPatcherDigest == null) {
            lArray = ArrayUtilRt.EMPTY_LONG_ARRAY;
        }
        long[] effectiveColorPatcherDigest = lArray;
        hashStream.putLongArray(effectiveColorPatcherDigest);
        hashStream2.putLongArray(effectiveColorPatcherDigest);
        hashStream.putBytes(imageBytes);
        hashStream.putInt(imageBytes.length);
        hashStream2.putBytes(imageBytes);
        hashStream2.putInt(imageBytes.length);
        hashStream.putInt(n);
        hashStream2.putInt(n);
        long[] lArray2 = new long[]{hashStream.getAsLong(), hashStream2.getAsLong()};
        return lArray2;
    }

    private static final byte[] writeImage(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        switch (image.getType()) {
            case 6: {
                DataBuffer dataBuffer = image.getRaster().getDataBuffer();
                Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferByte");
                byte[] byArray = SunWritableRaster.stealData((DataBufferByte)dataBuffer, 0);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"stealData(...)");
                return byArray;
            }
            case 2: {
                DataBuffer dataBuffer = image.getRaster().getDataBuffer();
                Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
                int[] data = SunWritableRaster.stealData((DataBufferInt)dataBuffer, 0);
                ByteBuffer buffer = ByteBuffer.allocate(data.length * 4).order(ByteOrder.LITTLE_ENDIAN);
                buffer.asIntBuffer().put(data);
                byte[] byArray = buffer.array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                return byArray;
            }
        }
        BufferedImage convertedImage = new BufferedImage(w, h, 6);
        Graphics2D g = convertedImage.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        DataBuffer dataBuffer = convertedImage.getRaster().getDataBuffer();
        Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferByte");
        byte[] byArray = SunWritableRaster.stealData((DataBufferByte)dataBuffer, 0);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"stealData(...)");
        return byArray;
    }

    private static final BufferedImage readImage(IconValue value) {
        DataBufferByte dataBuffer = new DataBufferByte(value.data, value.data.length);
        SunWritableRaster.makeTrackable(dataBuffer);
        int w = value.w;
        int h = value.h;
        WritableRaster raster = Raster.createInterleavedRaster(dataBuffer, w, h, w * 4, 4, bgraBandOffsets, ZERO_POINT);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static final /* synthetic */ MVMap access$openSvgCache(MVStore store, String name, Function0 logSupplier2) {
        return SvgCacheManagerKt.openSvgCache(store, name, (Function0<? extends Logger>)logSupplier2);
    }

    public static final /* synthetic */ BufferedImage access$readImage(IconValue value) {
        return SvgCacheManagerKt.readImage(value);
    }

    public static final /* synthetic */ byte[] access$writeImage(BufferedImage image) {
        return SvgCacheManagerKt.writeImage(image);
    }

    static {
        int[] nArray = new int[]{2, 1, 0, 3};
        bgraBandOffsets = nArray;
        colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        ZERO_POINT = new Point(0, 0);
    }
}

