/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.HiDPIImage;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.icons.ImageCacheKt;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0005H\u0007J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u000b\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bH\u0007J#\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u000b\u0010\u001c\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020!H\u0007J\u0012\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010#\u001a\u00020$H\u0007J\u0012\u0010%\u001a\u0004\u0018\u00010\u000e2\u0006\u0010&\u001a\u00020'H\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u0014\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u0014\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003R\u0014\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003\u00a8\u0006("}, d2={"Lcom/intellij/util/ImageLoader;", "", "<init>", "()V", "ALLOW_FLOAT_SCALING", "", "getALLOW_FLOAT_SCALING$annotations", "USE_CACHE", "getUSE_CACHE$annotations", "USE_DARK", "getUSE_DARK$annotations", "USE_SVG", "getUSE_SVG$annotations", "loadFromUrl", "Ljava/awt/Image;", "url", "Ljava/net/URL;", "scaleImage", "image", "scale", "", "targetSize", "targetWidth", "targetHeight", "loadFromResource", "s", "", "Lorg/jetbrains/annotations/NonNls;", "path", "aClass", "Ljava/lang/Class;", "loadFromBytes", "bytes", "", "loadFromStream", "inputStream", "Ljava/io/InputStream;", "loadCustomIcon", "file", "Ljava/io/File;", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nImageLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageLoader.kt\ncom/intellij/util/ImageLoader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n13#2:113\n*S KotlinDebug\n*F\n+ 1 ImageLoader.kt\ncom/intellij/util/ImageLoader\n*L\n101#1:113\n*E\n"})
public final class ImageLoader {
    @NotNull
    public static final ImageLoader INSTANCE = new ImageLoader();
    public static final int ALLOW_FLOAT_SCALING = 1;
    public static final int USE_CACHE = 2;
    public static final int USE_DARK = 4;
    public static final int USE_SVG = 8;

    private ImageLoader() {
    }

    public static /* synthetic */ void getALLOW_FLOAT_SCALING$annotations() {
    }

    public static /* synthetic */ void getUSE_CACHE$annotations() {
    }

    public static /* synthetic */ void getUSE_DARK$annotations() {
    }

    public static /* synthetic */ void getUSE_SVG$annotations() {
    }

    @JvmStatic
    @Nullable
    public static final Image loadFromUrl(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String path = string;
        return ImageCacheKt.loadImage$default(path, null, null, null, false, null, null, false, true, 250, null);
    }

    @JvmStatic
    @NotNull
    public static final Image scaleImage(@NotNull Image image, double scale) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return IconUtilKt.doScaleImage(image, scale);
    }

    @JvmStatic
    @NotNull
    public static final Image scaleImage(@NotNull Image image, int targetSize) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return ImageLoader.scaleImage(image, targetSize, targetSize);
    }

    @JvmStatic
    @NotNull
    public static final Image scaleImage(@NotNull Image image, int targetWidth, int targetHeight) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).scale(targetWidth, targetHeight);
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0 || w == targetWidth && h == targetHeight) {
            return image;
        }
        BufferedImageOp[] bufferedImageOpArray = new BufferedImageOp[]{null};
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)targetWidth, (int)targetHeight, (BufferedImageOp[])bufferedImageOpArray);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"resize(...)");
        return bufferedImage;
    }

    @JvmStatic
    @Deprecated(message="Use {@link #loadFromResource(String, Class)}")
    @Nullable
    public static final Image loadFromResource(@NotNull String s) {
        Class callerClass;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Class clazz = callerClass = ReflectionUtil.getGrandCallerClass();
        if (clazz == null) {
            return null;
        }
        return ImageCacheKt.loadImage$default(s, clazz, null, null, false, null, null, false, true, 248, null);
    }

    @JvmStatic
    @Nullable
    public static final Image loadFromResource(@NotNull String path, @NotNull Class<?> aClass) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        return ImageCacheKt.loadImage$default(path, aClass, null, null, false, null, null, false, true, 248, null);
    }

    @JvmStatic
    @Nullable
    public static final Image loadFromBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return ImageLoader.loadFromStream(new ByteArrayInputStream(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final Image loadFromStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        try {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                ScaleContext scaleContext = ScaleContext.Companion.create();
                float scale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
                BufferedImage image = IconUtilKt.loadRasterImage(inputStream);
                if (StartupUiUtil.INSTANCE.isJreHiDPI(scaleContext)) {
                    double userScale = scaleContext.getScale(DerivedScaleType.EFF_USR_SCALE);
                    Image image2 = new HiDPIImage((Image)image, (double)((float)image.getWidth() / scale) * userScale, (double)((float)image.getHeight() / scale) * userScale, 2);
                    return image2;
                }
                Image image3 = image;
                return image3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ImageLoader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final Image loadCustomIcon(@NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        URL uRL = file.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return IconUtilKt.loadCustomIcon(uRL);
    }
}

