/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.image.RGBImageFilter;
import java.util.Objects;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
@ApiStatus.NonExtendable
public class GrayFilter
extends RGBImageFilter {
    private final float brightness;
    private final float contrast;
    private final int alpha;
    private final int origContrast;
    private final int origBrightness;

    public GrayFilter(int brightness, int contrast, int alpha) {
        this.origBrightness = Math.max(-100, Math.min(100, brightness));
        this.brightness = (float)(Math.pow(this.origBrightness, 3.0) / 10000.0);
        this.origContrast = Math.max(-100, Math.min(100, contrast));
        this.contrast = (float)this.origContrast / 100.0f;
        this.alpha = Math.max(0, Math.min(100, alpha));
    }

    public GrayFilter() {
        this(0, 0, 100);
    }

    public int getBrightness() {
        return this.origBrightness;
    }

    public int getContrast() {
        return this.origContrast;
    }

    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int gray = (int)(0.3 * (double)(rgb >> 16 & 0xFF) + 0.59 * (double)(rgb >> 8 & 0xFF) + 0.11 * (double)(rgb & 0xFF));
        gray = this.brightness >= 0.0f ? (int)(((float)gray + this.brightness * 255.0f) / (1.0f + this.brightness)) : (int)((float)gray / (1.0f - this.brightness));
        gray = this.contrast >= 0.0f ? (gray >= 127 ? (int)((float)gray + (float)(255 - gray) * this.contrast) : (int)((float)gray - (float)gray * this.contrast)) : (int)(127.0f + (float)(gray - 127) * (this.contrast + 1.0f));
        int a = (rgb >> 24 & 0xFF) * this.alpha / 100;
        return a << 24 | gray << 16 | gray << 8 | gray;
    }

    @NotNull
    public static GrayFilter asUIResource(int brightness, int contrast, int alpha) {
        return new GrayFilterUIResource(brightness, contrast, alpha);
    }

    @NotNull
    public static GrayFilter namedFilter(@NotNull String resourceName, @NotNull GrayFilter defaultFilter) {
        if (resourceName == null) {
            GrayFilter.$$$reportNull$$$0(0);
        }
        if (defaultFilter == null) {
            GrayFilter.$$$reportNull$$$0(1);
        }
        GrayFilter grayFilter = Objects.requireNonNullElse((GrayFilter)UIManager.get(resourceName), defaultFilter);
        if (grayFilter == null) {
            GrayFilter.$$$reportNull$$$0(2);
        }
        return grayFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/GrayFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/GrayFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "namedFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "namedFilter";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class GrayFilterUIResource
    extends GrayFilter
    implements UIResource {
        private GrayFilterUIResource(int brightness, int contrast, int alpha) {
            super(brightness, contrast, alpha);
        }
    }
}

