/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.html;

import com.intellij.icons.AllIcons;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.html.DataUrlImageView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.text.Element;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/util/ui/html/HiDpiScalingImageView;", "Lcom/intellij/util/ui/html/DataUrlImageView;", "elem", "Ljavax/swing/text/Element;", "<init>", "(Ljavax/swing/text/Element;)V", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "getScaleContext", "()Lcom/intellij/ui/scale/ScaleContext;", "sysScale", "", "getSysScale", "()F", "getMaximumSpan", "axis", "", "getMinimumSpan", "getPreferredSpan", "getLoadingImageIcon", "Ljavax/swing/Icon;", "paint", "", "g", "Ljava/awt/Graphics;", "a", "Ljava/awt/Shape;", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nHiDpiScalingImageView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiDpiScalingImageView.kt\ncom/intellij/util/ui/html/HiDpiScalingImageView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class HiDpiScalingImageView
extends DataUrlImageView {
    public HiDpiScalingImageView(@NotNull Element elem) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        super(elem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ScaleContext getScaleContext() {
        Container container = this.getContainer();
        Container container2 = container;
        if (container == null) return null;
        Container container3 = container2;
        Component p0 = container3;
        boolean bl = false;
        if (!StartupUiUtil.isJreHiDPI(p0)) return null;
        Container container4 = container3;
        container2 = container4;
        if (container4 == null) return null;
        container3 = container2;
        ScaleContext.Companion companion = ScaleContext.Companion;
        Component p02 = container3;
        boolean bl2 = false;
        ScaleContext scaleContext = companion.create(p02);
        return scaleContext;
    }

    private final float getSysScale() {
        ScaleContext scaleContext = this.getScaleContext();
        return scaleContext != null ? (float)scaleContext.getScale(ScaleType.SYS_SCALE) : 1.0f;
    }

    @Override
    public float getMaximumSpan(int axis) {
        return super.getMaximumSpan(axis) / this.getSysScale();
    }

    @Override
    public float getMinimumSpan(int axis) {
        return super.getMinimumSpan(axis) / this.getSysScale();
    }

    @Override
    public float getPreferredSpan(int axis) {
        return super.getPreferredSpan(axis) / this.getSysScale();
    }

    @Override
    @NotNull
    public Icon getLoadingImageIcon() {
        Icon icon = AllIcons.Process.Step_passive;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Step_passive");
        return icon;
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull Shape a) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        ScaleContext scaleContext = this.getScaleContext();
        if (scaleContext == null) {
            super.paint(g, a);
            return;
        }
        Rectangle bounds = a.getBounds();
        double width = super.getPreferredSpan(0);
        double height = super.getPreferredSpan(1);
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        BufferedImage bufferedImage = ImageUtil.createImage(ScaleContext.Companion.createIdentity(), width, height, 2, PaintUtil.RoundingMode.ROUND);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage image = bufferedImage;
        Graphics2D graphics = image.createGraphics();
        super.paint(graphics, new Rectangle(image.getWidth(), image.getHeight()));
        Image image2 = ImageUtil.ensureHiDPI(image, scaleContext);
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"ensureHiDPI(...)");
        StartupUiUtil.drawImage(g, image2, bounds.x, bounds.y, null);
    }
}

