/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.html;

import com.intellij.util.ui.html.UtilsKt;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/util/ui/html/ImageViewPreferredSpan;", "", "view", "Ljavax/swing/text/View;", "getBaseSpan", "Lkotlin/Function1;", "", "", "<init>", "(Ljavax/swing/text/View;Lkotlin/jvm/functions/Function1;)V", "myAvailableWidth", "get", "axis", "intellij.platform.util.ui"})
public final class ImageViewPreferredSpan {
    @NotNull
    private final View view;
    @NotNull
    private final Function1<Integer, Float> getBaseSpan;
    private int myAvailableWidth;

    public ImageViewPreferredSpan(@NotNull View view, @NotNull Function1<? super Integer, Float> getBaseSpan) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(getBaseSpan, (String)"getBaseSpan");
        this.view = view;
        this.getBaseSpan = getBaseSpan;
    }

    public final float get(int axis) {
        float baseSpan = ((Number)this.getBaseSpan.invoke((Object)axis)).floatValue();
        if (axis == 0) {
            return baseSpan;
        }
        int availableWidth = UtilsKt.access$getAvailableWidth(this.view);
        if (availableWidth <= 0) {
            return baseSpan;
        }
        float baseXSpan = ((Number)this.getBaseSpan.invoke((Object)0)).floatValue();
        if (baseXSpan <= 0.0f) {
            return baseSpan;
        }
        if ((float)availableWidth > baseXSpan) {
            availableWidth = (int)baseXSpan;
        }
        if (this.myAvailableWidth > 0 && availableWidth != this.myAvailableWidth) {
            this.view.preferenceChanged(null, false, true);
        }
        this.myAvailableWidth = availableWidth;
        return baseSpan * (float)availableWidth / baseXSpan;
    }
}

