/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Hash;

final class StrippedIntToIntMap {
    private final int[] keys;
    private final int[] values;
    private final transient int mask;
    private transient boolean containsNullKey;

    private StrippedIntToIntMap(int expected, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be non-negative");
        }
        int n = Hash.arraySize((int)expected, (float)loadFactor);
        this.mask = n - 1;
        this.keys = new int[n + 1];
        this.values = new int[this.keys.length + 1];
    }

    StrippedIntToIntMap(int[] metadata) {
        this(metadata.length / 2, 0.5f);
        for (int i = 0; i < metadata.length; i += 2) {
            this.add(metadata[i], metadata[i + 1]);
        }
    }

    private void add(int k, int v) {
        if (k == 0) {
            if (this.containsNullKey) {
                return;
            }
            this.containsNullKey = true;
            this.values[this.keys.length] = v;
        } else {
            int index = k & this.mask;
            int curr = this.keys[index];
            if (curr != 0) {
                if (curr == k) {
                    return;
                }
                while ((curr = this.keys[index = index + 1 & this.mask]) != 0) {
                    if (curr != k) continue;
                    return;
                }
            }
            this.keys[index] = k;
            this.values[index] = v;
        }
    }

    public int get(int k) {
        if (k == 0) {
            return this.containsNullKey ? this.values[this.keys.length] : -1;
        }
        int index = k & this.mask;
        int curr = this.keys[index];
        if (curr == 0) {
            return -1;
        }
        if (k == curr) {
            return this.values[index];
        }
        do {
            if ((curr = this.keys[index = index + 1 & this.mask]) != 0) continue;
            return -1;
        } while (k != curr);
        return this.values[index];
    }
}

