/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class ThreadLocalCachedValue<T> {
    private final ThreadLocal<java.lang.ref.SoftReference<T>> myThreadLocal = new ThreadLocal();

    public T getValue() {
        Object value = SoftReference.dereference((Reference)this.myThreadLocal.get());
        if (value == null) {
            value = this.create();
            this.myThreadLocal.set(new java.lang.ref.SoftReference<Object>(value));
        } else {
            this.init(value);
        }
        return (T)value;
    }

    protected void init(@NotNull T value) {
        if (value == null) {
            ThreadLocalCachedValue.$$$reportNull$$$0(0);
        }
    }

    @NotNull
    protected abstract T create();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/ThreadLocalCachedValue", "init"));
    }
}

