/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class IndexStorageLockingBase {
    public static final boolean MAKE_INDEX_LOOKUP_CANCELLABLE = SystemProperties.getBooleanProperty((String)"intellij.index.cancellable-lookup", (boolean)true);
    private final ThreadLocal<Integer> readLockCount = new ThreadLocal();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final transient LockStamp readLockUnlockHandle = () -> {
        Integer count = this.readLockCount.get();
        if (count != null) {
            if (count <= 1) {
                this.readLockCount.remove();
            } else {
                this.readLockCount.set(count - 1);
            }
        }
        this.lock.readLock().unlock();
    };
    private final transient LockStamp writeLockUnlockHandle = this.lock.writeLock()::unlock;

    protected IndexStorageLockingBase() {
    }

    @NotNull
    protected LockStamp lockForRead() throws CancellationException {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        if (MAKE_INDEX_LOOKUP_CANCELLABLE) {
            IndexStorageLockingBase.lockMaybeCancellable(readLock);
        } else {
            readLock.lock();
        }
        this.readLockCount.set(this.readLockCount.get() == null ? 1 : this.readLockCount.get() + 1);
        LockStamp lockStamp = this.readLockUnlockHandle;
        if (lockStamp == null) {
            IndexStorageLockingBase.$$$reportNull$$$0(0);
        }
        return lockStamp;
    }

    /*
     * Exception decompiling
     */
    private static void lockMaybeCancellable(@NotNull Lock lock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @ApiStatus.Internal
    public boolean isReadLockHeldByCurrentThread() {
        Integer count = this.readLockCount.get();
        return count != null && count > 0;
    }

    @NotNull
    protected LockStamp lockForWrite() {
        if (this.isReadLockHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot acquire write lock while read lock is held");
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lock();
        LockStamp lockStamp = this.writeLockUnlockHandle;
        if (lockStamp == null) {
            IndexStorageLockingBase.$$$reportNull$$$0(2);
        }
        return lockStamp;
    }

    protected <R, E extends Exception> R withReadLock(@NotNull ThrowableComputable<R, E> computation) throws E {
        if (computation == null) {
            IndexStorageLockingBase.$$$reportNull$$$0(3);
        }
        try (LockStamp ignored = this.lockForRead();){
            Object object = computation.compute();
            return (R)object;
        }
    }

    protected <E extends Exception> void withReadLock(@NotNull ThrowableRunnable<E> computation) throws E {
        if (computation == null) {
            IndexStorageLockingBase.$$$reportNull$$$0(4);
        }
        try (LockStamp ignored = this.lockForRead();){
            computation.run();
        }
    }

    protected <E extends Exception> void withWriteLock(@NotNull ThrowableRunnable<E> computation) throws E {
        if (computation == null) {
            IndexStorageLockingBase.$$$reportNull$$$0(5);
        }
        try (LockStamp ignored = this.lockForWrite();){
            computation.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/IndexStorageLockingBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "lockForRead";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/IndexStorageLockingBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "lockForWrite";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "lockMaybeCancellable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withReadLock";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withWriteLock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface LockStamp
    extends AutoCloseable {
        @Override
        public void close();
    }
}

