// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.util.indexing;

/**
 * An exception intended to report that {@link InvertedIndex} storage looks like corrupted and should be rebuilt.
 */
public final class StorageException extends Exception {
  public StorageException(final String message) {
    super(message);
  }

  public StorageException(String message, Throwable cause) {
    super(message, cause);
  }

  public StorageException(Throwable cause) {
    super(cause);
  }
}
