/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.CeProcessCanceledException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.DebugAttachDetectorArgs;
import com.intellij.util.progress.JfrCancellationEventsCallbackHolder;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.NonCancellable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class Cancellation {
    private static final ThreadLocal<DebugNonCancellableState> debugIsInNonCancelableSection = new ThreadLocal();

    private Cancellation() {
    }

    @VisibleForTesting
    @Nullable
    public static Job currentJob() {
        return (Job)ThreadContext.currentThreadContext().get((CoroutineContext.Key)Job.Key);
    }

    public static void checkCancelled() {
        if (Cancellation.isInNonCancelableSection()) {
            JfrCancellationEventsCallbackHolder.nonCancellableSectionInvoked();
            return;
        }
        try {
            Cancellation.ensureActive();
            JfrCancellationEventsCallbackHolder.cancellableSectionInvoked(false);
        }
        catch (ProcessCanceledException e) {
            JfrCancellationEventsCallbackHolder.cancellableSectionInvoked(true);
            throw e;
        }
    }

    @ApiStatus.Internal
    public static void ensureActive() {
        ThreadContext.warnAccidentalCancellation();
        Job currentJob = Cancellation.currentJob();
        if (currentJob != null) {
            try {
                JobKt.ensureActive((Job)currentJob);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (CancellationException e) {
                throw new CeProcessCanceledException(e);
            }
        }
    }

    @ApiStatus.Obsolete
    public static boolean isInNonCancelableSection() {
        if (Cancellation.isInNonCancelableSectionInternal()) {
            return true;
        }
        if (!DebugNonCancellableState.isDebugEnabled) {
            return false;
        }
        if (!DebugNonCancellableState.isAttached()) {
            return false;
        }
        DebugNonCancellableState state = debugIsInNonCancelableSection.get();
        return state != null && state.inNonCancelableSection;
    }

    private static boolean isInNonCancelableSectionInternal() {
        CoroutineContext context = ThreadContext.currentThreadContext();
        Job job2 = (Job)context.get((CoroutineContext.Key)Job.Key);
        return job2 != null && Cancellation.checkIfCurrentJobIsNonCancellable(job2);
    }

    private static boolean checkIfCurrentJobIsNonCancellable(@NotNull Job job2) {
        if (job2 == null) {
            Cancellation.$$$reportNull$$$0(0);
        }
        return job2 == NonCancellable.INSTANCE;
    }

    public static <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            Cancellation.$$$reportNull$$$0(1);
        }
        if (Cancellation.isInNonCancelableSectionInternal()) {
            return (T)computable.compute();
        }
        try (@NotNull AccessToken ignored = ThreadContext.installThreadContext(ThreadContext.currentThreadContext().plus((CoroutineContext)NonCancellable.INSTANCE), true);){
            Object object = computable.compute();
            return (T)object;
        }
    }

    public static void executeInNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            Cancellation.$$$reportNull$$$0(2);
        }
        Cancellation.computeInNonCancelableSection(() -> {
            runnable.run();
            return null;
        });
    }

    @NotNull
    public static AccessToken withNonCancelableSection() {
        if (Cancellation.isInNonCancelableSectionInternal()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                Cancellation.$$$reportNull$$$0(3);
            }
            return accessToken;
        }
        AccessToken accessToken = ThreadContext.installThreadContext(ThreadContext.currentThreadContext().plus((CoroutineContext)NonCancellable.INSTANCE), true);
        if (accessToken == null) {
            Cancellation.$$$reportNull$$$0(4);
        }
        return accessToken;
    }

    @Deprecated
    @ApiStatus.Internal
    public static <T> T forceNonCancellableSectionInClassInitializer(@NotNull Supplier<T> computable) {
        if (computable == null) {
            Cancellation.$$$reportNull$$$0(5);
        }
        return Cancellation.computeInNonCancelableSection(computable::get);
    }

    @NotNull
    private static DebugNonCancellableState initThreadNonCancellableState() {
        DebugNonCancellableState state = debugIsInNonCancelableSection.get();
        if (state != null) {
            DebugNonCancellableState debugNonCancellableState = state;
            if (debugNonCancellableState == null) {
                Cancellation.$$$reportNull$$$0(6);
            }
            return debugNonCancellableState;
        }
        state = new DebugNonCancellableState();
        debugIsInNonCancelableSection.set(state);
        DebugNonCancellableState debugNonCancellableState = state;
        if (debugNonCancellableState == null) {
            Cancellation.$$$reportNull$$$0(7);
        }
        return debugNonCancellableState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/Cancellation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/Cancellation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withNonCancelableSection";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "initThreadNonCancellableState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkIfCurrentJobIsNonCancellable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeInNonCancelableSection";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "executeInNonCancelableSection";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forceNonCancellableSectionInClassInitializer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DebugNonCancellableState {
        private static final int ATTACH_CHECK_TIMEOUT_S = 2;
        private static final boolean isDebugEnabled = DebugAttachDetectorArgs.isDebugEnabled();
        private static volatile long lastUpdateNs = System.nanoTime();
        private static volatile boolean isDebugAttached = DebugAttachDetectorArgs.isAttached();
        private volatile boolean inNonCancelableSection = false;

        private DebugNonCancellableState() {
        }

        private static boolean isAttached() {
            long current = System.nanoTime();
            if (TimeUnit.NANOSECONDS.toSeconds(current - lastUpdateNs) > 2L) {
                lastUpdateNs = current;
                isDebugAttached = DebugAttachDetectorArgs.isAttached();
            }
            return isDebugAttached;
        }
    }
}

