/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers.hash;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class LongLinkedHashMap<V> {
    private static final long NULL_KEY = 0L;
    private Entry<V>[] table;
    private Entry<V> top;
    private Entry<V> back;
    private int capacity;
    private int size;
    private final float loadFactor;
    private final boolean accessOrder;

    public LongLinkedHashMap(int capacity, float loadFactor, boolean accessOrder) {
        this.loadFactor = loadFactor;
        this.clear(capacity);
        this.accessOrder = accessOrder;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.clear(0);
    }

    public V get(long key) {
        Entry<V>[] table = this.table;
        int hash = LongLinkedHashMap.hashCode(key);
        int index = hash % table.length;
        Entry e = table[index];
        while (e != null) {
            if (e.keyHash == hash && e.key == key) {
                this.moveToTop(e);
                return (V)e.value;
            }
            e = e.hashNext;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public V put(long key, @NotNull V v) {
        void value;
        if (v == null) {
            LongLinkedHashMap.$$$reportNull$$$0(0);
        }
        Entry<V>[] table = this.table;
        int hash = LongLinkedHashMap.hashCode(key);
        int index = hash % table.length;
        Entry<void> e = table[index];
        while (e != null) {
            if (((Entry)e).keyHash == hash && ((Entry)e).key == key) {
                this.moveToTop(e);
                return e.setValue(value);
            }
            e = ((Entry)e).hashNext;
        }
        e = new Entry<void>(key, value, hash);
        ((Entry)e).hashNext = (Entry)table[index];
        table[index] = e;
        Entry<V> top = this.top;
        ((Entry)e).next = (Entry)top;
        if (top != null) {
            ((Entry)top).previous = (Entry)e;
        } else {
            this.back = e;
        }
        this.top = e;
        ++this.size;
        if (this.removeEldestEntry(this.back)) {
            this.doRemoveEldestEntry();
        } else if (this.size > this.capacity) {
            this.rehash((int)((float)this.capacity * 1.618034f));
        }
        return null;
    }

    public void doRemoveEldestEntry() {
        V val = this.remove(((Entry)this.back).key);
        assert (val != null) : "Entry was not removed. Possibly mutable key: " + Entry.access$200(this.back);
    }

    public boolean containsKey(long key) {
        return this.get(key) != null;
    }

    public V remove(long key) {
        Entry<V>[] table = this.table;
        int hash = LongLinkedHashMap.hashCode(key);
        int index = hash % table.length;
        Entry e = table[index];
        if (e == null) {
            return null;
        }
        if (e.keyHash == hash && e.key == key) {
            table[index] = e.hashNext;
        } else {
            Entry last;
            do {
                last = e;
                if ((e = e.hashNext) != null) continue;
                return null;
            } while (e.keyHash != hash || e.key != key);
            last.hashNext = e.hashNext;
        }
        this.unlink(e);
        --this.size;
        return (V)e.value;
    }

    @NotNull
    public Collection<V> values() {
        return new Values();
    }

    protected boolean removeEldestEntry(Entry<V> eldest) {
        return false;
    }

    private void init(int capacity) {
        this.table = new Entry[HashCommon.arraySize((int)capacity, (float)this.loadFactor)];
        this.back = null;
        this.top = null;
        this.capacity = capacity;
    }

    private void clear(int capacity) {
        if (capacity < 5) {
            capacity = 5;
        }
        this.init(capacity);
        this.size = 0;
    }

    public long getLastKey() {
        return this.top != null ? ((Entry)this.top).key : 0L;
    }

    @Nullable
    public V getLastValue() {
        return (V)(this.top != null ? ((Entry)this.top).value : null);
    }

    public long getFirstKey() {
        return this.back != null ? ((Entry)this.back).key : 0L;
    }

    private void moveToTop(Entry<V> e) {
        if (!this.accessOrder) {
            return;
        }
        Entry<V> top = this.top;
        if (top != e) {
            Entry prev = ((Entry)e).previous;
            Entry next = ((Entry)e).next;
            prev.next = next;
            if (next != null) {
                next.previous = prev;
            } else {
                this.back = prev;
            }
            ((Entry)top).previous = (Entry)e;
            ((Entry)e).next = (Entry)top;
            ((Entry)e).previous = null;
            this.top = e;
        }
    }

    private void unlink(Entry<V> e) {
        Entry prev = ((Entry)e).previous;
        Entry next = ((Entry)e).next;
        if (prev != null) {
            prev.next = next;
        } else {
            this.top = next;
        }
        if (next != null) {
            next.previous = prev;
        } else {
            this.back = prev;
        }
        ((Entry)e).previous = null;
        ((Entry)e).next = null;
    }

    private void rehash(int capacity) {
        this.table = new Entry[HashCommon.arraySize((int)capacity, (float)this.loadFactor)];
        this.capacity = capacity;
        Entry<V>[] table = this.table;
        int tableLen = table.length;
        Entry e = this.back;
        while (e != null) {
            int hash = e.keyHash % tableLen;
            e.hashNext = (Entry)table[hash];
            table[hash] = e;
            e = e.previous;
        }
    }

    @NotNull
    public Set<Entry<V>> entrySet() {
        return new EntrySet();
    }

    private boolean containsValue(Object value) {
        for (Entry<V> entry : this.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    private static int hashCode(long value) {
        return Long.hashCode(value) & Integer.MAX_VALUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/hash/LongLinkedHashMap", "put"));
    }

    public static final class Entry<V> {
        private final long key;
        private final int keyHash;
        private V value;
        private Entry<V> next;
        private Entry<V> previous;
        private Entry<V> hashNext;

        Entry(long key, V value, int hash) {
            this.key = key;
            this.keyHash = hash;
            this.value = value;
        }

        public long getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value) {
            V result = this.value;
            this.value = value;
            return result;
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            return new LinkedHashIterator<V>(){

                @Override
                public V next() {
                    return this.nextEntry().value;
                }
            };
        }

        @Override
        public int size() {
            return LongLinkedHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return LongLinkedHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            LongLinkedHashMap.this.clear();
        }
    }

    private final class EntrySet
    extends AbstractSet<Entry<V>> {
        private EntrySet() {
        }

        @Override
        @NotNull
        public Iterator<Entry<V>> iterator() {
            return new LinkedHashIterator<Entry<V>>(){

                @Override
                public Entry<V> next() {
                    return this.nextEntry();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object value = LongLinkedHashMap.this.get(e.getKey());
            return value != null && value.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return LongLinkedHashMap.this.remove(e.getKey()) != null;
        }

        @Override
        public int size() {
            return LongLinkedHashMap.this.size;
        }

        @Override
        public void clear() {
            LongLinkedHashMap.this.clear();
        }
    }

    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        private Entry<V> e;
        private Entry<V> last;

        private LinkedHashIterator() {
            this.e = LongLinkedHashMap.this.back;
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LongLinkedHashMap.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry<V> nextEntry() {
            this.last = this.e;
            Entry result = this.last;
            this.e = result.previous;
            return result;
        }
    }
}

