/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.fasterxml.aalto.UncheckedStreamException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SafeStAXStreamBuilderKt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.xml.dom.StaxFactory;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalNameException;
import org.jdom.JDOMException;
import org.jdom.JDOMInterner;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JDOMUtil {
    @NonNls
    private static final String X = "x";
    @NonNls
    private static final String Y = "y";
    @NonNls
    private static final String WIDTH = "width";
    @NonNls
    private static final String HEIGHT = "height";
    public static final Pattern XPOINTER_PATTERN = Pattern.compile("xpointer\\((.*)\\)");
    public static final Namespace XINCLUDE_NAMESPACE = Namespace.getNamespace((String)"xi", (String)"http://www.w3.org/2001/XInclude");
    public static final Pattern CHILDREN_PATTERN = Pattern.compile("/([^/]*)(/[^/]*)?/\\*");
    private static final Predicate<Content> CONTENT_FILTER = content -> !(content instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)((Text)content).getText());
    @NotNull
    private static final Format DEFAULT_FORMAT = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setLineSeparator("\n");

    private JDOMUtil() {
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent) {
        List list = parent == null ? Collections.emptyList() : parent.getChildren();
        if (list == null) {
            JDOMUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent, @NotNull String name) {
        if (name == null) {
            JDOMUtil.$$$reportNull$$$0(1);
        }
        if (parent != null) {
            List list = parent.getChildren(name);
            if (list == null) {
                JDOMUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<Element> list = Collections.emptyList();
        if (list == null) {
            JDOMUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static Logger getLogger() {
        return LoggerHolder.LOG;
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2) {
        return JDOMUtil.areElementsEqual(e1, e2, false);
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2, boolean ignoreEmptyAttrValues) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return Objects.equals(e1.getName(), e2.getName()) && JDOMUtil.isAttributesEqual(JDOMUtil.getAttributes(e1), JDOMUtil.getAttributes(e2), ignoreEmptyAttrValues) && JDOMUtil.areElementContentsEqual(e1, e2, ignoreEmptyAttrValues);
    }

    public static int hashCode(@Nullable Element e, boolean ignoreEmptyAttrValues) {
        if (e == null) {
            return 0;
        }
        int hashCode = e.getName().hashCode();
        for (Attribute attribute : JDOMUtil.getAttributes(e)) {
            String value = attribute.getValue();
            if (ignoreEmptyAttrValues && (value == null || value.isEmpty())) continue;
            hashCode = hashCode * 31 * 31 + attribute.getName().hashCode() * 31 + value.hashCode();
        }
        for (Content content : e.getContent()) {
            if (!CONTENT_FILTER.test(content)) continue;
            int contentHash = content instanceof Element ? JDOMUtil.hashCode((Element)content, ignoreEmptyAttrValues) : e.getValue().hashCode();
            hashCode = hashCode * 31 + contentHash;
        }
        return hashCode;
    }

    private static boolean areElementContentsEqual(@NotNull Element e1, @NotNull Element e2, boolean ignoreEmptyAttrValues) {
        if (e1 == null) {
            JDOMUtil.$$$reportNull$$$0(4);
        }
        if (e2 == null) {
            JDOMUtil.$$$reportNull$$$0(5);
        }
        Iterator<Content> l1 = FilteringIterator.create(e1.getContent().iterator(), CONTENT_FILTER);
        Iterator<Content> l2 = FilteringIterator.create(e2.getContent().iterator(), CONTENT_FILTER);
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual(l1.next(), l2.next(), ignoreEmptyAttrValues)) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static Element @NotNull [] getElements(@NotNull Element m) {
        if (m == null) {
            JDOMUtil.$$$reportNull$$$0(6);
        }
        List list = m.getChildren();
        Element[] elementArray = list.toArray(new Element[0]);
        if (elementArray == null) {
            JDOMUtil.$$$reportNull$$$0(7);
        }
        return elementArray;
    }

    @NotNull
    public static String legalizeText(@NotNull String str) {
        if (str == null) {
            JDOMUtil.$$$reportNull$$$0(8);
        }
        String string = JDOMUtil.legalizeChars(str).toString();
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static CharSequence legalizeChars(@NotNull CharSequence str) {
        if (str == null) {
            JDOMUtil.$$$reportNull$$$0(10);
        }
        StringBuilder result = new StringBuilder(str.length());
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            JDOMUtil.appendLegalized(result, str.charAt(i));
        }
        StringBuilder stringBuilder = result;
        if (stringBuilder == null) {
            JDOMUtil.$$$reportNull$$$0(11);
        }
        return stringBuilder;
    }

    private static void appendLegalized(@NotNull @NonNls StringBuilder sb, char each) {
        if (sb == null) {
            JDOMUtil.$$$reportNull$$$0(12);
        }
        if (each == '<' || each == '>') {
            sb.append(each == '<' ? "&lt;" : "&gt;");
        } else if (!Verifier.isXMLCharacter((int)each)) {
            String s = Long.toHexString(each);
            sb.append("0x").append(s.toUpperCase(Locale.ENGLISH));
        } else {
            sb.append(each);
        }
    }

    private static boolean contentsEqual(Content c1, Content c2, boolean ignoreEmptyAttrValues) {
        if (!(c1 instanceof Element) && !(c2 instanceof Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof Element && c2 instanceof Element && JDOMUtil.areElementsEqual((Element)c1, (Element)c2, ignoreEmptyAttrValues);
    }

    private static boolean isAttributesEqual(@NotNull List<? extends Attribute> l1, @NotNull List<? extends Attribute> l2, boolean ignoreEmptyAttrValues) {
        if (l1 == null) {
            JDOMUtil.$$$reportNull$$$0(13);
        }
        if (l2 == null) {
            JDOMUtil.$$$reportNull$$$0(14);
        }
        if (ignoreEmptyAttrValues) {
            l1 = JDOMUtil.getNotEmptyAttributes(l1);
            l2 = JDOMUtil.getNotEmptyAttributes(l2);
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (JDOMUtil.attributesEqual(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<? extends Attribute> getNotEmptyAttributes(@NotNull List<? extends Attribute> list) {
        if (list == null) {
            JDOMUtil.$$$reportNull$$$0(15);
        }
        if (list.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                JDOMUtil.$$$reportNull$$$0(16);
            }
            return list2;
        }
        ArrayList<Attribute> result = null;
        for (Attribute attribute : list) {
            String s = attribute.getValue();
            if (s == null || s.isEmpty()) continue;
            if (result == null) {
                result = new ArrayList<Attribute>(list.size());
            }
            result.add(attribute);
        }
        List<Object> list3 = result == null ? Collections.emptyList() : result;
        if (list3 == null) {
            JDOMUtil.$$$reportNull$$$0(17);
        }
        return list3;
    }

    private static boolean attributesEqual(@NotNull Attribute a1, @NotNull Attribute a2) {
        if (a1 == null) {
            JDOMUtil.$$$reportNull$$$0(18);
        }
        if (a2 == null) {
            JDOMUtil.$$$reportNull$$$0(19);
        }
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static Document loadDocumentUsingStaX(@NotNull InputStream stream) throws JDOMException, IOException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(20);
        }
        XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader((InputStream)stream, null);
        Document document = SafeStAXStreamBuilderKt.buildJdomDocument(xmlStreamReader);
        xmlStreamReader.close();
        Document document2 = document;
        if (document2 == null) {
            JDOMUtil.$$$reportNull$$$0(21);
        }
        return document2;
        {
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (UncheckedStreamException | XMLStreamException | IllegalNameException e) {
                    throw new JDOMException(e.getMessage(), e);
                }
            }
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static Element loadUsingStaX(@NotNull InputStream stream, @Nullable String filePathForErrorMessage) throws JDOMException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(22);
        }
        XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader((InputStream)stream, null);
        Element element = SafeStAXStreamBuilderKt.buildJdom(xmlStreamReader, true);
        xmlStreamReader.close();
        Element element2 = element;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(23);
        }
        return element2;
        {
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (UncheckedStreamException | XMLStreamException | IllegalNameException e) {
                    String message = e.getMessage();
                    if (filePathForErrorMessage != null) {
                        message = message + ", file: " + filePathForErrorMessage;
                    }
                    throw new JDOMException(message, e);
                }
            }
        }
    }

    @NotNull
    public static Element load(@NotNull CharSequence seq) throws IOException, JDOMException {
        if (seq == null) {
            JDOMUtil.$$$reportNull$$$0(24);
        }
        Element element = JDOMUtil.load((Reader)new CharSequenceReader(seq));
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(25);
        }
        return element;
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull File file) throws JDOMException, IOException {
        if (file == null) {
            JDOMUtil.$$$reportNull$$$0(26);
        }
        return JDOMUtil.loadDocumentUsingStaX(new FileInputStream(file));
    }

    @NotNull
    public static Element load(@NotNull File file) throws JDOMException, IOException {
        if (file == null) {
            JDOMUtil.$$$reportNull$$$0(27);
        }
        return JDOMUtil.loadUsingStaX(new FileInputStream(file), file.getAbsolutePath());
    }

    @NotNull
    public static Element load(@NotNull Path file) throws JDOMException, IOException {
        if (file == null) {
            JDOMUtil.$$$reportNull$$$0(28);
        }
        try {
            return JDOMUtil.loadUsingStaX(Files.newInputStream(file, new OpenOption[0]), file.toString());
        }
        catch (ClosedFileSystemException e) {
            throw new IOException("Cannot read file from closed file system: " + file, e);
        }
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull InputStream stream) throws JDOMException, IOException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(29);
        }
        return JDOMUtil.loadDocumentUsingStaX(stream);
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(Reader reader) throws JDOMException, IOException {
        Element element;
        if (reader == null) {
            return null;
        }
        XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader((Reader)reader);
        try {
            element = SafeStAXStreamBuilderKt.buildJdom(xmlStreamReader, true);
        }
        catch (Throwable throwable) {
            try {
                xmlStreamReader.close();
                throw throwable;
            }
            catch (UncheckedStreamException | XMLStreamException | IllegalNameException e) {
                throw new JDOMException(e.getMessage(), e);
            }
        }
        xmlStreamReader.close();
        return element;
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(InputStream stream) throws JDOMException, IOException {
        return stream == null ? null : JDOMUtil.loadUsingStaX(stream, null);
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static Element load(byte @NotNull [] data) throws JDOMException, IOException {
        if (data == null) {
            JDOMUtil.$$$reportNull$$$0(30);
        }
        XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader((byte[])data);
        Element element = SafeStAXStreamBuilderKt.buildJdom(xmlStreamReader, true);
        xmlStreamReader.close();
        Element element2 = element;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(31);
        }
        return element2;
        {
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (UncheckedStreamException | XMLStreamException | IllegalNameException e) {
                    throw new JDOMException(e.getMessage(), e);
                }
            }
        }
    }

    @NotNull
    public static Element load(@NotNull Class<?> clazz, @NotNull String resource) throws JDOMException, IOException {
        InputStream stream;
        if (clazz == null) {
            JDOMUtil.$$$reportNull$$$0(32);
        }
        if (resource == null) {
            JDOMUtil.$$$reportNull$$$0(33);
        }
        if ((stream = clazz.getResourceAsStream(resource)) == null) {
            throw new FileNotFoundException(resource);
        }
        Element element = JDOMUtil.load(stream);
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(34);
        }
        return element;
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(35);
        }
        return JDOMUtil.loadDocumentUsingStaX(URLUtil.openStream(url));
    }

    @NotNull
    public static Element load(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(36);
        }
        Element element = JDOMUtil.load(URLUtil.openStream(url));
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(37);
        }
        return element;
    }

    @NotNull
    public static Element loadResource(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(38);
        }
        Element element = JDOMUtil.load(URLUtil.openResourceStream(url));
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(39);
        }
        return element;
    }

    public static void writeDocument(@NotNull Document document, @NotNull String filePath, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(40);
        }
        if (filePath == null) {
            JDOMUtil.$$$reportNull$$$0(41);
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePath));){
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
    }

    @Deprecated
    public static void writeDocument(@NotNull Document document, @NotNull File file, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(42);
        }
        if (file == null) {
            JDOMUtil.$$$reportNull$$$0(43);
        }
        JDOMUtil.write((Parent)document, file, lineSeparator);
    }

    public static void write(@NotNull Element element, @NotNull Path file) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(44);
        }
        if (file == null) {
            JDOMUtil.$$$reportNull$$$0(45);
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            JDOMUtil.createOutputter("\n").output(element, (Writer)writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    public static void write(@NotNull Parent element, @NotNull File file) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(46);
        }
        if (file == null) {
            JDOMUtil.$$$reportNull$$$0(47);
        }
        JDOMUtil.write(element, file, "\n");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void write(@NotNull Parent element, @NotNull File file, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(48);
        }
        if (file == null) {
            JDOMUtil.$$$reportNull$$$0(49);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(50);
        }
        FileUtilRt.createParentDirs((File)file);
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            JDOMUtil.write(element, stream, lineSeparator);
        }
    }

    public static void write(@NotNull Element element, @NotNull Path file, @NotNull String lineSeparator) throws IOException {
        Path parent;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(51);
        }
        if (file == null) {
            JDOMUtil.$$$reportNull$$$0(52);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(53);
        }
        if ((parent = file.getParent()) != null) {
            NioFiles.createDirectories(parent);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            JDOMUtil.createOutputter(lineSeparator).output(element, (Writer)writer);
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull OutputStream stream, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(54);
        }
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(55);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            JDOMUtil.writeDocument(document, writer, lineSeparator);
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull Path file) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(56);
        }
        if (file == null) {
            JDOMUtil.$$$reportNull$$$0(57);
        }
        JDOMUtil.writeDocument(document, file, "\n");
    }

    public static void writeDocument(@NotNull Document document, @NotNull Path file, String lineSeparator) throws IOException {
        Path parent;
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(58);
        }
        if (file == null) {
            JDOMUtil.$$$reportNull$$$0(59);
        }
        if ((parent = file.getParent()) != null) {
            NioFiles.createDirectories(parent);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            JDOMUtil.writeDocument(document, writer, lineSeparator);
        }
    }

    public static void write(@NotNull Parent element, @NotNull OutputStream stream) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(60);
        }
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(61);
        }
        JDOMUtil.write(element, stream, "\n");
    }

    public static void write(@NotNull Parent element, @NotNull OutputStream stream, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(62);
        }
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(63);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(64);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            if (element instanceof Document) {
                JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
            } else {
                JDOMUtil.writeElement((Element)element, writer, lineSeparator);
            }
        }
    }

    @NotNull
    public static String writeDocument(@NotNull Document document) {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(65);
        }
        return JDOMUtil.writeDocument(document, "\n");
    }

    @NotNull
    public static String writeDocument(@NotNull Document document, String lineSeparator) {
        String string;
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(66);
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeDocument(document, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException ignored) {
            return "";
        }
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(67);
        }
        return string;
    }

    @NotNull
    public static String write(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(68);
        }
        return JDOMUtil.writeElement(element);
    }

    @NotNull
    public static String write(@NotNull Parent element, String lineSeparator) {
        String string;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(69);
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.write(element, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(70);
        }
        return string;
    }

    public static void write(Parent element, Writer writer, String lineSeparator) throws IOException {
        if (element instanceof Element) {
            JDOMUtil.writeElement((Element)element, writer, lineSeparator);
        } else if (element instanceof Document) {
            JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
        }
    }

    public static void writeElement(@NotNull Element element, Writer writer, String lineSeparator) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(71);
        }
        try {
            JDOMUtil.createOutputter(lineSeparator).output(element, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    @NotNull
    public static String writeElement(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(72);
        }
        return JDOMUtil.writeElement(element, "\n");
    }

    @NotNull
    public static String writeElement(@NotNull Element element, String lineSeparator) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(73);
        }
        StringWriter writer = new StringWriter();
        try {
            JDOMUtil.createOutputter(lineSeparator).output(element, (Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
        String string = writer.toString();
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(74);
        }
        return string;
    }

    @NotNull
    public static String writeChildren(@NotNull Element element, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(75);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(76);
        }
        StringWriter writer = new StringWriter();
        for (Element child : element.getChildren()) {
            JDOMUtil.writeElement(child, writer, lineSeparator);
            writer.append(lineSeparator);
        }
        String string = writer.toString();
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(77);
        }
        return string;
    }

    private static void writeDocument(@NotNull Document document, @NotNull Writer writer, String lineSeparator) throws IOException {
        if (document == null) {
            JDOMUtil.$$$reportNull$$$0(78);
        }
        if (writer == null) {
            JDOMUtil.$$$reportNull$$$0(79);
        }
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(document, writer);
        }
        catch (NullPointerException e) {
            JDOMUtil.getLogger().error(e);
            JDOMUtil.printDiagnostics(document.getRootElement(), "");
        }
    }

    @NotNull
    public static Format createFormat(@Nullable String lineSeparator) {
        if (lineSeparator == null || lineSeparator.equals("\n")) {
            Format format = DEFAULT_FORMAT;
            if (format == null) {
                JDOMUtil.$$$reportNull$$$0(80);
            }
            return format;
        }
        Format format = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setLineSeparator(lineSeparator);
        if (format == null) {
            JDOMUtil.$$$reportNull$$$0(81);
        }
        return format;
    }

    @ApiStatus.Internal
    @NotNull
    public static XMLOutputter createOutputter(@Nullable String lineSeparator) {
        return new MyXMLOutputter(lineSeparator);
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeText(@NotNull String text) {
        if (text == null) {
            JDOMUtil.$$$reportNull$$$0(82);
        }
        return JDOMUtil.escapeText(text, false, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text == null) {
            JDOMUtil.$$$reportNull$$$0(83);
        }
        return JDOMUtil.escapeText(text, false, escapeSpaces, escapeLineEnds);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text == null) {
            JDOMUtil.$$$reportNull$$$0(84);
        }
        StringBuilder buffer = null;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            buffer = XmlStringUtil.appendEscapedSymbol(text, buffer, i, quotation, ch);
        }
        String string = buffer == null ? text : buffer.toString();
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(85);
        }
        return string;
    }

    private static void printDiagnostics(@NotNull Element element, String prefix) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(86);
        }
        ElementInfo info = JDOMUtil.getElementInfo(element);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        for (Element child : element.getChildren()) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(87);
        }
        boolean hasNullAttributes = false;
        StringBuilder buf = new StringBuilder(element.getName());
        List<Attribute> attributes = JDOMUtil.getAttributes(element);
        int length = attributes.size();
        if (length > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                hasNullAttributes = true;
            }
            buf.append("]");
        }
        return new ElementInfo(buf, hasNullAttributes);
    }

    public static void updateFileSet(File @NotNull [] oldFiles, String @NotNull [] newFilePaths, Document @NotNull [] newFileDocuments, String lineSeparator) throws IOException {
        if (oldFiles == null) {
            JDOMUtil.$$$reportNull$$$0(88);
        }
        if (newFilePaths == null) {
            JDOMUtil.$$$reportNull$$$0(89);
        }
        if (newFileDocuments == null) {
            JDOMUtil.$$$reportNull$$$0(90);
        }
        JDOMUtil.getLogger().assertTrue(newFilePaths.length == newFileDocuments.length);
        for (String newFilePath : newFilePaths) {
            File file = new File(newFilePath);
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + newFilePath + "\" is not writeable");
        }
        for (File file : oldFiles) {
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + file.getAbsolutePath() + "\" is not writeable");
        }
        ArrayList<String> writtenFilesPaths = new ArrayList<String>();
        for (int i = 0; i < newFilePaths.length; ++i) {
            String newFilePath = newFilePaths[i];
            JDOMUtil.writeDocument(newFileDocuments[i], newFilePath, lineSeparator);
            writtenFilesPaths.add(newFilePath);
        }
        block3: for (File oldFile : oldFiles) {
            String oldFilePath = oldFile.getAbsolutePath();
            for (String writtenFilesPath : writtenFilesPaths) {
                if (!oldFilePath.equals(writtenFilesPath)) continue;
                continue block3;
            }
            boolean result = oldFile.delete();
            if (result) continue;
            throw new IOException("File \"" + oldFilePath + "\" was not deleted");
        }
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    public static boolean isEmpty(@Nullable Element element) {
        return element == null || element.isEmpty();
    }

    public static boolean isEmpty(@Nullable Element element, int attributeCount) {
        return element == null || JDOMUtil.getAttributes(element).size() == attributeCount && element.getContent().isEmpty();
    }

    @NotNull
    public static List<Attribute> getAttributes(@NotNull Element e) {
        if (e == null) {
            JDOMUtil.$$$reportNull$$$0(91);
        }
        List list = e.hasAttributes() ? e.getAttributes() : Collections.emptyList();
        if (list == null) {
            JDOMUtil.$$$reportNull$$$0(92);
        }
        return list;
    }

    @Contract(value="_, !null -> !null; !null, _ -> !null")
    @Nullable
    public static Element merge(@Nullable Element to, @Nullable Element from) {
        if (from == null) {
            return to;
        }
        if (to == null) {
            return from;
        }
        Iterator<Object> iterator2 = from.getChildren().iterator();
        while (iterator2.hasNext()) {
            Element configuration = (Element)iterator2.next();
            iterator2.remove();
            to.addContent(configuration);
        }
        iterator2 = JDOMUtil.getAttributes(from).iterator();
        while (iterator2.hasNext()) {
            Attribute attribute = (Attribute)iterator2.next();
            iterator2.remove();
            to.setAttribute(attribute);
        }
        return to;
    }

    @NotNull
    public static Element deepMerge(@NotNull Element to, @NotNull Element from) {
        if (to == null) {
            JDOMUtil.$$$reportNull$$$0(93);
        }
        if (from == null) {
            JDOMUtil.$$$reportNull$$$0(94);
        }
        return JDOMUtil.deepMergeWithAttributes(to, from, Collections.emptyList());
    }

    @NotNull
    public static Element deepMergeWithAttributes(@NotNull Element to, @NotNull Element from, @NotNull List<MergeAttribute> mergeByAttributes) {
        if (to == null) {
            JDOMUtil.$$$reportNull$$$0(95);
        }
        if (from == null) {
            JDOMUtil.$$$reportNull$$$0(96);
        }
        if (mergeByAttributes == null) {
            JDOMUtil.$$$reportNull$$$0(97);
        }
        Iterator<Object> iterator2 = from.getChildren().iterator();
        while (iterator2.hasNext()) {
            Element child = (Element)iterator2.next();
            iterator2.remove();
            Element existingChild = to.getChild(child.getName());
            if (existingChild != null && JDOMUtil.isEmpty(existingChild)) {
                to.removeChild(child.getName());
                existingChild = null;
            }
            if (existingChild == null || existingChild.getChildren().isEmpty() || !JDOMUtil.areAttributesEqual(JDOMUtil.getAttributes(existingChild), JDOMUtil.getAttributes(child), existingChild, mergeByAttributes)) {
                to.addContent(child);
                continue;
            }
            JDOMUtil.deepMergeWithAttributes(existingChild, child, mergeByAttributes);
        }
        iterator2 = JDOMUtil.getAttributes(from).iterator();
        while (iterator2.hasNext()) {
            Attribute attribute = (Attribute)iterator2.next();
            iterator2.remove();
            to.setAttribute(attribute);
        }
        Element element = to;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(98);
        }
        return element;
    }

    private static boolean areAttributesEqual(@NotNull List<Attribute> l1, @NotNull List<Attribute> l2, @NotNull Element base, @NotNull List<MergeAttribute> mergeByAttributes) {
        if (l1 == null) {
            JDOMUtil.$$$reportNull$$$0(99);
        }
        if (l2 == null) {
            JDOMUtil.$$$reportNull$$$0(100);
        }
        if (base == null) {
            JDOMUtil.$$$reportNull$$$0(101);
        }
        if (mergeByAttributes == null) {
            JDOMUtil.$$$reportNull$$$0(102);
        }
        HashSet<String> attributes = new HashSet<String>();
        for (MergeAttribute mergeByAttribute : mergeByAttributes) {
            if (!mergeByAttribute.elementName.equals(base.getName())) continue;
            attributes.add(mergeByAttribute.attributeName);
        }
        if (attributes.isEmpty()) {
            return JDOMUtil.isAttributesEqual(l1, l2, false);
        }
        HashMap<String, String> secondMap = new HashMap<String, String>();
        for (Attribute attribute : l2) {
            if (secondMap.put(attribute.getName(), attribute.getValue()) == null) continue;
            throw new IllegalStateException("Duplicate key");
        }
        for (Attribute o : l1) {
            if (!attributes.contains(o.getName()) || o.getValue().equals(secondMap.get(o.getName()))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static Element reduceChildren(@NotNull String name, @NotNull Element parent) {
        List children;
        Iterator it;
        if (name == null) {
            JDOMUtil.$$$reportNull$$$0(103);
        }
        if (parent == null) {
            JDOMUtil.$$$reportNull$$$0(104);
        }
        if (!(it = (children = parent.getChildren(name)).iterator()).hasNext()) {
            return null;
        }
        Element accumulator = (Element)it.next();
        while (it.hasNext()) {
            JDOMUtil.merge(accumulator, (Element)it.next());
            it.remove();
        }
        return accumulator;
    }

    @NotNull
    public static Element internElement(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(105);
        }
        Element element2 = JDOMInterner.INSTANCE.internElement(element);
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(106);
        }
        return element2;
    }

    @NotNull
    public static String removeControlChars(@NotNull String text) {
        if (text == null) {
            JDOMUtil.$$$reportNull$$$0(107);
        }
        StringBuilder result = null;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Verifier.isXMLCharacter((int)c)) {
                if (result != null) continue;
                result = new StringBuilder(text.length());
                result.append(text, 0, i);
                continue;
            }
            if (result == null) continue;
            result.append(c);
        }
        String string = result == null ? text : result.toString();
        if (string == null) {
            JDOMUtil.$$$reportNull$$$0(108);
        }
        return string;
    }

    @Nullable
    public static Point getLocation(@Nullable Element element) {
        return element == null ? null : JDOMUtil.getLocation(element, X, Y);
    }

    @Nullable
    public static Point getLocation(@NotNull Element element, @NotNull String x, @NotNull String y) {
        String sX;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(109);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(110);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(111);
        }
        if ((sX = element.getAttributeValue(x)) == null) {
            return null;
        }
        String sY = element.getAttributeValue(y);
        if (sY == null) {
            return null;
        }
        try {
            return new Point(Integer.parseInt(sX), Integer.parseInt(sY));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setLocation(@NotNull Element element, @NotNull Point location) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(112);
        }
        if (location == null) {
            JDOMUtil.$$$reportNull$$$0(113);
        }
        return JDOMUtil.setLocation(element, X, Y, location);
    }

    @NotNull
    public static Element setLocation(@NotNull Element element, @NotNull String x, @NotNull String y, @NotNull Point location) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(114);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(115);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(116);
        }
        if (location == null) {
            JDOMUtil.$$$reportNull$$$0(117);
        }
        Element element2 = element.setAttribute(x, Integer.toString(location.x)).setAttribute(y, Integer.toString(location.y));
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(118);
        }
        return element2;
    }

    @Nullable
    public static Dimension getSize(@Nullable Element element) {
        return element == null ? null : JDOMUtil.getSize(element, WIDTH, HEIGHT);
    }

    @Nullable
    public static Dimension getSize(@NotNull Element element, @NotNull String width, @NotNull String height) {
        String sWidth;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(119);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(120);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(121);
        }
        if ((sWidth = element.getAttributeValue(width)) == null) {
            return null;
        }
        String sHeight = element.getAttributeValue(height);
        if (sHeight == null) {
            return null;
        }
        try {
            int iWidth = Integer.parseInt(sWidth);
            if (iWidth <= 0) {
                return null;
            }
            int iHeight = Integer.parseInt(sHeight);
            if (iHeight <= 0) {
                return null;
            }
            return new Dimension(iWidth, iHeight);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setSize(@NotNull Element element, @NotNull Dimension size) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(122);
        }
        if (size == null) {
            JDOMUtil.$$$reportNull$$$0(123);
        }
        return JDOMUtil.setSize(element, WIDTH, HEIGHT, size);
    }

    @NotNull
    public static Element setSize(@NotNull Element element, @NotNull String width, @NotNull String height, @NotNull Dimension size) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(124);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(125);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(126);
        }
        if (size == null) {
            JDOMUtil.$$$reportNull$$$0(127);
        }
        Element element2 = element.setAttribute(width, Integer.toString(size.width)).setAttribute(height, Integer.toString(size.height));
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(128);
        }
        return element2;
    }

    @Nullable
    public static Rectangle getBounds(@Nullable Element element) {
        return element == null ? null : JDOMUtil.getBounds(element, X, Y, WIDTH, HEIGHT);
    }

    @Nullable
    public static Rectangle getBounds(@NotNull Element element, @NotNull String x, @NotNull String y, @NotNull String width, @NotNull String height) {
        String sX;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(129);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(130);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(131);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(132);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(133);
        }
        if ((sX = element.getAttributeValue(x)) == null) {
            return null;
        }
        String sY = element.getAttributeValue(y);
        if (sY == null) {
            return null;
        }
        String sWidth = element.getAttributeValue(width);
        if (sWidth == null) {
            return null;
        }
        String sHeight = element.getAttributeValue(height);
        if (sHeight == null) {
            return null;
        }
        try {
            int iWidth = Integer.parseInt(sWidth);
            if (iWidth <= 0) {
                return null;
            }
            int iHeight = Integer.parseInt(sHeight);
            if (iHeight <= 0) {
                return null;
            }
            return new Rectangle(Integer.parseInt(sX), Integer.parseInt(sY), iWidth, iHeight);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setBounds(@NotNull Element element, @NotNull Rectangle bounds) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(134);
        }
        if (bounds == null) {
            JDOMUtil.$$$reportNull$$$0(135);
        }
        return JDOMUtil.setBounds(element, X, Y, WIDTH, HEIGHT, bounds);
    }

    @NotNull
    public static Element setBounds(@NotNull Element element, @NotNull String x, @NotNull String y, @NotNull String width, @NotNull String height, @NotNull Rectangle bounds) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(136);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(137);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(138);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(139);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(140);
        }
        if (bounds == null) {
            JDOMUtil.$$$reportNull$$$0(141);
        }
        Element element2 = element.setAttribute(x, Integer.toString(bounds.x)).setAttribute(y, Integer.toString(bounds.y)).setAttribute(width, Integer.toString(bounds.width)).setAttribute(height, Integer.toString(bounds.height));
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(142);
        }
        return element2;
    }

    public static void copyMissingContent(@NotNull Element source, @NotNull Element target) {
        if (source == null) {
            JDOMUtil.$$$reportNull$$$0(143);
        }
        if (target == null) {
            JDOMUtil.$$$reportNull$$$0(144);
        }
        Element targetClone = target.clone();
        for (Attribute attribute : source.getAttributes()) {
            if (JDOMUtil.hasAttribute(targetClone, attribute.getName())) continue;
            target.setAttribute(attribute.clone());
        }
        for (Content content : source.getContent()) {
            if (JDOMUtil.hasContent(targetClone, content)) continue;
            target.addContent(content.clone());
        }
    }

    private static boolean hasAttribute(@NotNull Element element, @NotNull String name) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(145);
        }
        if (name == null) {
            JDOMUtil.$$$reportNull$$$0(146);
        }
        return element.getAttribute(name) != null;
    }

    private static boolean hasContent(@NotNull Element element, @NotNull Content content) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(147);
        }
        if (content == null) {
            JDOMUtil.$$$reportNull$$$0(148);
        }
        return content instanceof Element && !element.getChildren(((Element)content).getName()).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 1: 
            case 103: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 13: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l1";
                break;
            }
            case 14: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l2";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 20: 
            case 22: 
            case 29: 
            case 55: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 52: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 35: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 40: 
            case 42: 
            case 54: 
            case 56: 
            case 58: 
            case 65: 
            case 66: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 60: 
            case 62: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 86: 
            case 87: 
            case 105: 
            case 109: 
            case 112: 
            case 114: 
            case 119: 
            case 122: 
            case 124: 
            case 129: 
            case 134: 
            case 136: 
            case 145: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 50: 
            case 53: 
            case 64: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFiles";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilePaths";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileDocuments";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 93: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 97: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeByAttributes";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 110: 
            case 115: 
            case 130: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = X;
                break;
            }
            case 111: 
            case 116: 
            case 131: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = Y;
                break;
            }
            case 113: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 120: 
            case 125: 
            case 132: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = WIDTH;
                break;
            }
            case 121: 
            case 126: 
            case 133: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = HEIGHT;
                break;
            }
            case 123: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 135: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeChars";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotEmptyAttributes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDocumentUsingStaX";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUsingStaX";
                break;
            }
            case 25: 
            case 31: 
            case 34: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "loadResource";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "writeDocument";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "writeElement";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChildren";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormat";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeText";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "deepMergeWithAttributes";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "internElement";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "removeControlChars";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocation";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "setSize";
                break;
            }
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "setBounds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areElementContentsEqual";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "legalizeText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "legalizeChars";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendLegalized";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAttributesEqual";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNotEmptyAttributes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "attributesEqual";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadDocumentUsingStaX";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadUsingStaX";
                break;
            }
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 26: 
            case 29: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "loadDocument";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "loadResource";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 65: 
            case 66: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "writeDocument";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "writeElement";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "writeChildren";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "escapeText";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "printDiagnostics";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "updateFileSet";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "deepMerge";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "deepMergeWithAttributes";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "areAttributesEqual";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "reduceChildren";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "internElement";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "removeControlChars";
                break;
            }
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "setSize";
                break;
            }
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getBounds";
                break;
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "setBounds";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "copyMissingContent";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "hasContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LoggerHolder {
        private static final Logger LOG = Logger.getInstance(JDOMUtil.class);

        private LoggerHolder() {
        }
    }

    private static final class MyXMLOutputter
    extends XMLOutputter {
        private MyXMLOutputter(@Nullable String lineSeparator) {
            super(lineSeparator == null ? null : JDOMUtil.createFormat(lineSeparator));
        }

        @NotNull
        public String escapeAttributeEntities(@NotNull String str) {
            if (str == null) {
                MyXMLOutputter.$$$reportNull$$$0(0);
            }
            String string = JDOMUtil.escapeText(str, false, true);
            if (string == null) {
                MyXMLOutputter.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String escapeElementEntities(@NotNull String str) {
            if (str == null) {
                MyXMLOutputter.$$$reportNull$$$0(2);
            }
            String string = JDOMUtil.escapeText(str, false, false);
            if (string == null) {
                MyXMLOutputter.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeAttributeEntities";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeElementEntities";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeAttributeEntities";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeElementEntities";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ElementInfo {
        @NotNull
        private final CharSequence name;
        private final boolean hasNullAttributes;

        private ElementInfo(@NotNull CharSequence name, boolean attributes) {
            if (name == null) {
                ElementInfo.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.hasNullAttributes = attributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/JDOMUtil$ElementInfo", "<init>"));
        }
    }

    public static final class MergeAttribute {
        public String elementName;
        public String attributeName;

        public MergeAttribute(String elementName, String attributeName) {
            this.elementName = elementName;
            this.attributeName = attributeName;
        }
    }

    public static interface ElementOutputFilter {
        public boolean accept(@NotNull Element var1, int var2);
    }
}

