/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.userData.ExternalUserDataStorage;
import com.intellij.util.containers.VarHandleWrapper;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.UnknownNullability;

@Transient
public class UserDataHolderBase
implements UserDataHolderEx,
Serializable {
    private static final Key<KeyFMap> COPYABLE_USER_MAP_KEY = Key.create("COPYABLE_USER_MAP_KEY");
    @Nullable
    private static @Nullable Function<@NotNull UserDataHolderBase, @Nullable ExternalUserDataStorage> ourExternalUserDataStorage = null;
    @NotNull
    private volatile KeyFMap value = KeyFMap.EMPTY_MAP;
    private static final VarHandleWrapper VALUE_HANDLE = VarHandleWrapper.getFactory().create(UserDataHolderBase.class, "value", KeyFMap.class);

    @ApiStatus.Internal
    public static void setExternalUserDataStorage(@Nullable @Nullable Function<@NotNull UserDataHolderBase, @Nullable ExternalUserDataStorage> provider) {
        ourExternalUserDataStorage = provider;
    }

    @Nullable
    private ExternalUserDataStorage externalStorage() {
        Function<@NotNull UserDataHolderBase, @Nullable ExternalUserDataStorage> provider = ourExternalUserDataStorage;
        return provider == null ? null : provider.apply(this);
    }

    protected Object clone() {
        try {
            UserDataHolderBase clone = (UserDataHolderBase)super.clone();
            clone.setUserMap(KeyFMap.EMPTY_MAP);
            this.copyCopyableDataTo(clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @TestOnly
    public String getUserDataString() {
        KeyFMap userMap = this.getUserMap();
        KeyFMap copyableMap = this.getUserData(COPYABLE_USER_MAP_KEY);
        return userMap + (copyableMap == null ? "" : copyableMap.toString());
    }

    public void copyUserDataTo(@NotNull UserDataHolderBase other) {
        if (other == null) {
            UserDataHolderBase.$$$reportNull$$$0(0);
        }
        other.setUserMap(this.getUserMap());
    }

    @Override
    public <T> T getUserData(@NotNull Key<T> key) {
        ExternalUserDataStorage external;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(1);
        }
        if ((external = this.externalStorage()) != null) {
            return external.getUserData(this, key);
        }
        T t = this.getUserMap().get(key);
        if (t == null && key instanceof KeyWithDefaultValue) {
            t = this.putUserDataIfAbsent(key, ((KeyWithDefaultValue)key).getDefaultValue());
        }
        return t;
    }

    @ApiStatus.Internal
    @NotNull
    public KeyFMap getUserMap() {
        ExternalUserDataStorage external = this.externalStorage();
        if (external != null) {
            KeyFMap keyFMap = external.getUserMap(this);
            if (keyFMap == null) {
                UserDataHolderBase.$$$reportNull$$$0(2);
            }
            return keyFMap;
        }
        KeyFMap keyFMap = this.value;
        if (keyFMap == null) {
            UserDataHolderBase.$$$reportNull$$$0(3);
        }
        return keyFMap;
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        ExternalUserDataStorage external;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(4);
        }
        if ((external = this.externalStorage()) != null) {
            external.putUserData(this, key, value);
        } else {
            KeyFMap map;
            KeyFMap newMap;
            do {
                map = this.getUserMap();
                KeyFMap keyFMap = newMap = value == null ? map.minus(key) : map.plus(key, value);
            } while (newMap != map && !this.changeUserMap(map, newMap));
        }
    }

    protected boolean changeUserMap(@NotNull KeyFMap oldMap, @NotNull KeyFMap newMap) {
        if (oldMap == null) {
            UserDataHolderBase.$$$reportNull$$$0(5);
        }
        if (newMap == null) {
            UserDataHolderBase.$$$reportNull$$$0(6);
        }
        return VALUE_HANDLE.compareAndSet(this, oldMap, newMap);
    }

    public <T> @UnknownNullability T getCopyableUserData(@NotNull Key<T> key) {
        KeyFMap map;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(7);
        }
        return (map = this.getUserData(COPYABLE_USER_MAP_KEY)) == null ? null : (T)map.get(key);
    }

    public <T> void putCopyableUserData(@NotNull Key<T> key, T value) {
        ExternalUserDataStorage external;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(8);
        }
        if ((external = this.externalStorage()) != null) {
            KeyFMap newCopyableMap;
            KeyFMap oldCopyableMap;
            do {
                newCopyableMap = oldCopyableMap = this.getUserData(COPYABLE_USER_MAP_KEY);
                if (oldCopyableMap == null) {
                    if (value == null) continue;
                    newCopyableMap = KeyFMap.EMPTY_MAP.plus(key, value);
                    continue;
                }
                newCopyableMap = value == null ? oldCopyableMap.minus(key) : oldCopyableMap.plus(key, value);
            } while (oldCopyableMap != newCopyableMap && !external.compareAndPutUserData(this, COPYABLE_USER_MAP_KEY, oldCopyableMap, newCopyableMap));
        } else {
            KeyFMap map;
            KeyFMap newMap;
            do {
                KeyFMap copyableMap;
                if ((copyableMap = (map = this.getUserMap()).get(COPYABLE_USER_MAP_KEY)) == null) {
                    copyableMap = KeyFMap.EMPTY_MAP;
                }
                KeyFMap newCopyableMap = value == null ? copyableMap.minus(key) : copyableMap.plus(key, value);
                KeyFMap keyFMap = newMap = newCopyableMap.isEmpty() ? map.minus(COPYABLE_USER_MAP_KEY) : map.plus(COPYABLE_USER_MAP_KEY, newCopyableMap);
            } while (newMap != map && !this.changeUserMap(map, newMap));
            return;
        }
    }

    @Override
    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        KeyFMap map;
        KeyFMap newMap;
        ExternalUserDataStorage external;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(9);
        }
        if ((external = this.externalStorage()) != null) {
            return external.compareAndPutUserData(this, key, oldValue, newValue);
        }
        do {
            if ((map = this.getUserMap()).get(key) != oldValue) {
                return false;
            }
            KeyFMap keyFMap = newMap = newValue == null ? map.minus(key) : map.plus(key, newValue);
        } while (newMap != map && !this.changeUserMap(map, newMap));
        return true;
    }

    @Override
    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        KeyFMap map;
        KeyFMap newMap;
        ExternalUserDataStorage external;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(10);
        }
        if (value == null) {
            UserDataHolderBase.$$$reportNull$$$0(11);
        }
        if ((external = this.externalStorage()) != null) {
            T t = external.putUserDataIfAbsent(this, key, value);
            if (t == null) {
                UserDataHolderBase.$$$reportNull$$$0(12);
            }
            return t;
        }
        do {
            T oldValue;
            if ((oldValue = (map = this.getUserMap()).get(key)) == null) continue;
            T t = oldValue;
            if (t == null) {
                UserDataHolderBase.$$$reportNull$$$0(13);
            }
            return t;
        } while ((newMap = map.plus(key, value)) != map && !this.changeUserMap(map, newMap));
        T t = value;
        if (t == null) {
            UserDataHolderBase.$$$reportNull$$$0(14);
        }
        return t;
    }

    public void copyCopyableDataTo(@NotNull UserDataHolderBase clone) {
        if (clone == null) {
            UserDataHolderBase.$$$reportNull$$$0(15);
        }
        clone.putUserData(COPYABLE_USER_MAP_KEY, this.getUserData(COPYABLE_USER_MAP_KEY));
    }

    @ApiStatus.Experimental
    public boolean isCopyableDataEqual(@NotNull UserDataHolderBase other) {
        if (other == null) {
            UserDataHolderBase.$$$reportNull$$$0(16);
        }
        return Objects.equals(this.getUserData(COPYABLE_USER_MAP_KEY), other.getUserData(COPYABLE_USER_MAP_KEY));
    }

    protected void clearUserData() {
        this.setUserMap(KeyFMap.EMPTY_MAP);
    }

    protected void setUserMap(@NotNull KeyFMap map) {
        ExternalUserDataStorage external;
        if (map == null) {
            UserDataHolderBase.$$$reportNull$$$0(17);
        }
        if ((external = this.externalStorage()) != null) {
            external.setUserMap(this, map);
        } else {
            this.value = map;
        }
    }

    public boolean isUserDataEmpty() {
        return this.getUserMap().isEmpty();
    }

    public String toString() {
        return this.getUserMap().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/UserDataHolderBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMap";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clone";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/UserDataHolderBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserMap";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyUserDataTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "changeUserMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCopyableUserData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putCopyableUserData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyCopyableDataTo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isCopyableDataEqual";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setUserMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

