// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.openapi.util;

import org.jetbrains.annotations.NotNull;

/**
 * Use {@link com.intellij.util.concurrency.SynchronizedClearableLazy} instead.
 */
public abstract class AtomicClearableLazyValue<T> extends ClearableLazyValue<T> {
  @Override
  public final synchronized @NotNull T getValue() {
    return super.getValue();
  }

  /** Not synchronized on purpose to avoid freezes. */
  @Override
  public final boolean isCached() {
    return super.isCached();
  }

  @Override
  public final synchronized void drop() {
    super.drop();
  }
}
