/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.WinBuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SystemInfo {
    @ApiStatus.Obsolete
    public static final String OS_NAME = SystemInfoRt.OS_NAME;
    @ApiStatus.Obsolete
    public static final String OS_VERSION = SystemInfoRt.OS_VERSION;
    @ApiStatus.Obsolete
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = SystemInfo.getRtVersion(JAVA_VERSION);
    public static final String JAVA_VENDOR = System.getProperty("java.vm.vendor", "Unknown");
    @ApiStatus.Obsolete
    public static final boolean isWindows = OS.CURRENT == OS.Windows;
    @ApiStatus.Obsolete
    public static final boolean isMac = OS.CURRENT == OS.macOS;
    @ApiStatus.Obsolete
    public static final boolean isLinux = OS.CURRENT == OS.Linux;
    @ApiStatus.Obsolete
    public static final boolean isFreeBSD = OS.CURRENT == OS.FreeBSD;
    @ApiStatus.Obsolete
    public static final boolean isUnix = OS.CURRENT != OS.Windows;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isChromeOS = false;
    public static final boolean isOracleJvm = Strings.indexOfIgnoreCase((String)JAVA_VENDOR, (String)"Oracle", (int)0) >= 0;
    public static final boolean isIbmJvm = Strings.indexOfIgnoreCase((String)JAVA_VENDOR, (String)"IBM", (int)0) >= 0;
    public static final boolean isAzulJvm = Strings.indexOfIgnoreCase((String)JAVA_VENDOR, (String)"Azul", (int)0) >= 0;
    public static final boolean isJetBrainsJvm = Strings.indexOfIgnoreCase((String)JAVA_VENDOR, (String)"JetBrains", (int)0) >= 0;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isWin8OrNewer = OS.CURRENT == OS.Windows;
    @ApiStatus.Obsolete
    public static final boolean isWin10OrNewer = OS.CURRENT == OS.Windows && OS.CURRENT.isAtLeast(10, 0);
    @ApiStatus.Obsolete
    public static final boolean isWin11OrNewer = OS.CURRENT == OS.Windows && OS.CURRENT.isAtLeast(11, 0);
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isWayland = OS.isGenericUnix() && System.getenv("WAYLAND_DISPLAY") != null;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isGNOME = OS.isGenericUnix() && (SystemInfo.env("XDG_CURRENT_DESKTOP", "GNOME") || SystemInfo.env("GDMSESSION", "gnome"));
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isKDE = OS.isGenericUnix() && (SystemInfo.env("XDG_CURRENT_DESKTOP", "KDE") || System.getenv("KDE_FULL_SESSION") != null);
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isXfce = OS.isGenericUnix() && SystemInfo.env("XDG_CURRENT_DESKTOP", "XFCE");
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isI3 = OS.isGenericUnix() && SystemInfo.env("XDG_CURRENT_DESKTOP", "i3");
    public static final boolean isFileSystemCaseSensitive = SystemInfoRt.isFileSystemCaseSensitive;
    @ApiStatus.Obsolete
    public static final boolean isMacOSCatalina = OS.CURRENT == OS.macOS && OS.CURRENT.isAtLeast(10, 15);
    @ApiStatus.Obsolete
    public static final boolean isMacOSBigSur = OS.CURRENT == OS.macOS && OS.CURRENT.isAtLeast(10, 16);
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isMacOSMonterey = OS.CURRENT == OS.macOS && OS.CURRENT.isAtLeast(12, 0);
    @ApiStatus.Obsolete
    public static final boolean isMacOSVentura = OS.CURRENT == OS.macOS && OS.CURRENT.isAtLeast(13, 0);
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isMacOSSonoma = OS.CURRENT == OS.macOS && OS.CURRENT.isAtLeast(14, 0);
    @ApiStatus.Obsolete
    public static final boolean isMacOSSequoia = OS.CURRENT == OS.macOS && OS.CURRENT.isAtLeast(15, 0);
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean is32Bit = CpuArch.CURRENT.width == 32;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean is64Bit = CpuArch.CURRENT.width == 64;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isAarch64 = CpuArch.isArm64();
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isSolaris = false;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isXWindow = isUnix && !isMac;
    private static final NotNullLazyValue<Boolean> ourHasXdgOpen = isUnix && !isMac ? NotNullLazyValue.lazy(() -> SystemInfo.isOnPath("xdg-open")) : NotNullLazyValue.createConstantValue(false);
    private static final NotNullLazyValue<Boolean> ourHasXdgMime = isUnix && !isMac ? NotNullLazyValue.lazy(() -> SystemInfo.isOnPath("xdg-mime")) : NotNullLazyValue.createConstantValue(false);

    private static String getRtVersion(String fallback) {
        String rtVersion = System.getProperty("java.runtime.version");
        return rtVersion != null && Character.isDigit(rtVersion.charAt(0)) ? rtVersion : fallback;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isOsVersionAtLeast(@NotNull String version) {
        if (version == null) {
            SystemInfo.$$$reportNull$$$0(0);
        }
        return StringUtil.compareVersionNumbers(OS_VERSION, version) >= 0;
    }

    private static boolean env(String varName, String marker) {
        String value = System.getenv(varName);
        return value != null && value.contains(marker);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean hasXdgOpen() {
        return ourHasXdgOpen.get();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean hasXdgMime() {
        return ourHasXdgMime.get();
    }

    @ApiStatus.Obsolete
    @Nullable
    public static Long getWinBuildNumber() {
        return isWindows ? WinBuildNumber.getWinBuildNumber() : null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static String getOsName() {
        return OS.CURRENT.name();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static String getOsNameAndVersion() {
        return OS.CURRENT.name() + ' ' + OS.CURRENT.version();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isJavaVersionAtLeast(String v) {
        return StringUtil.compareVersionNumbers(JAVA_RUNTIME_VERSION, v) >= 0;
    }

    private static boolean isOnPath(String name) {
        String path = System.getenv("PATH");
        if (path != null) {
            for (String dir : StringUtil.tokenize(path, ":")) {
                if (!Files.isExecutable(Paths.get(dir, name))) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/util/SystemInfo", "isOsVersionAtLeast"));
    }
}

