// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.platform.vcs.impl.shared.telemetry

import org.jetbrains.annotations.ApiStatus
import org.jetbrains.annotations.NonNls

@ApiStatus.Internal
interface VcsTelemetrySpan {
  fun getName(): @NonNls String
}

internal enum class ChangesView(val tag: String) : VcsTelemetrySpan {
  ChangesViewRefreshBackground("changes-view-refresh-background"),

  ChangesViewRefreshEdt("changes-view-refresh-edt");

  override fun getName(): String = tag
}
