/*
 * Copyright 2000-2010 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;
import java.util.List;
import java.util.function.Supplier;

public interface ChangesViewI {
  void scheduleRefresh();
  void selectFile(VirtualFile vFile);
  void selectChanges(@NotNull List<? extends Change> changes);
  void updateProgressComponent(@NotNull List<Supplier<JComponent>> progress);
  void setBusy(boolean b);

  void setGrouping(@NotNull String groupingKey);
}
