// Copyright 2000-2024 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.JBUI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

@ApiStatus.Internal
public abstract class VcsCheckBoxWithSpinnerConfigurable implements Configurable {
  protected final Project myProject;
  private final @NlsContexts.Checkbox String myCheckboxText;
  private final @NlsContexts.Label String myMeasure;
  protected JCheckBox myHighlightRecentlyChanged;
  protected JSpinner myHighlightInterval;

  public VcsCheckBoxWithSpinnerConfigurable(Project project, @NlsContexts.Checkbox String checkboxText, @NlsContexts.Label String measure) {
    myProject = project;
    myCheckboxText = checkboxText;
    myMeasure = measure;
  }

  @Override
  public @NotNull JComponent createComponent() {
    JPanel wrapper = new JPanel(new FlowLayout(FlowLayout.LEFT, 0, 0));
    myHighlightRecentlyChanged = new JCheckBox(myCheckboxText);
    myHighlightInterval = new JSpinner(createSpinnerModel());
    wrapper.add(myHighlightRecentlyChanged);
    wrapper.add(myHighlightInterval);
    final JLabel days = new JLabel(myMeasure);
    days.setBorder(JBUI.Borders.empty(0, 1));
    wrapper.add(days);

    myHighlightRecentlyChanged.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        myHighlightInterval.setEnabled(myHighlightRecentlyChanged.isSelected());
      }
    });
    return wrapper;
  }

  protected abstract SpinnerNumberModel createSpinnerModel();
}
