/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.URLUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/ModulePath;", "", "path", "", "group", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "getGroup", "moduleName", "getModuleName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.platform.workspace.jps"})
public final class ModulePath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    @Nullable
    private final String group;
    @NotNull
    private final String moduleName;

    public ModulePath(@NotNull String path, @Nullable String group) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.group = group;
        this.moduleName = Companion.getModuleNameByFilePath(this.path);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final String getGroup() {
        return this.group;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final String component1() {
        return this.path;
    }

    @Nullable
    public final String component2() {
        return this.group;
    }

    @NotNull
    public final ModulePath copy(@NotNull String path, @Nullable String group) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new ModulePath(path, group);
    }

    public static /* synthetic */ ModulePath copy$default(ModulePath modulePath, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = modulePath.path;
        }
        if ((n & 2) != 0) {
            string2 = modulePath.group;
        }
        return modulePath.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "ModulePath(path=" + this.path + ", group=" + this.group + ")";
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = result * 31 + (this.group == null ? 0 : this.group.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModulePath)) {
            return false;
        }
        ModulePath modulePath = (ModulePath)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)modulePath.path)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.group, (Object)modulePath.group);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/ModulePath$Companion;", "", "<init>", "()V", "getModuleNameByFilePath", "", "path", "getPathsToModuleFiles", "", "Lcom/intellij/platform/workspace/jps/serialization/impl/ModulePath;", "element", "Lorg/jdom/Element;", "intellij.platform.workspace.jps"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getModuleNameByFilePath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = PathUtilRt.getFileName((String)path);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            return StringsKt.removeSuffix((String)string, (CharSequence)".iml");
        }

        @NotNull
        public final Set<ModulePath> getPathsToModuleFiles(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Element element2 = element.getChild("modules");
            if (element2 == null) {
                return SetsKt.emptySet();
            }
            Element modules = element2;
            List children = modules.getChildren("module");
            LinkedHashSet<ModulePath> paths = new LinkedHashSet<ModulePath>(children.size());
            for (Element moduleElement : children) {
                String filepath;
                String fileUrlValue = moduleElement.getAttributeValue("fileurl");
                String string = filepath = fileUrlValue == null ? moduleElement.getAttributeValue("filepath") : URLUtil.extractPath((String)fileUrlValue);
                Intrinsics.checkNotNull((Object)string);
                String string2 = FileUtilRt.toSystemIndependentName((String)string);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
                paths.add(new ModulePath(string2, moduleElement.getAttributeValue("group")));
            }
            return paths;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

