/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tJ$\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rJ\"\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/LibraryNameGenerator;", "", "<init>", "()V", "UNIQUE_INDEX_LIBRARY_NAME_SUFFIX", "", "UNNAMED_LIBRARY_NAME_PREFIX", "getLegacyLibraryName", "libraryId", "Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "generateLibraryEntityName", "legacyLibraryName", "exists", "Lkotlin/Function1;", "", "generateUniqueLibraryName", "name", "getLibraryTableId", "Lcom/intellij/platform/workspace/jps/entities/LibraryTableId;", "level", "intellij.platform.workspace.jps"})
public final class LibraryNameGenerator {
    @NotNull
    public static final LibraryNameGenerator INSTANCE = new LibraryNameGenerator();
    @NotNull
    private static final String UNIQUE_INDEX_LIBRARY_NAME_SUFFIX = "-d1a6f608-UNIQUE-INDEX-f29c-4df6-";
    @NotNull
    public static final String UNNAMED_LIBRARY_NAME_PREFIX = "#";

    private LibraryNameGenerator() {
    }

    @Nullable
    public final String getLegacyLibraryName(@NotNull LibraryId libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        if (StringsKt.startsWith$default((String)libraryId.getName(), (String)UNNAMED_LIBRARY_NAME_PREFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        if (StringsKt.contains$default((CharSequence)libraryId.getName(), (CharSequence)UNIQUE_INDEX_LIBRARY_NAME_SUFFIX, (boolean)false, (int)2, null)) {
            return StringsKt.substringBefore$default((String)libraryId.getName(), (String)UNIQUE_INDEX_LIBRARY_NAME_SUFFIX, null, (int)2, null);
        }
        return libraryId.getName();
    }

    @NotNull
    public final String generateLibraryEntityName(@Nullable String legacyLibraryName, @NotNull Function1<? super String, Boolean> exists) {
        Intrinsics.checkNotNullParameter(exists, (String)"exists");
        if (legacyLibraryName == null) {
            int index = 1;
            while (true) {
                String candidate;
                if (!((Boolean)exists.invoke((Object)(candidate = UNNAMED_LIBRARY_NAME_PREFIX + index))).booleanValue()) {
                    return candidate;
                }
                ++index;
            }
        }
        return this.generateUniqueLibraryName(legacyLibraryName, exists);
    }

    @NotNull
    public final String generateUniqueLibraryName(@NotNull String name, @NotNull Function1<? super String, Boolean> exists) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(exists, (String)"exists");
        if (!((Boolean)exists.invoke((Object)name)).booleanValue()) {
            return name;
        }
        int index = 1;
        String candidate;
        while (((Boolean)exists.invoke((Object)(candidate = name + UNIQUE_INDEX_LIBRARY_NAME_SUFFIX + index))).booleanValue()) {
            ++index;
        }
        return candidate;
    }

    @NotNull
    public final LibraryTableId getLibraryTableId(@NotNull String level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        String string = level;
        if (Intrinsics.areEqual((Object)string, (Object)"module")) {
            throw new IllegalStateException("this method isn't supposed to be used for module-level libraries".toString());
        }
        return Intrinsics.areEqual((Object)string, (Object)"project") ? (LibraryTableId)LibraryTableId.ProjectLibraryTableId.INSTANCE : (LibraryTableId)new LibraryTableId.GlobalLibraryTableId(level);
    }
}

