/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.java.workspace.entities.JavaProjectSettingsEntity;
import com.intellij.java.workspace.entities.JavaProjectSettingsEntityBuilder;
import com.intellij.java.workspace.entities.JavaProjectSettingsEntityModifications;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.entities.ProjectSettingsEntity;
import com.intellij.platform.workspace.jps.entities.ProjectSettingsEntityBuilder;
import com.intellij.platform.workspace.jps.entities.ProjectSettingsEntityModifications;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.platform.workspace.jps.serialization.impl.ErrorReporter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntityTypeSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.LoadingResult;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 32\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00013B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016JH\u0010\u001e\u001a*\u0012&\u0012$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0011\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\"0!0 0\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016JB\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2(\u0010-\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0011\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\"0!0 H\u0016JH\u0010.\u001a\u00020\u001a2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00020!2 \u00100\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150 2\u0006\u00101\u001a\u0002022\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00110\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00064"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/ProjectSettingsSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntityTypeSerializer;", "Lcom/intellij/platform/workspace/jps/entities/ProjectSettingsEntity;", "fileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "internalEntitySource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "<init>", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;)V", "getFileUrl", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getInternalEntitySource", "()Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "isExternalStorage", "", "()Z", "mainEntityClass", "Ljava/lang/Class;", "getMainEntityClass", "()Ljava/lang/Class;", "additionalEntityTypes", "", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "getAdditionalEntityTypes", "()Ljava/util/List;", "deleteObsoleteFile", "", "", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "loadEntities", "Lcom/intellij/platform/workspace/jps/serialization/impl/LoadingResult;", "", "", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;", "reader", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "errorReporter", "Lcom/intellij/platform/workspace/jps/serialization/impl/ErrorReporter;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "checkAndAddToBuilder", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "orphanage", "newEntities", "saveEntities", "mainEntities", "entities", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "Companion", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nProjectSettingsSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectSettingsSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/ProjectSettingsSerializer\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 LoadingResult.kt\ncom/intellij/platform/workspace/jps/serialization/impl/LoadingResultKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n44#2,2:142\n46#2:164\n44#2,2:169\n46#2:174\n29#3,2:144\n31#3:163\n29#3,3:171\n24#4,8:146\n24#4,8:155\n1#5:154\n216#6:165\n217#6:168\n1869#7,2:166\n*S KotlinDebug\n*F\n+ 1 ProjectSettingsSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/ProjectSettingsSerializer\n*L\n51#1:142,2\n51#1:164\n99#1:169,2\n99#1:174\n51#1:144,2\n51#1:163\n99#1:171,3\n53#1:146,8\n65#1:155,8\n89#1:165\n89#1:168\n90#1:166,2\n*E\n"})
public final class ProjectSettingsSerializer
implements JpsFileEntityTypeSerializer<ProjectSettingsEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFileUrl fileUrl;
    @NotNull
    private final JpsFileEntitySource internalEntitySource;
    private final boolean isExternalStorage;
    @NotNull
    private final Class<ProjectSettingsEntity> mainEntityClass;
    @NotNull
    private final List<Class<? extends WorkspaceEntity>> additionalEntityTypes;
    @NotNull
    private static final AtomicLong loadEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
    @NotNull
    private static final AtomicLong saveEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);

    public ProjectSettingsSerializer(@NotNull VirtualFileUrl fileUrl, @NotNull JpsFileEntitySource internalEntitySource) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)internalEntitySource, (String)"internalEntitySource");
        this.fileUrl = fileUrl;
        this.internalEntitySource = internalEntitySource;
        this.mainEntityClass = ProjectSettingsEntity.class;
        this.additionalEntityTypes = CollectionsKt.listOf(JavaProjectSettingsEntity.class);
    }

    @Override
    @NotNull
    public VirtualFileUrl getFileUrl() {
        return this.fileUrl;
    }

    @Override
    @NotNull
    public JpsFileEntitySource getInternalEntitySource() {
        return this.internalEntitySource;
    }

    @Override
    public boolean isExternalStorage() {
        return this.isExternalStorage;
    }

    @Override
    @NotNull
    public Class<ProjectSettingsEntity> getMainEntityClass() {
        return this.mainEntityClass;
    }

    @Override
    @NotNull
    public List<Class<? extends WorkspaceEntity>> getAdditionalEntityTypes() {
        return this.additionalEntityTypes;
    }

    @Override
    public void deleteObsoleteFile(@NotNull String fileUrl, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.saveComponent(fileUrl, "ProjectRootManager", null);
    }

    @Override
    @NotNull
    public LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity.Builder<? extends WorkspaceEntity>>>> loadEntities(@NotNull JpsFileContentReader reader, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        LoadingResult loadingResult;
        Object object;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        AtomicLong atomicLong = loadEntitiesTimeMs;
        boolean bl = false;
        LoadingResult value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        Object $this$runCatchingXmlIssues$iv = this;
        boolean $i$f$runCatchingXmlIssues = false;
        try {
            boolean bl4 = false;
            String string = this.getFileUrl().getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            object = Result.constructor-impl((Object)JpsFileContentReader.loadComponent$default(reader, string, "ProjectRootManager", null, 4, null));
        }
        catch (JDOMException e$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
        }
        catch (IOException e$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
        }
        $this$runCatchingXmlIssues$iv = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)$this$runCatchingXmlIssues$iv);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl5 = false;
            loadingResult = new LoadingResult(MapsKt.emptyMap(), it);
        } else {
            Element projectRootManager = (Element)$this$runCatchingXmlIssues$iv;
            if (projectRootManager == null) {
                loadingResult = new LoadingResult(MapsKt.emptyMap(), null, 2, null);
            } else {
                ProjectSettingsEntityBuilder projectSettingsEntityBuilder = ProjectSettingsEntityModifications.createProjectSettingsEntity$default(this.getInternalEntitySource(), null, 2, null);
                JavaProjectSettingsEntityBuilder javaProjectSettingsEntityBuilder = JavaProjectSettingsEntityModifications.createJavaProjectSettingsEntity(this.getInternalEntitySource(), (Function1<? super JavaProjectSettingsEntityBuilder, Unit>)((Function1)arg_0 -> ProjectSettingsSerializer.loadEntities$lambda$0$2(projectSettingsEntityBuilder, arg_0)));
                JpsFileEntitiesSerializer $this$runCatchingXmlIssues$iv2 = this;
                boolean $i$f$runCatchingXmlIssues2 = false;
                try {
                    Object object2;
                    Element pathElement;
                    Object object3;
                    String sdkTypeStr;
                    boolean bl6 = false;
                    Attribute attribute = projectRootManager.getAttribute("languageLevel");
                    String languageLevelStr = attribute != null ? attribute.getValue() : null;
                    javaProjectSettingsEntityBuilder.setLanguageLevelId(languageLevelStr);
                    Object object4 = projectRootManager.getAttribute("default");
                    javaProjectSettingsEntityBuilder.setLanguageLevelDefault(object4 != null && (object4 = object4.getValue()) != null ? Boolean.valueOf(Boolean.parseBoolean((String)object4)) : null);
                    Attribute attribute2 = projectRootManager.getAttribute("project-jdk-name");
                    String sdkNameStr = attribute2 != null ? attribute2.getValue() : null;
                    Attribute attribute3 = projectRootManager.getAttribute("project-jdk-type");
                    String string = sdkTypeStr = attribute3 != null ? attribute3.getValue() : null;
                    if (sdkNameStr != null && sdkTypeStr != null) {
                        projectSettingsEntityBuilder.setProjectSdk(new SdkId(sdkNameStr, sdkTypeStr));
                    }
                    if ((object3 = (pathElement = projectRootManager.getChild("output"))) != null && (object3 = object3.getAttributeValue("url")) != null) {
                        Object object5;
                        Object outputPath = object5 = object3;
                        boolean bl7 = false;
                        VirtualFileUrl outputUrl = virtualFileManager.getOrCreateFromUrl((String)outputPath);
                        javaProjectSettingsEntityBuilder.setCompilerOutput(outputUrl);
                        object2 = object5;
                    } else {
                        object2 = null;
                    }
                    Object object6 = Result.constructor-impl(object2);
                }
                catch (JDOMException e$iv) {
                    Object object7 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
                }
                catch (IOException e$iv) {
                    Object object8 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
                }
                Pair[] pairArray = new Pair[]{TuplesKt.to(ProjectSettingsEntity.class, (Object)CollectionsKt.listOf((Object)projectSettingsEntityBuilder)), TuplesKt.to(JavaProjectSettingsEntity.class, (Object)CollectionsKt.listOf((Object)javaProjectSettingsEntityBuilder))};
                LoadingResult loadingResult2 = new LoadingResult(MapsKt.mapOf((Pair[])pairArray), null, 2, null);
                loadingResult = loadingResult2;
            }
        }
        value$iv = loadingResult;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    @Override
    public void checkAndAddToBuilder(@NotNull MutableEntityStorage builder, @NotNull MutableEntityStorage orphanage, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>>> newEntities) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)orphanage, (String)"orphanage");
        Intrinsics.checkNotNullParameter(newEntities, (String)"newEntities");
        Map<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>>> $this$forEach$iv = newEntities;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>>> element$iv;
            Map.Entry<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>>> entry = element$iv = iterator.next();
            boolean bl = false;
            Collection<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>> value = entry.getValue();
            Iterable $this$forEach$iv2 = value;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                WorkspaceEntity.Builder it = (WorkspaceEntity.Builder)element$iv2;
                boolean bl2 = false;
                builder.addEntity(it);
            }
        }
    }

    @Override
    public void saveEntities(@NotNull Collection<? extends ProjectSettingsEntity> mainEntities, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> entities, @NotNull EntityStorage storage, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter(mainEntities, (String)"mainEntities");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        AtomicLong atomicLong = saveEntitiesTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        ProjectSettingsEntity projectSettingsEntity = (ProjectSettingsEntity)CollectionsKt.firstOrNull((Iterable)mainEntities);
        if (projectSettingsEntity != null) {
            JavaProjectSettingsEntity javaProjectSettingsEntity;
            Serializable serializable;
            Object object;
            List<? extends WorkspaceEntity> list = entities.get(JavaProjectSettingsEntity.class);
            JavaProjectSettingsEntity javaProjectSettingsEntity2 = (JavaProjectSettingsEntity)(list != null ? (WorkspaceEntity)CollectionsKt.firstOrNull(list) : null);
            Element componentTag2 = JDomSerializationUtil.createComponentElement((String)"ProjectRootManager");
            componentTag2.setAttribute("version", "2");
            JavaProjectSettingsEntity javaProjectSettingsEntity3 = javaProjectSettingsEntity2;
            if ((javaProjectSettingsEntity3 != null ? javaProjectSettingsEntity3.getLanguageLevelId() : null) != null) {
                componentTag2.setAttribute("languageLevel", javaProjectSettingsEntity2.getLanguageLevelId());
            }
            if ((object = javaProjectSettingsEntity2) != null && (object = object.getLanguageLevelDefault()) != null) {
                Object object2 = object;
                boolean notNullLanguageLevelDefault = (Boolean)object2;
                boolean bl4 = false;
                if (notNullLanguageLevelDefault) {
                    componentTag2.setAttribute("default", String.valueOf(notNullLanguageLevelDefault));
                }
            }
            SdkId projectSdk = projectSettingsEntity.getProjectSdk();
            if (projectSdk != null) {
                componentTag2.setAttribute("project-jdk-name", projectSdk.getName());
                serializable = (Serializable)componentTag2.setAttribute("project-jdk-type", projectSdk.getType());
            } else {
                componentTag2.removeAttribute("project-jdk-name");
                serializable = Boolean.valueOf(componentTag2.removeAttribute("project-jdk-type"));
            }
            if ((javaProjectSettingsEntity = javaProjectSettingsEntity2) != null && (javaProjectSettingsEntity = javaProjectSettingsEntity.getCompilerOutput()) != null) {
                JavaProjectSettingsEntity javaProjectSettingsEntity4;
                JavaProjectSettingsEntity compilerOutput = javaProjectSettingsEntity4 = javaProjectSettingsEntity;
                boolean bl5 = false;
                Element compilerOutputTag = new Element("output");
                compilerOutputTag.setAttribute("url", compilerOutput.getUrl());
                componentTag2.addContent(compilerOutputTag);
            }
            String string = this.getFileUrl().getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            writer.saveComponent(string, "ProjectRootManager", componentTag2);
        }
        value$iv = Unit.INSTANCE;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    private static final Unit loadEntities$lambda$0$2(ProjectSettingsEntityBuilder $projectSettingsEntityBuilder, JavaProjectSettingsEntityBuilder $this$JavaProjectSettingsEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$JavaProjectSettingsEntity, (String)"$this$JavaProjectSettingsEntity");
        $this$JavaProjectSettingsEntity.setProjectSettings($projectSettingsEntityBuilder);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/ProjectSettingsSerializer$Companion;", "", "<init>", "()V", "loadEntitiesTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "saveEntitiesTimeMs", "intellij.platform.workspace.jps"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

