/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.java.workspace.entities.ArtifactEntity;
import com.intellij.java.workspace.entities.ArtifactEntityBuilder;
import com.intellij.java.workspace.entities.ArtifactEntityModifications;
import com.intellij.java.workspace.entities.ArtifactPropertiesEntity;
import com.intellij.java.workspace.entities.ArtifactPropertiesEntityBuilder;
import com.intellij.java.workspace.entities.ArtifactPropertiesEntityModifications;
import com.intellij.java.workspace.entities.CompositePackagingElementEntity;
import com.intellij.java.workspace.entities.PackagingElementEntity;
import com.intellij.java.workspace.entities.PackagingElementEntityBuilder;
import com.intellij.platform.workspace.jps.JpsEntitySourceFactory;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.serialization.impl.JpsArtifactEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsDirectoryEntitiesSerializerFactory;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u0019*\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00190!H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactsDirectorySerializerFactory;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsDirectoryEntitiesSerializerFactory;", "Lcom/intellij/java/workspace/entities/ArtifactEntity;", "directoryUrl", "", "<init>", "(Ljava/lang/String;)V", "getDirectoryUrl", "()Ljava/lang/String;", "componentName", "getComponentName", "entityClass", "Ljava/lang/Class;", "getEntityClass", "()Ljava/lang/Class;", "createSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactEntitiesSerializer;", "fileUrl", "entitySource", "Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource$FileInDirectory;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "getDefaultFileName", "entity", "changeEntitySourcesToDirectoryBasedFormat", "", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "configLocation", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "forThisAndFullTree", "Lcom/intellij/java/workspace/entities/PackagingElementEntity;", "action", "Lkotlin/Function1;", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nJpsArtifactEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsArtifactEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactsDirectorySerializerFactory\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,438:1\n1321#2,2:439\n1321#2,2:441\n1869#3,2:443\n*S KotlinDebug\n*F\n+ 1 JpsArtifactEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactsDirectorySerializerFactory\n*L\n52#1:439,2\n68#1:441,2\n78#1:443,2\n*E\n"})
public final class JpsArtifactsDirectorySerializerFactory
implements JpsDirectoryEntitiesSerializerFactory<ArtifactEntity> {
    @NotNull
    private final String directoryUrl;

    public JpsArtifactsDirectorySerializerFactory(@NotNull String directoryUrl) {
        Intrinsics.checkNotNullParameter((Object)directoryUrl, (String)"directoryUrl");
        this.directoryUrl = directoryUrl;
    }

    @Override
    @NotNull
    public String getDirectoryUrl() {
        return this.directoryUrl;
    }

    @Override
    @NotNull
    public String getComponentName() {
        return "ArtifactManager";
    }

    @Override
    @NotNull
    public Class<ArtifactEntity> getEntityClass() {
        return ArtifactEntity.class;
    }

    @NotNull
    public JpsArtifactEntitiesSerializer createSerializer(@NotNull String fileUrl, @NotNull JpsProjectFileEntitySource.FileInDirectory entitySource, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)entitySource, (String)"entitySource");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        return new JpsArtifactEntitiesSerializer(virtualFileManager.getOrCreateFromUrl(fileUrl), entitySource, false, virtualFileManager);
    }

    @Override
    @NotNull
    public String getDefaultFileName(@NotNull ArtifactEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity.getName();
    }

    @Override
    public void changeEntitySourcesToDirectoryBasedFormat(@NotNull MutableEntityStorage builder, @NotNull JpsProjectConfigLocation configLocation) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)configLocation, (String)"configLocation");
        Sequence $this$forEach$iv = builder.entities(ArtifactEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ArtifactEntity)element$iv;
            boolean bl = false;
            JpsFileEntitySource artifactSource = JpsEntitySourceFactory.INSTANCE.createJpsEntitySourceForArtifact(configLocation);
            ArtifactEntityModifications.modifyArtifactEntity(builder, (ArtifactEntity)it, (Function1<? super ArtifactEntityBuilder, Unit>)((Function1)arg_0 -> JpsArtifactsDirectorySerializerFactory.changeEntitySourcesToDirectoryBasedFormat$lambda$0$0(artifactSource, arg_0)));
            CompositePackagingElementEntity compositePackagingElementEntity = it.getRootElement();
            Intrinsics.checkNotNull((Object)compositePackagingElementEntity);
            this.forThisAndFullTree(compositePackagingElementEntity, (Function1<? super PackagingElementEntity, Unit>)((Function1)arg_0 -> JpsArtifactsDirectorySerializerFactory.changeEntitySourcesToDirectoryBasedFormat$lambda$0$1(builder, artifactSource, arg_0)));
        }
        $this$forEach$iv = builder.entities(ArtifactPropertiesEntity.class);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ArtifactPropertiesEntity)element$iv;
            boolean bl = false;
            ArtifactPropertiesEntityModifications.modifyArtifactPropertiesEntity(builder, (ArtifactPropertiesEntity)it, (Function1<? super ArtifactPropertiesEntityBuilder, Unit>)((Function1)arg_0 -> JpsArtifactsDirectorySerializerFactory.changeEntitySourcesToDirectoryBasedFormat$lambda$1$0((ArtifactPropertiesEntity)it, arg_0)));
        }
    }

    private final void forThisAndFullTree(PackagingElementEntity $this$forThisAndFullTree, Function1<? super PackagingElementEntity, Unit> action) {
        action.invoke((Object)$this$forThisAndFullTree);
        if ($this$forThisAndFullTree instanceof CompositePackagingElementEntity) {
            Iterable $this$forEach$iv = ((CompositePackagingElementEntity)$this$forThisAndFullTree).getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PackagingElementEntity it = (PackagingElementEntity)element$iv;
                boolean bl = false;
                if (it instanceof CompositePackagingElementEntity) {
                    this.forThisAndFullTree(it, action);
                    continue;
                }
                action.invoke((Object)it);
            }
        }
    }

    private static final Unit changeEntitySourcesToDirectoryBasedFormat$lambda$0$0(JpsFileEntitySource $artifactSource, ArtifactEntityBuilder $this$modifyArtifactEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyArtifactEntity, (String)"$this$modifyArtifactEntity");
        $this$modifyArtifactEntity.setEntitySource($artifactSource);
        return Unit.INSTANCE;
    }

    private static final Unit changeEntitySourcesToDirectoryBasedFormat$lambda$0$1(MutableEntityStorage $builder, JpsFileEntitySource $artifactSource, PackagingElementEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $builder.modifyEntity(PackagingElementEntityBuilder.class, (WorkspaceEntity)it, arg_0 -> JpsArtifactsDirectorySerializerFactory.changeEntitySourcesToDirectoryBasedFormat$lambda$0$1$0($artifactSource, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit changeEntitySourcesToDirectoryBasedFormat$lambda$0$1$0(JpsFileEntitySource $artifactSource, PackagingElementEntityBuilder $this$modifyEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$this$modifyEntity");
        $this$modifyEntity.setEntitySource($artifactSource);
        return Unit.INSTANCE;
    }

    private static final Unit changeEntitySourcesToDirectoryBasedFormat$lambda$1$0(ArtifactPropertiesEntity $it, ArtifactPropertiesEntityBuilder $this$modifyArtifactPropertiesEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyArtifactPropertiesEntity, (String)"$this$modifyArtifactPropertiesEntity");
        $this$modifyArtifactPropertiesEntity.setEntitySource($it.getArtifact().getEntitySource());
        return Unit.INSTANCE;
    }
}

