/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.platform.workspace.jps.JpsGlobalFileEntitySource;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntityTypeSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsGlobalLibrariesFileSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsSdkEntitySerializer;
import com.intellij.platform.workspace.storage.InternalEnvironmentName;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsGlobalEntitiesSerializers;", "", "<init>", "()V", "SDK_FILE_NAME", "", "GLOBAL_LIBRARIES_FILE_NAME", "createApplicationSerializers", "", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntityTypeSerializer;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "sortedRootTypes", "optionsDir", "Ljava/nio/file/Path;", "environmentName", "Lcom/intellij/platform/workspace/storage/InternalEnvironmentName;", "createSdkSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsSdkEntitySerializer;", "resolveEnvironmentDir", "intellij.platform.workspace.jps"})
public final class JpsGlobalEntitiesSerializers {
    @NotNull
    public static final JpsGlobalEntitiesSerializers INSTANCE = new JpsGlobalEntitiesSerializers();
    @NotNull
    public static final String SDK_FILE_NAME = "jdk.table";
    @NotNull
    public static final String GLOBAL_LIBRARIES_FILE_NAME = "applicationLibraries";

    private JpsGlobalEntitiesSerializers() {
    }

    @NotNull
    public final List<JpsFileEntityTypeSerializer<WorkspaceEntity>> createApplicationSerializers(@NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull List<String> sortedRootTypes, @NotNull Path optionsDir, @NotNull InternalEnvironmentName environmentName) {
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        Intrinsics.checkNotNullParameter(sortedRootTypes, (String)"sortedRootTypes");
        Intrinsics.checkNotNullParameter((Object)optionsDir, (String)"optionsDir");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        List serializers = new ArrayList();
        JpsSdkEntitySerializer jpsSdkEntitySerializer = this.createSdkSerializer(virtualFileUrlManager, sortedRootTypes, optionsDir, environmentName);
        Intrinsics.checkNotNull((Object)jpsSdkEntitySerializer, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntityTypeSerializer<com.intellij.platform.workspace.storage.WorkspaceEntity>");
        serializers.add((JpsFileEntityTypeSerializer)jpsSdkEntitySerializer);
        Path environmentDir = this.resolveEnvironmentDir(optionsDir, environmentName);
        Path path = environmentDir.resolve("applicationLibraries.xml");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        VirtualFileUrl globalLibrariesFile = virtualFileUrlManager.getOrCreateFromUrl(((Object)path.toAbsolutePath()).toString());
        JpsGlobalFileEntitySource globalLibrariesEntitySource = new JpsGlobalFileEntitySource(globalLibrariesFile);
        serializers.add((JpsFileEntityTypeSerializer)new JpsGlobalLibrariesFileSerializer(globalLibrariesEntitySource));
        return serializers;
    }

    @NotNull
    public final JpsSdkEntitySerializer createSdkSerializer(@NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull List<String> sortedRootTypes, @NotNull Path optionsDir, @NotNull InternalEnvironmentName environmentName) {
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        Intrinsics.checkNotNullParameter(sortedRootTypes, (String)"sortedRootTypes");
        Intrinsics.checkNotNullParameter((Object)optionsDir, (String)"optionsDir");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Path environmentDir = this.resolveEnvironmentDir(optionsDir, environmentName);
        Path path = environmentDir.resolve("jdk.table.xml");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        VirtualFileUrl globalSdkFile = virtualFileUrlManager.getOrCreateFromUrl(((Object)path.toAbsolutePath()).toString());
        JpsGlobalFileEntitySource globalSdkEntitySource = new JpsGlobalFileEntitySource(globalSdkFile);
        return new JpsSdkEntitySerializer(globalSdkEntitySource, sortedRootTypes);
    }

    private final Path resolveEnvironmentDir(Path optionsDir, InternalEnvironmentName environmentName) {
        Path path;
        InternalEnvironmentName internalEnvironmentName = environmentName;
        if (Intrinsics.areEqual((Object)internalEnvironmentName, (Object)InternalEnvironmentName.Local.INSTANCE)) {
            path = optionsDir;
        } else if (internalEnvironmentName instanceof InternalEnvironmentName.Custom) {
            Path path2 = optionsDir.resolve(((InternalEnvironmentName.Custom)environmentName).getName());
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return path;
    }
}

