/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.serialization.impl.FileInDirectorySourceNames;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntityTypeSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsLibraryEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsProjectSerializersImplKt;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsLibrariesExternalFileSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsLibraryEntitiesSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntityTypeSerializer;", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "externalFile", "Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource$ExactFile;", "internalLibrariesDirUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "fileInDirectorySourceNames", "Lcom/intellij/platform/workspace/jps/serialization/impl/FileInDirectorySourceNames;", "<init>", "(Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource$ExactFile;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/jps/serialization/impl/FileInDirectorySourceNames;)V", "isExternalStorage", "", "()Z", "entityFilter", "Lkotlin/Function1;", "getEntityFilter", "()Lkotlin/jvm/functions/Function1;", "createEntitySource", "Lcom/intellij/platform/workspace/storage/EntitySource;", "libraryTag", "Lorg/jdom/Element;", "deleteObsoleteFile", "", "fileUrl", "", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nJpsLibraryEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsLibraryEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsLibrariesExternalFileSerializer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,341:1\n13#2:342\n60#2,5:343\n*S KotlinDebug\n*F\n+ 1 JpsLibraryEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsLibrariesExternalFileSerializer\n*L\n111#1:342\n111#1:343,5\n*E\n"})
public final class JpsLibrariesExternalFileSerializer
extends JpsLibraryEntitiesSerializer
implements JpsFileEntityTypeSerializer<LibraryEntity> {
    @NotNull
    private final JpsProjectFileEntitySource.ExactFile externalFile;
    @NotNull
    private final VirtualFileUrl internalLibrariesDirUrl;
    @NotNull
    private final FileInDirectorySourceNames fileInDirectorySourceNames;

    public JpsLibrariesExternalFileSerializer(@NotNull JpsProjectFileEntitySource.ExactFile externalFile, @NotNull VirtualFileUrl internalLibrariesDirUrl, @NotNull FileInDirectorySourceNames fileInDirectorySourceNames) {
        Intrinsics.checkNotNullParameter((Object)externalFile, (String)"externalFile");
        Intrinsics.checkNotNullParameter((Object)internalLibrariesDirUrl, (String)"internalLibrariesDirUrl");
        Intrinsics.checkNotNullParameter((Object)fileInDirectorySourceNames, (String)"fileInDirectorySourceNames");
        super(externalFile.getFile(), externalFile, LibraryTableId.ProjectLibraryTableId.INSTANCE);
        this.externalFile = externalFile;
        this.internalLibrariesDirUrl = internalLibrariesDirUrl;
        this.fileInDirectorySourceNames = fileInDirectorySourceNames;
    }

    @Override
    public boolean isExternalStorage() {
        return true;
    }

    @Override
    @NotNull
    public Function1<LibraryEntity, Boolean> getEntityFilter() {
        return JpsLibrariesExternalFileSerializer::_get_entityFilter_$lambda$0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected EntitySource createEntitySource(@NotNull Element libraryTag) {
        JpsProjectFileEntitySource.FileInDirectory fileInDirectory;
        Intrinsics.checkNotNullParameter((Object)libraryTag, (String)"libraryTag");
        String string = libraryTag.getAttributeValue("__external-system-id");
        if (string == null) {
            return null;
        }
        String externalSystemId = string;
        String libraryName = JpsProjectSerializersImplKt.getAttributeValueStrict(libraryTag, "name");
        JpsProjectFileEntitySource.FileInDirectory existingInternalSource = this.fileInDirectorySourceNames.findSource(this.getMainEntityClass(), libraryName);
        if (existingInternalSource != null && Intrinsics.areEqual((Object)existingInternalSource.getDirectory(), (Object)this.internalLibrariesDirUrl)) {
            void $this$debug_u24default$iv;
            boolean $i$f$logger22 = false;
            Logger logger = Logger.getInstance(JpsLibrariesExternalFileSerializer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Logger $i$f$logger22 = logger;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                void var10_9 = $this$debug_u24default$iv;
                boolean bl = false;
                var10_9.debug("Reuse existing source for library: " + existingInternalSource.getFileNameId() + "=" + libraryName, e$iv);
            }
            fileInDirectory = existingInternalSource;
        } else {
            fileInDirectory = new JpsProjectFileEntitySource.FileInDirectory(this.internalLibrariesDirUrl, this.externalFile.getProjectLocation());
        }
        JpsProjectFileEntitySource.FileInDirectory internalEntitySource = fileInDirectory;
        return new JpsImportedEntitySource(internalEntitySource, externalSystemId, true);
    }

    @Override
    public void deleteObsoleteFile(@NotNull String fileUrl, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.saveComponent(fileUrl, "libraryTable", null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean _get_entityFilter_$lambda$0(LibraryEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)it.getTableId(), (Object)LibraryTableId.ProjectLibraryTableId.INSTANCE)) return false;
        EntitySource entitySource = it.getEntitySource();
        if (!(entitySource instanceof JpsImportedEntitySource)) return false;
        JpsImportedEntitySource jpsImportedEntitySource = (JpsImportedEntitySource)entitySource;
        if (jpsImportedEntitySource == null) return false;
        if (!jpsImportedEntitySource.getStoredExternally()) return false;
        return true;
    }
}

