/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.platform.workspace.jps.CustomModuleEntitySource;
import com.intellij.platform.workspace.jps.JpsFileDependentEntitySource;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.util.PathUtilRt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"getAttributeValueStrict", "", "Lorg/jdom/Element;", "name", "getChildTagStrict", "isExternalModuleFile", "", "filePath", "getInternalFileSource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "source", "Lcom/intellij/platform/workspace/storage/EntitySource;", "intellij.platform.workspace.jps"})
public final class JpsProjectSerializersImplKt {
    @NotNull
    public static final String getAttributeValueStrict(@NotNull Element $this$getAttributeValueStrict, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$getAttributeValueStrict, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = $this$getAttributeValueStrict.getAttributeValue(name);
        if (string == null) {
            throw new JDOMException("Expected attribute " + name + " under " + $this$getAttributeValueStrict.getName() + " element");
        }
        return string;
    }

    @NotNull
    public static final Element getChildTagStrict(@NotNull Element $this$getChildTagStrict, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$getChildTagStrict, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Element element = $this$getChildTagStrict.getChild(name);
        if (element == null) {
            throw new JDOMException("Expected tag " + name + " under " + $this$getChildTagStrict.getName() + " element");
        }
        return element;
    }

    public static final boolean isExternalModuleFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String string = PathUtilRt.getParentPath((String)filePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
        String parentPath = string;
        return StringsKt.endsWith$default((String)filePath, (String)".xml", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)PathUtilRt.getFileName((String)parentPath), (Object)"modules") && !Intrinsics.areEqual((Object)PathUtilRt.getFileName((String)PathUtilRt.getParentPath((String)parentPath)), (Object)".idea");
    }

    @Nullable
    public static final JpsFileEntitySource getInternalFileSource(@NotNull EntitySource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        EntitySource entitySource = source;
        return entitySource instanceof JpsFileDependentEntitySource ? ((JpsFileDependentEntitySource)source).getOriginalSource() : (entitySource instanceof CustomModuleEntitySource ? ((CustomModuleEntitySource)source).getInternalSource() : (entitySource instanceof JpsFileEntitySource ? (JpsFileEntitySource)source : null));
    }
}

