/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.sync;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.execution.wsl.AbstractWslDistribution;
import com.intellij.execution.wsl.sync.FilePathRelativeToDir;
import com.intellij.execution.wsl.sync.FileStorage;
import com.intellij.execution.wsl.sync.MyFileVisitor;
import com.intellij.execution.wsl.sync.WindowsFileStorageKt;
import com.intellij.execution.wsl.sync.WslHashFilters;
import com.intellij.execution.wsl.sync.WslSyncData;
import com.intellij.execution.wsl.sync.WslSyncSharedKt;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.Compressor;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.PathKt;
import com.intellij.util.system.CpuArch;
import java.io.Closeable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\r\u0018\u00002\u0016\u0012\b\u0012\u00060\u0002j\u0002`\u0003\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0001B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000e\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u00020\f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\u0016\u0010\u001c\u001a\u00020\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0002H\u0016J\u0016\u0010 \u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u001eH\u0016J!\u0010\"\u001a\u00020\f2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u000e\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010$J\u0014\u0010%\u001a\u00020\f2\n\u0010&\u001a\u00060\u0002j\u0002`\u0003H\u0016J\"\u0010'\u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e2\n\u0010(\u001a\u00060\u0004j\u0002`\u0005H\u0016J\u0014\u0010)\u001a\u00020\f2\n\u0010*\u001a\u00060\u0002j\u0002`\u0003H\u0016\u00a8\u0006+"}, d2={"Lcom/intellij/execution/wsl/sync/WindowsFileStorage;", "Lcom/intellij/execution/wsl/sync/FileStorage;", "Ljava/nio/file/Path;", "Lcom/intellij/execution/wsl/sync/WindowsFilePath;", "", "Lcom/intellij/execution/wsl/sync/LinuxFilePath;", "dir", "distro", "Lcom/intellij/execution/wsl/AbstractWslDistribution;", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/execution/wsl/AbstractWslDistribution;)V", "runCommand", "", "commands", "", "([Ljava/lang/String;)V", "createSymLinks", "links", "", "Lcom/intellij/execution/wsl/sync/FilePathRelativeToDir;", "calculateSyncData", "Lcom/intellij/execution/wsl/sync/WslSyncData;", "filters", "Lcom/intellij/execution/wsl/sync/WslHashFilters;", "skipHash", "", "useStubs", "isEmpty", "removeFiles", "filesToRemove", "", "createTempFile", "createStubs", "files", "removeLinks", "linksToRemove", "([Lcom/intellij/execution/wsl/sync/FilePathRelativeToDir;)V", "unTar", "tarFile", "tarAndCopyTo", "destTar", "removeTempFile", "file", "intellij.platform.wsl.impl"})
public final class WindowsFileStorage
extends FileStorage<Path, String> {
    public WindowsFileStorage(@NotNull Path dir, @NotNull AbstractWslDistribution distro) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)distro, (String)"distro");
        super(dir, distro);
    }

    private final void runCommand(String ... commands) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)"cmd");
        spreadBuilder.add((Object)"/c");
        spreadBuilder.addSpread((Object)commands);
        Object[] cmd = (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]);
        ProcessOutput it = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(Arrays.copyOf(cmd, cmd.length)));
        boolean bl = false;
        if (it.getExitCode() != 0) {
            throw new Exception("Can't run command " + ArraysKt.joinToString$default((Object[])cmd, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + ": " + it.getStderr());
        }
    }

    @Override
    public void createSymLinks(@NotNull Map<FilePathRelativeToDir, FilePathRelativeToDir> links) {
        Intrinsics.checkNotNullParameter(links, (String)"links");
        for (Map.Entry<FilePathRelativeToDir, FilePathRelativeToDir> entry : links.entrySet()) {
            String[] stringArray;
            FilePathRelativeToDir source = entry.getKey();
            FilePathRelativeToDir target = entry.getValue();
            Path sourceDir = ((Path)this.getDir()).resolve(source.getAsWindowsPath());
            Path targetDir = ((Path)this.getDir()).resolve(target.getAsWindowsPath());
            Intrinsics.checkNotNullExpressionValue((Object)sourceDir.getParent(), (String)"getParent(...)");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists((Path)stringArray, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            stringArray = new String[]{"mklink", "/J", ((Object)sourceDir).toString(), ((Object)targetDir).toString()};
            this.runCommand(stringArray);
        }
    }

    @Override
    @NotNull
    public WslSyncData calculateSyncData(@NotNull WslHashFilters filters, boolean skipHash, boolean useStubs) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        String arch = System.getProperty("os.arch");
        boolean useNativeHash = CpuArch.CURRENT == CpuArch.X86_64;
        WindowsFileStorageKt.access$getLOGGER$p().info("Arch " + arch + ", using native hash: " + useNativeHash);
        XXHash64 hashTool = useNativeHash ? XXHashFactory.nativeInstance().hash64() : XXHashFactory.safeInstance().hash64();
        Path path = (Path)this.getDir();
        Intrinsics.checkNotNull((Object)hashTool);
        MyFileVisitor visitor = new MyFileVisitor(filters, path, hashTool, skipHash, useStubs);
        long time2 = TimeoutUtil.measureExecutionTime(() -> WindowsFileStorage.calculateSyncData$lambda$0(this, visitor));
        WindowsFileStorageKt.access$getLOGGER$p().info("Windows files calculated in " + time2);
        return new WslSyncData(visitor.getHashes(), visitor.getDirLinks(), visitor.getStubs());
    }

    @Override
    public boolean isEmpty() {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.notExists((Path)this.getDir(), Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || PathsKt.listDirectoryEntries$default((Path)((Path)this.getDir()), null, (int)1, null).isEmpty();
    }

    @Override
    public void removeFiles(@NotNull Collection<FilePathRelativeToDir> filesToRemove) {
        Intrinsics.checkNotNullParameter(filesToRemove, (String)"filesToRemove");
        if (filesToRemove.isEmpty()) {
            return;
        }
        for (FilePathRelativeToDir file : filesToRemove) {
            Path fileToDelete = ((Path)this.getDir()).resolve(file.getAsWindowsPath());
            boolean bl = fileToDelete.startsWith((Path)this.getDir());
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Files.delete(fileToDelete);
        }
        WindowsFileStorageKt.access$getLOGGER$p().info(filesToRemove.size() + " files removed");
    }

    @Override
    @NotNull
    public Path createTempFile() {
        return (Path)WslSyncSharedKt.createTmpWinFile(this.getDistro()).getFirst();
    }

    @Override
    public void createStubs(@NotNull Collection<FilePathRelativeToDir> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        for (FilePathRelativeToDir file : files) {
            Path filePath = ((Path)this.getDir()).resolve(file.getAsWindowsPath());
            Intrinsics.checkNotNull((Object)filePath);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(filePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(PathKt.createParentDirectories((Path)filePath), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        }
    }

    @Override
    public void removeLinks(FilePathRelativeToDir ... linksToRemove) {
        Intrinsics.checkNotNullParameter((Object)linksToRemove, (String)"linksToRemove");
        for (FilePathRelativeToDir link : linksToRemove) {
            String[] stringArray = new String[]{"rmdir", ((Object)((Path)this.getDir()).resolve(link.getAsWindowsPath())).toString()};
            this.runCommand(stringArray);
        }
    }

    @Override
    public void unTar(@NotNull Path tarFile) {
        Intrinsics.checkNotNullParameter((Object)tarFile, (String)"tarFile");
        WindowsFileStorageKt.access$getLOGGER$p().info("Unpacking");
        new Decompressor.Tar(tarFile).extract((Path)this.getDir());
    }

    @Override
    public void tarAndCopyTo(@NotNull Collection<FilePathRelativeToDir> files, @NotNull String destTar) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)destTar, (String)"destTar");
        WindowsFileStorageKt.access$getLOGGER$p().info("Creating tar");
        Path tarFile = this.createTempFile();
        CompletableFuture<Unit> feature = CompletableFuture.supplyAsync(() -> WindowsFileStorage.tarAndCopyTo$lambda$0(tarFile, files, this));
        Path dest = this.getDistro().getUNCRootPath().resolve(destTar);
        feature.get();
        WindowsFileStorageKt.access$getLOGGER$p().info("Copying");
        Files.copy(tarFile, dest, new CopyOption[0]);
        PathKt.delete$default((Path)tarFile, (boolean)false, (int)1, null);
    }

    @Override
    public void removeTempFile(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PathKt.delete$default((Path)file, (boolean)false, (int)1, null);
    }

    private static final void calculateSyncData$lambda$0(WindowsFileStorage this$0, MyFileVisitor $visitor) {
        Files.walkFileTree((Path)this$0.getDir(), $visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit tarAndCopyTo$lambda$0(Path $tarFile, Collection $files, WindowsFileStorage this$0) {
        Closeable closeable = (Closeable)new Compressor.Tar($tarFile, Compressor.Tar.Compression.NONE);
        Throwable throwable = null;
        try {
            Compressor.Tar tar = (Compressor.Tar)closeable;
            boolean bl = false;
            for (FilePathRelativeToDir relativeFile : $files) {
                tar.addFile(relativeFile.getAsWindowsPath(), ((Path)this$0.getDir()).resolve(relativeFile.getAsWindowsPath()));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }
}

