/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template;

import com.google.common.collect.Sets;
import com.intellij.jinja.template.psi.impl.DjangoTemplateFileImpl;
import com.intellij.jinja.template.psi.impl.DjangoTemplateHierarchyVisitor;
import com.intellij.jinja.template.psi.impl.Jinja2BlockNameImpl;
import com.intellij.jinja.template.tags.Jinja2BlockTag;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.django.lang.template.DjangoBlockInheritanceIndex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class DjangoBlockInheritorsSearchExecutor
implements QueryExecutor<PsiElement, PsiElement> {
    public boolean execute(@NotNull PsiElement queryParameters, @NotNull Processor<? super PsiElement> consumer) {
        if (queryParameters == null) {
            DjangoBlockInheritorsSearchExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            DjangoBlockInheritorsSearchExecutor.$$$reportNull$$$0(1);
        }
        if (queryParameters instanceof Jinja2BlockNameImpl) {
            return DjangoBlockInheritorsSearchExecutor.processDirectInheritors((Jinja2BlockNameImpl)queryParameters, consumer);
        }
        return true;
    }

    private static boolean processDirectInheritors(Jinja2BlockNameImpl djangoBlockName, Processor<? super PsiElement> consumer) {
        ApplicationManager.getApplication().runReadAction(() -> {
            String name = djangoBlockName.getName();
            Project project = djangoBlockName.getProject();
            DjangoTemplateFileImpl djangoTemplateFile = (DjangoTemplateFileImpl)djangoBlockName.getContainingFile();
            if (djangoTemplateFile == null || djangoTemplateFile.getVirtualFile() == null) {
                return;
            }
            HashSet inheritBaseFiles = Sets.newHashSet((Object[])new VirtualFile[]{djangoTemplateFile.getVirtualFile()});
            HashSet otherFiles = new HashSet();
            FileBasedIndex.getInstance().getFilesWithKey(DjangoBlockInheritanceIndex.DJANGO_BLOCK_INHERITANCE_INDEX, (Set)Sets.newHashSet((Object[])new String[]{name}), file -> {
                PsiFile psiFile;
                Document doc;
                if (!file.equals(djangoTemplateFile.getVirtualFile()) && (doc = FileDocumentManager.getInstance().getDocument(file)) != null && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(doc)) != null) {
                    Visitor v = new Visitor(name, inheritBaseFiles, otherFiles);
                    psiFile.accept((PsiElementVisitor)v);
                    if (v.isInheritsBase()) {
                        for (Jinja2BlockNameImpl blockName : v.getBlockNames()) {
                            consumer.process((Object)blockName);
                        }
                        inheritBaseFiles.addAll(v.getVisited());
                    } else {
                        otherFiles.addAll(v.getVisited());
                    }
                }
                return true;
            }, GlobalSearchScope.allScope((Project)project));
        });
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/django/lang/template/DjangoBlockInheritorsSearchExecutor";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Visitor
    extends DjangoTemplateHierarchyVisitor {
        private final List<Jinja2BlockNameImpl> myBlockNames = new ArrayList<Jinja2BlockNameImpl>();
        private final Set<VirtualFile> myVisited = new HashSet<VirtualFile>();
        private final Set<VirtualFile> myInheritBaseFiles;
        private final Set<VirtualFile> myOtherFiles;
        private final String myBlockName;
        private boolean myInheritsBase = false;

        private Visitor(String name, Set<VirtualFile> inheritBaseFiles, Set<VirtualFile> othersFiles) {
            this.myBlockName = name;
            this.myInheritBaseFiles = inheritBaseFiles;
            this.myOtherFiles = othersFiles;
        }

        public void visitFile(@NotNull PsiFile psiFile) {
            VirtualFile virtualFile;
            if (psiFile == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (this.myInheritBaseFiles.contains(virtualFile = psiFile.getVirtualFile())) {
                this.myInheritsBase = true;
                return;
            }
            if (this.myOtherFiles.contains(virtualFile)) {
                return;
            }
            this.myVisited.add(virtualFile);
            super.visitFile(psiFile);
        }

        public void visitBlockTag(Jinja2BlockTag blockTag) {
            Jinja2BlockNameImpl blockName = blockTag.getBlockNameElement();
            if (blockName != null && this.myBlockName.equals(blockName.getName())) {
                this.myBlockNames.add(blockName);
            }
        }

        public List<Jinja2BlockNameImpl> getBlockNames() {
            return this.myBlockNames;
        }

        public boolean isInheritsBase() {
            return this.myInheritsBase;
        }

        public Set<VirtualFile> getVisited() {
            return this.myVisited;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/python/django/lang/template/DjangoBlockInheritorsSearchExecutor$Visitor", "visitFile"));
        }
    }
}

