/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.jinja.template.DjangoTemplateFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.python.django.lang.template.DjangoWebUrlEvaluator;
import com.intellij.template.lang.core.templateLanguages.PythonTemplateLanguage;
import com.intellij.template.lang.core.templateLanguages.TemplatesService;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.django.facet.DjangoFacet;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebBrowserUrlProvider;

public final class DjangoWebBrowserUrlProvider
extends BuiltInWebBrowserUrlProvider {
    @Nullable
    protected Url getUrl(@NotNull OpenInBrowserRequest request, @NotNull VirtualFile file) {
        String url;
        int port;
        if (request == null) {
            DjangoWebBrowserUrlProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DjangoWebBrowserUrlProvider.$$$reportNull$$$0(1);
        }
        if ((port = DjangoWebBrowserUrlProvider.getRunningDjangoServerPort(request.getProject())) > 0 && (url = DjangoWebUrlEvaluator.getInstance(request.getProject()).getDjangoUrlPath((PsiElement)request.getFile(), port)) != null) {
            return Urls.parseFromIdea((CharSequence)url);
        }
        return super.getUrl(request, file);
    }

    public boolean canHandleElement(@NotNull OpenInBrowserRequest request) {
        int port;
        if (request == null) {
            DjangoWebBrowserUrlProvider.$$$reportNull$$$0(2);
        }
        if (super.canHandleElement(request)) {
            return true;
        }
        PsiFile requestFile = request.getFile();
        return (HtmlUtil.isHtmlFile((PsiElement)requestFile) || requestFile.getFileType().equals((Object)DjangoTemplateFileType.INSTANCE)) && (port = DjangoWebBrowserUrlProvider.getRunningDjangoServerPort(request.getProject())) > 0;
    }

    protected boolean isFileOfMyLanguage(@NotNull PsiFile psiFile) {
        List templateFolders;
        VirtualFile virtualFile;
        Module moduleForFile;
        if (psiFile == null) {
            DjangoWebBrowserUrlProvider.$$$reportNull$$$0(3);
        }
        if (DjangoFacet.isPresent((Module)(moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)(virtualFile = psiFile.getVirtualFile()), (Project)psiFile.getProject()))) && !VfsUtilCore.isUnder((VirtualFile)virtualFile, new HashSet(templateFolders = TemplatesService.getInstance((Module)moduleForFile).getTemplateFolders()))) {
            return super.isFileOfMyLanguage(psiFile) || psiFile.getViewProvider().getBaseLanguage() instanceof PythonTemplateLanguage;
        }
        return false;
    }

    private static int getRunningDjangoServerPort(Project project) {
        ProcessHandler[] processes;
        for (ProcessHandler process : processes = ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            String commandLine;
            if (!(process instanceof OSProcessHandler) || (commandLine = ((OSProcessHandler)process).getCommandLine()) == null || !commandLine.contains("manage.py")) continue;
            try {
                return Integer.parseInt(commandLine.substring(commandLine.lastIndexOf(32) + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/django/lang/template/DjangoWebBrowserUrlProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canHandleElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileOfMyLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

