/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterDebugger;
import com.intellij.jupyter.core.jupyter.editor.JupyterEditorCustomizer;
import com.intellij.jupyter.py.debugger.JupyterDebugCellIdManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/py/debugger/DebugJupyterEditorCustomizer;", "Lcom/intellij/jupyter/core/jupyter/editor/JupyterEditorCustomizer;", "<init>", "()V", "onEditorCreated", "", "project", "Lcom/intellij/openapi/project/Project;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "initDebuggerListener", "editor", "notebookSourceFile", "updateBreakpointsUI", "intellij.jupyter.py"})
public final class DebugJupyterEditorCustomizer
implements JupyterEditorCustomizer {
    public void onEditorCreated(@NotNull Project project, @NotNull TextEditor textEditor, @NotNull BackedNotebookVirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.initDebuggerListener(project, textEditor, virtualFile);
    }

    private final void initDebuggerListener(Project project, TextEditor editor, BackedNotebookVirtualFile notebookSourceFile) {
        this.updateBreakpointsUI(project, notebookSourceFile);
        editor.getEditor().getDocument().addDocumentListener(new DocumentListener(project, notebookSourceFile){
            final /* synthetic */ Project $project;
            final /* synthetic */ BackedNotebookVirtualFile $notebookSourceFile;
            {
                this.$project = $project;
                this.$notebookSourceFile = $notebookSourceFile;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (JupyterDebugger.INSTANCE.isUnderDebugger(this.$project, this.$notebookSourceFile)) {
                    JupyterDebugCellIdManager.updatePositions$default(JupyterDebugCellIdManager.Companion.getInstance(this.$project), this.$project, this.$notebookSourceFile, null, 4, null);
                }
            }
        });
    }

    private final void updateBreakpointsUI(Project project, BackedNotebookVirtualFile notebookSourceFile) {
        block2: {
            Document parentDocument;
            XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
            Intrinsics.checkNotNull((Object)xBreakpointManager, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl");
            XBreakpointManagerImpl breakpointManager = (XBreakpointManagerImpl)xBreakpointManager;
            XLineBreakpointManager lineBreakpointManager = breakpointManager.getLineBreakpointManager();
            Document document = parentDocument = FileDocumentManagerImpl.getInstance().getDocument(notebookSourceFile.getOriginFile());
            if (document == null) break block2;
            Document $this$updateBreakpointsUI_u24lambda_u240 = document;
            boolean bl = false;
            Collection originalBreakpoints = lineBreakpointManager.getDocumentBreakpoints(parentDocument);
            for (XLineBreakpointImpl breakpoint : originalBreakpoints) {
                if (!Intrinsics.areEqual((Object)breakpoint.getType().getId(), (Object)"jupyter-line")) continue;
                RangeHighlighter rangeHighlighter = breakpoint.getHighlighter();
                if (rangeHighlighter != null) {
                    rangeHighlighter.dispose();
                }
                breakpoint.updateUI();
            }
        }
    }
}

