/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template;

import com.google.common.collect.ImmutableSet;
import com.intellij.jinja.template.psi.Jinja2TemplateElementTypes;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private final Set<Language> myLanguages;
    private final Language myBaseLanguage;
    private final Language myTemplateDataLanguage;

    public DjangoTemplateFileViewProvider(PsiManager manager, @NotNull VirtualFile virtualFile, boolean physical, Language baseLanguage) {
        if (virtualFile == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(0);
        }
        this(manager, virtualFile, physical, baseLanguage, DjangoTemplateFileViewProvider.calcTemplateDataLanguage(manager.getProject(), virtualFile));
    }

    public DjangoTemplateFileViewProvider(PsiManager manager, @NotNull VirtualFile virtualFile, boolean physical, Language baseLanguage, Language dataLanguage) {
        if (virtualFile == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(1);
        }
        super(manager, virtualFile, physical);
        this.myBaseLanguage = baseLanguage;
        this.myTemplateDataLanguage = dataLanguage;
        this.myLanguages = ImmutableSet.of((Object)this.getBaseLanguage(), (Object)this.getTemplateDataLanguage());
    }

    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myBaseLanguage;
        if (language == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(2);
        }
        return language;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(3);
        }
        return language;
    }

    @NotNull
    private static Language calcTemplateDataLanguage(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(4);
        }
        file = VirtualFileUtil.originalFileOrSelf((VirtualFile)file);
        Language language = null;
        TemplateDataLanguageMappings mappings = TemplateDataLanguageMappings.getInstance((Project)project);
        if (mappings != null) {
            language = mappings.getMapping(file);
        }
        List templateableLanguages = TemplateDataLanguageMappings.getTemplateableLanguages();
        FileType type = file.getFileType();
        if (type instanceof LanguageFileType && language == null) {
            Language fileLanguage = ((LanguageFileType)type).getLanguage();
            if (templateableLanguages.contains(language)) {
                language = fileLanguage;
            }
        }
        if (language == null) {
            language = HTMLLanguage.INSTANCE;
        }
        for (LanguageSubstitutor substitutor : LanguageSubstitutors.getInstance().forKey((Object)language)) {
            Language l = substitutor.getLanguage(file, project);
            if (!templateableLanguages.contains(l) || l == null) continue;
            Language language2 = l;
            if (language2 == null) {
                DjangoTemplateFileViewProvider.$$$reportNull$$$0(5);
            }
            return language2;
        }
        Language language3 = language;
        if (language3 == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(6);
        }
        return language3;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(7);
        }
        return new DjangoTemplateFileViewProvider((PsiManager)this.getManager(), virtualFile, false, this.myBaseLanguage, this.myTemplateDataLanguage);
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = this.myLanguages;
        if (set == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(8);
        }
        return set;
    }

    protected PsiFile createFile(@NotNull Language lang) {
        ParserDefinition def;
        if (lang == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(9);
        }
        if ((def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)) == null) {
            return null;
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file = (PsiFileImpl)def.createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)Jinja2TemplateElementTypes.TEMPLATE_DATA);
            return file;
        }
        if (lang == this.myBaseLanguage) {
            return def.createFile((FileViewProvider)this);
        }
        return null;
    }

    @Nullable
    public IElementType getContentElementType(@NotNull Language language) {
        if (language == null) {
            DjangoTemplateFileViewProvider.$$$reportNull$$$0(10);
        }
        return language == this.getTemplateDataLanguage() ? Jinja2TemplateElementTypes.TEMPLATE_DATA : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jinja/template/DjangoTemplateFileViewProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jinja/template/DjangoTemplateFileViewProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTemplateDataLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcTemplateDataLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContentElementType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

