/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.figures.base;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.scientific.figures.WithBinaryContent;
import com.intellij.python.scientific.figures.image.ImageVirtualFile;
import com.intellij.python.scientific.ui.ScientificImageEditorUIConfigurator;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.scientific.utils.ScientificUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 &2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001&B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0004J\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0018H\u0016J\b\u0010!\u001a\u00020\u0018H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010#H&J\b\u0010$\u001a\u00020\nH&J\b\u0010%\u001a\u00020\u0012H&R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0012@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lcom/intellij/python/scientific/figures/base/FigureContentPanelBase;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/python/scientific/figures/WithBinaryContent;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "editorTypeId", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "value", "Lcom/intellij/openapi/fileEditor/FileEditor;", "editor", "getEditor", "()Lcom/intellij/openapi/fileEditor/FileEditor;", "", "isHidden", "()Z", "setHidden", "(Z)V", "dispose", "", "getBytes", "", "addEditorComponent", "createEditorComponent", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "closeEditor", "reinitEditor", "getFileWithBinaryContent", "Lcom/intellij/python/scientific/figures/image/ImageVirtualFile;", "getFormat", "isPngAvailable", "Companion", "intellij.python.scientific"})
public abstract class FigureContentPanelBase
extends JPanel
implements Disposable,
WithBinaryContent,
UiDataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final Project project;
    @NotNull
    private final String editorTypeId;
    private FileEditor editor;
    private boolean isHidden;
    @NotNull
    private static final DataKey<FigureContentPanelBase> FIGURE_CONTENT_PANEL_BASE = DataKey.Companion.create("FigureContentPanelBase");

    public FigureContentPanelBase(@NotNull VirtualFile virtualFile, @NotNull Project project, @NotNull String editorTypeId) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editorTypeId, (String)"editorTypeId");
        super(new BorderLayout());
        this.virtualFile = virtualFile;
        this.project = project;
        this.editorTypeId = editorTypeId;
        this.addEditorComponent();
        this.setBackground(UIUtil.getEditorPaneBackground());
    }

    @NotNull
    public final FileEditor getEditor() {
        FileEditor fileEditor = this.editor;
        if (fileEditor != null) {
            return fileEditor;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"editor");
        return null;
    }

    public final boolean isHidden() {
        return this.isHidden;
    }

    protected final void setHidden(boolean bl) {
        this.isHidden = bl;
    }

    public void dispose() {
        ImageVirtualFile imageVirtualFile = this.getFileWithBinaryContent();
        if (imageVirtualFile != null) {
            imageVirtualFile.clearImage();
        }
        Disposer.dispose((Disposable)((Disposable)this.getEditor()));
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        Object object;
        block3: {
            block2: {
                object = this.getFileWithBinaryContent();
                if (object == null) break block2;
                byte[] byArray = object.getContent();
                object = byArray;
                if (byArray != null) break block3;
            }
            object = new byte[0];
        }
        return object;
    }

    protected final void addEditorComponent() {
        ApplicationManager.getApplication().invokeLater(() -> FigureContentPanelBase.addEditorComponent$lambda$0(this));
    }

    @Nullable
    public final FileEditor createEditorComponent() {
        boolean isScientificMode;
        FileEditorProvider fileEditorProvider = FileEditorProviderManager.Companion.getInstance().getProvider(this.editorTypeId);
        if (fileEditorProvider == null) {
            return null;
        }
        FileEditorProvider provider = fileEditorProvider;
        FileEditor fileEditor = provider.createEditor(this.project, this.virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"createEditor(...)");
        FileEditor createdEditor = fileEditor;
        VirtualFile virtualFile = createdEditor.getFile();
        boolean bl = isScientificMode = (virtualFile != null ? (Unit)virtualFile.getUserData(ScientificUtils.SCIENTIFIC_MODE_KEY) : null) != null;
        if (isScientificMode) {
            new ScientificImageEditorUIConfigurator(createdEditor, this.virtualFile).configure();
        }
        return createdEditor;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(FIGURE_CONTENT_PANEL_BASE, (Object)this);
    }

    public void closeEditor() {
    }

    public void reinitEditor() {
    }

    @Nullable
    public abstract ImageVirtualFile getFileWithBinaryContent();

    @NotNull
    public abstract String getFormat();

    public abstract boolean isPngAvailable();

    private static final void addEditorComponent$lambda$0(FigureContentPanelBase this$0) {
        FileEditor fileEditor = this$0.createEditorComponent();
        if (fileEditor == null) {
            return;
        }
        this$0.editor = fileEditor;
        this$0.add((Component)this$0.getEditor().getComponent(), "Center");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/python/scientific/figures/base/FigureContentPanelBase$Companion;", "", "<init>", "()V", "FIGURE_CONTENT_PANEL_BASE", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/python/scientific/figures/base/FigureContentPanelBase;", "getFIGURE_CONTENT_PANEL_BASE", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.python.scientific"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<FigureContentPanelBase> getFIGURE_CONTENT_PANEL_BASE() {
            return FIGURE_CONTENT_PANEL_BASE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

