/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.commandCodeProviders;

import com.intellij.scientific.py.tables.api.PyDevdID;
import com.intellij.scientific.py.tables.commandCodeProviders.Utils;
import com.intellij.scientific.py.tables.inspections.api.Inspection;
import com.intellij.scientific.tables.api.command.DescribeTableCommand;
import com.intellij.scientific.tables.api.command.ImageCommand;
import com.intellij.scientific.tables.api.command.InfoTableCommand;
import com.intellij.scientific.tables.api.command.InspectionsTableCommand;
import com.intellij.scientific.tables.api.command.SliceTableCommand;
import com.intellij.scientific.tables.api.command.TableCommand;
import com.intellij.scientific.tables.api.command.VisualizationDataTableCommand;
import com.intellij.scientific.tables.api.commandCodeProviders.TableCommandCodeProvider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/scientific/py/tables/commandCodeProviders/PythonTableCommandCodeProvider;", "Lcom/intellij/scientific/tables/api/commandCodeProviders/TableCommandCodeProvider;", "pydevdId", "Lcom/intellij/scientific/py/tables/api/PyDevdID;", "<init>", "(Lcom/intellij/scientific/py/tables/api/PyDevdID;)V", "getPydevdId", "()Lcom/intellij/scientific/py/tables/api/PyDevdID;", "functionDefinitions", "", "getCommandCode", "tableCommand", "Lcom/intellij/scientific/tables/api/command/TableCommand;", "getInfoCommandCode", "infoCommand", "Lcom/intellij/scientific/tables/api/command/InfoTableCommand;", "getSliceCommandCode", "sliceCommand", "Lcom/intellij/scientific/tables/api/command/SliceTableCommand;", "buildSliceCommand", "infoCommands", "getDescribeCommandCode", "command", "Lcom/intellij/scientific/tables/api/command/DescribeTableCommand;", "describeCommands", "getVisualizationDataCommandCode", "Lcom/intellij/scientific/tables/api/command/VisualizationDataTableCommand;", "visualizationCommands", "getInspectionCommandCode", "inspectionCommand", "Lcom/intellij/scientific/tables/api/command/InspectionsTableCommand;", "buildInspectionCommandCodeWithDefinitions", "commandToExecute", "intellij.scientific.py.tables"})
public final class PythonTableCommandCodeProvider
implements TableCommandCodeProvider {
    @NotNull
    private final PyDevdID pydevdId;
    @NotNull
    private final String functionDefinitions;
    @NotNull
    private final String infoCommands;
    @NotNull
    private final String describeCommands;
    @NotNull
    private final String visualizationCommands;

    public PythonTableCommandCodeProvider(@NotNull PyDevdID pydevdId) {
        Intrinsics.checkNotNullParameter((Object)((Object)pydevdId), (String)"pydevdId");
        this.pydevdId = pydevdId;
        this.functionDefinitions = Utils.INSTANCE.getTableFunctionsDefinitions(this.pydevdId);
        String[] stringArray = new String[]{"get_type(initCommandResult)", "'__pydev_val__'", "get_shape(initCommandResult)", "'__pydev_val__'", "get_head(initCommandResult)", "'__pydev_val__'", "get_column_types(initCommandResult)"};
        this.infoCommands = Utils.INSTANCE.formatPythonCommands(stringArray);
        stringArray = new String[]{"get_column_descriptions(initCommandResult)"};
        this.describeCommands = Utils.INSTANCE.formatPythonCommands(stringArray);
        stringArray = new String[]{"get_value_occurrences_count(initCommandResult)", "'__pydev_val__'"};
        this.visualizationCommands = Utils.INSTANCE.formatPythonCommands(stringArray);
    }

    @NotNull
    public final PyDevdID getPydevdId() {
        return this.pydevdId;
    }

    @NotNull
    public String getCommandCode(@NotNull TableCommand tableCommand) {
        String string;
        Intrinsics.checkNotNullParameter((Object)tableCommand, (String)"tableCommand");
        TableCommand tableCommand2 = tableCommand;
        if (tableCommand2 instanceof InfoTableCommand) {
            string = this.getInfoCommandCode((InfoTableCommand)tableCommand);
        } else if (tableCommand2 instanceof SliceTableCommand) {
            string = this.getSliceCommandCode((SliceTableCommand)tableCommand);
        } else if (tableCommand2 instanceof DescribeTableCommand) {
            string = this.getDescribeCommandCode((DescribeTableCommand)tableCommand);
        } else if (tableCommand2 instanceof VisualizationDataTableCommand) {
            string = this.getVisualizationDataCommandCode((VisualizationDataTableCommand)tableCommand);
        } else if (tableCommand2 instanceof InspectionsTableCommand) {
            string = this.getInspectionCommandCode((InspectionsTableCommand)tableCommand);
        } else {
            if (tableCommand2 instanceof ImageCommand) {
                throw new UnsupportedOperationException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String getInfoCommandCode(InfoTableCommand infoCommand) {
        return Utils.INSTANCE.commandTemplate(infoCommand.getTableVariable(), this.functionDefinitions, this.infoCommands);
    }

    private final String getSliceCommandCode(SliceTableCommand sliceCommand) {
        String command = this.buildSliceCommand(sliceCommand);
        return Utils.INSTANCE.commandTemplate(sliceCommand.getTableVariable(), this.functionDefinitions, command);
    }

    private final String buildSliceCommand(SliceTableCommand tableCommand) {
        String sliceFunction = tableCommand.getUseCsvSerialization() ? "display_data_csv" : "display_data_html";
        return sliceFunction + "(initCommandResult, " + tableCommand.getStartRow() + ", " + tableCommand.getEndRow() + ")";
    }

    private final String getDescribeCommandCode(DescribeTableCommand command) {
        return Utils.INSTANCE.commandTemplate(command.getTableVariable(), this.functionDefinitions, this.describeCommands);
    }

    private final String getVisualizationDataCommandCode(VisualizationDataTableCommand command) {
        return Utils.INSTANCE.commandTemplate(command.getTableVariable(), this.functionDefinitions, this.visualizationCommands);
    }

    private final String getInspectionCommandCode(InspectionsTableCommand inspectionCommand) {
        Inspection inspectionType = Inspection.Companion.fromInspectionNameInString(inspectionCommand.getInspectionName());
        String[] stringArray = new String[]{inspectionType.getPythonFunctionName() + "(initCommandResult)"};
        String inspectionCommandToExecute = Utils.INSTANCE.formatPythonCommands(stringArray);
        return this.buildInspectionCommandCodeWithDefinitions(inspectionCommand, inspectionCommandToExecute);
    }

    private final String buildInspectionCommandCodeWithDefinitions(InspectionsTableCommand inspectionCommand, String commandToExecute) {
        return Utils.INSTANCE.createCommandTemplateWithPythonTimeout(inspectionCommand.getTableVariable(), inspectionCommand.getTimeout(), this.functionDefinitions, commandToExecute);
    }
}

