/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.inspections.tree;

import com.intellij.scientific.py.tables.PyTablesBundle;
import com.intellij.scientific.py.tables.inspections.tree.nodes.InspectionGroupNode;
import com.intellij.scientific.py.tables.inspections.tree.nodes.InspectionLeafNode;
import com.intellij.scientific.py.tables.inspections.tree.nodes.InspectionRootNode;
import com.intellij.scientific.py.tables.inspections.tree.nodes.InspectionTreeNodeBase;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J@\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/scientific/py/tables/inspections/tree/InspectionsTreeCellRenderer;", "Lcom/intellij/ui/CheckboxTree$CheckboxTreeCellRenderer;", "hasQuickFixProvider", "", "<init>", "(Z)V", "customizeRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "expanded", "leaf", "row", "", "hasFocus", "renderGroupNode", "node", "Lcom/intellij/scientific/py/tables/inspections/tree/nodes/InspectionGroupNode;", "renderLeafNode", "Lcom/intellij/scientific/py/tables/inspections/tree/nodes/InspectionLeafNode;", "setupQuickFixCheckbox", "intellij.scientific.py.tables"})
public final class InspectionsTreeCellRenderer
extends CheckboxTree.CheckboxTreeCellRenderer {
    private final boolean hasQuickFixProvider;

    public InspectionsTreeCellRenderer(boolean hasQuickFixProvider) {
        this.hasQuickFixProvider = hasQuickFixProvider;
    }

    public void customizeRenderer(@NotNull JTree tree, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        InspectionTreeNodeBase node;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        InspectionTreeNodeBase inspectionTreeNodeBase = node = value2 instanceof InspectionTreeNodeBase ? (InspectionTreeNodeBase)value2 : null;
        if (!(node instanceof InspectionRootNode)) {
            if (node instanceof InspectionGroupNode) {
                this.renderGroupNode((InspectionGroupNode)node);
            } else if (node instanceof InspectionLeafNode) {
                this.renderLeafNode((InspectionLeafNode)node);
            } else {
                SimpleColoredComponent simpleColoredComponent = this.getTextRenderer().append(PyTablesBundle.message("popup.inspections.finished.unknown.results", new Object[0]));
                Intrinsics.checkNotNull((Object)simpleColoredComponent);
            }
        }
        this.setupQuickFixCheckbox();
    }

    private final void renderGroupNode(InspectionGroupNode node) {
        String inspectionNameWithSpace = node.getGroupNodeInfo().getInspectionName() + "  ";
        this.getTextRenderer().append(inspectionNameWithSpace, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
        this.getTextRenderer().append(node.getGroupNodeInfo().getColumnCount(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    private final void renderLeafNode(InspectionLeafNode node) {
        String labelWithSpace = node.getLeafNodeInfo().getColumnName() + "  ";
        this.getTextRenderer().append(labelWithSpace, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
        this.getTextRenderer().append(node.getLeafNodeInfo().getValue(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    private final void setupQuickFixCheckbox() {
        this.getCheckbox().setVisible(this.hasQuickFixProvider);
    }
}

