/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterLanguage;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.LanguageWhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyAdapter;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J*\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0016J<\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/core/jupyter/formatter/JupyterWhiteSpaceFormattingStrategy;", "Lcom/intellij/psi/formatter/WhiteSpaceFormattingStrategyAdapter;", "<init>", "()V", "replaceDefaultStrategy", "", "check", "", "startElementLanguage", "Lcom/intellij/lang/Language;", "text", "", "start", "end", "adjustWhiteSpaceIfNecessary", "whiteSpaceText", "startOffset", "endOffset", "codeStyleSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "nodeAfter", "Lcom/intellij/lang/ASTNode;", "intellij.jupyter.core"})
public final class JupyterWhiteSpaceFormattingStrategy
extends WhiteSpaceFormattingStrategyAdapter {
    public boolean replaceDefaultStrategy() {
        return true;
    }

    public int check(@Nullable Language startElementLanguage, @NotNull CharSequence text, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (startElementLanguage != null) {
            WhiteSpaceFormattingStrategy whiteSpaceFormattingStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy((Language)startElementLanguage);
            Intrinsics.checkNotNullExpressionValue((Object)whiteSpaceFormattingStrategy, (String)"getStrategy(...)");
            WhiteSpaceFormattingStrategy languageStrategy = whiteSpaceFormattingStrategy;
            return languageStrategy.check(startElementLanguage, text, start2, end);
        }
        return super.check(null, text, start2, end);
    }

    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull CharSequence text, int startOffset, int endOffset, @Nullable CodeStyleSettings codeStyleSettings, @Nullable ASTNode nodeAfter) {
        Intrinsics.checkNotNullParameter((Object)whiteSpaceText, (String)"whiteSpaceText");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ASTNode aSTNode = nodeAfter;
        if (aSTNode == null || (aSTNode = aSTNode.getPsi()) == null || (aSTNode = aSTNode.getLanguage()) == null) {
            return whiteSpaceText;
        }
        ASTNode nodeLanguage = aSTNode;
        if (Intrinsics.areEqual((Object)nodeLanguage, (Object)JupyterLanguage.INSTANCE)) {
            return whiteSpaceText;
        }
        WhiteSpaceFormattingStrategy whiteSpaceFormattingStrategy = (WhiteSpaceFormattingStrategy)LanguageWhiteSpaceFormattingStrategy.INSTANCE.forLanguage((Language)nodeLanguage);
        if (whiteSpaceFormattingStrategy == null) {
            return whiteSpaceText;
        }
        WhiteSpaceFormattingStrategy languageStrategy = whiteSpaceFormattingStrategy;
        CharSequence charSequence = languageStrategy.adjustWhiteSpaceIfNecessary(whiteSpaceText, text, startOffset, endOffset, codeStyleSettings, nodeAfter);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"adjustWhiteSpaceIfNecessary(...)");
        return charSequence;
    }
}

