/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.internal.toolboxFeed;

import java.io.Closeable;
import java.io.InputStream;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/gateway/internal/toolboxFeed/ToolboxFeedSignatureManager;", "", "<init>", "()V", "trustedRoot", "Ljava/security/cert/X509Certificate;", "getTrustedRoot", "()Ljava/security/cert/X509Certificate;", "trustedRoot$delegate", "Lkotlin/Lazy;", "unpackAndVerify", "", "data", "verifyCertificate", "Ljava/security/cert/PKIXCertPathBuilderResult;", "cert", "trustedRootCerts", "", "intermediateCerts", "WhitelistedSignatureAlgorithmIdentifierFinder", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nToolboxFeedSignatureManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxFeedSignatureManager.kt\ncom/jetbrains/gateway/internal/toolboxFeed/ToolboxFeedSignatureManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1#2:109\n1563#3:110\n1634#3,3:111\n1563#3:114\n1634#3,3:115\n*S KotlinDebug\n*F\n+ 1 ToolboxFeedSignatureManager.kt\ncom/jetbrains/gateway/internal/toolboxFeed/ToolboxFeedSignatureManager\n*L\n36#1:110\n36#1:111,3\n71#1:114\n71#1:115,3\n*E\n"})
public final class ToolboxFeedSignatureManager {
    @NotNull
    public static final ToolboxFeedSignatureManager INSTANCE = new ToolboxFeedSignatureManager();
    @NotNull
    private static final Lazy trustedRoot$delegate = LazyKt.lazy(ToolboxFeedSignatureManager::trustedRoot_delegate$lambda$0);

    private ToolboxFeedSignatureManager() {
    }

    private final X509Certificate getTrustedRoot() {
        Lazy lazy = trustedRoot$delegate;
        return (X509Certificate)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] unpackAndVerify(@NotNull byte[] data) {
        void $this$mapTo$iv$iv;
        Object it;
        CMSSignedDataParser cMSSignedDataParser;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        BcDigestCalculatorProvider digestCalculatorProvider = new BcDigestCalculatorProvider();
        try {
            cMSSignedDataParser = new CMSSignedDataParser((DigestCalculatorProvider)digestCalculatorProvider, data);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unable to read DER-encoded CMS from input data", t);
        }
        CMSSignedDataParser parser = cMSSignedDataParser;
        Closeable t = parser.getSignedContent().getContentStream();
        Throwable throwable = null;
        try {
            it = (InputStream)t;
            boolean bl = false;
            it = ((InputStream)it).readAllBytes();
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)t, (Throwable)throwable);
        }
        Object result2 = it;
        CertStore certStore = new JcaCertStoreBuilder().addCertificates(parser.getCertificates()).build();
        Collection<? extends Certificate> collection = certStore.getCertificates(null);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getCertificates(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Certificate certificate = (Certificate)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            collection2.add((X509Certificate)it2);
        }
        Set intermediateCerts = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        WhitelistedSignatureAlgorithmIdentifierFinder algorithmIdentifierFinder = new WhitelistedSignatureAlgorithmIdentifierFinder();
        SignerInformationStore signerInformationStore = parser.getSignerInfos();
        Intrinsics.checkNotNullExpressionValue((Object)signerInformationStore, (String)"getSignerInfos(...)");
        List signers = CollectionsKt.toList((Iterable)((Iterable)signerInformationStore));
        if (signers.isEmpty()) {
            throw new IllegalStateException("CMS content is not signed (empty signers list)".toString());
        }
        object = ((Iterable)signers).iterator();
        int n = 0;
        while (object.hasNext()) {
            Certificate cert;
            JcaSignerInfoVerifierBuilder jcaSignerInfoVerifierBuilder;
            int index = n++;
            SignerInformation signer = (SignerInformation)object.next();
            Collection<? extends Certificate> collection3 = certStore.getCertificates(new JcaX509CertSelectorConverter().getCertSelector(signer.getSID()));
            Intrinsics.checkNotNullExpressionValue(collection3, (String)"getCertificates(...)");
            if ((Certificate)CollectionsKt.firstOrNull((Iterable)collection3) == null) {
                throw new IllegalStateException(("Can't find signer certificate in embedded certificates for signature #" + index).toString());
            }
            JcaSignerInfoVerifierBuilder it3 = jcaSignerInfoVerifierBuilder = new JcaSignerInfoVerifierBuilder((DigestCalculatorProvider)digestCalculatorProvider);
            boolean bl = false;
            it3.setSignatureAlgorithmFinder((SignatureAlgorithmIdentifierFinder)algorithmIdentifierFinder);
            SignerInformationVerifier verifier = jcaSignerInfoVerifierBuilder.build((X509Certificate)cert);
            if (!signer.verify(verifier)) {
                throw new IllegalStateException(("Can't verify signature hash correctness for signature #" + index).toString());
            }
            this.verifyCertificate((X509Certificate)cert, SetsKt.setOf((Object)this.getTrustedRoot()), intermediateCerts);
        }
        Intrinsics.checkNotNull((Object)result2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final PKIXCertPathBuilderResult verifyCertificate(X509Certificate cert, Set<? extends X509Certificate> trustedRootCerts, Set<? extends X509Certificate> intermediateCerts) {
        void $this$mapTo$iv$iv;
        X509CertSelector x509CertSelector;
        X509CertSelector it = x509CertSelector = new X509CertSelector();
        boolean bl = false;
        it.setCertificate(cert);
        X509CertSelector targetCertificateSelector = x509CertSelector;
        Iterable $this$map$iv = trustedRootCerts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            X509Certificate x509Certificate = (X509Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new TrustAnchor((X509Certificate)it2, null));
        }
        Set trustAnchors = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)targetCertificateSelector);
        pkixParams.setRevocationEnabled(false);
        CertStore intermediateCertStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters((Collection)intermediateCerts));
        pkixParams.addCertStore(intermediateCertStore);
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
        CertPathBuilderResult certPathBuilderResult = builder.build(pkixParams);
        Intrinsics.checkNotNull((Object)certPathBuilderResult, (String)"null cannot be cast to non-null type java.security.cert.PKIXCertPathBuilderResult");
        return (PKIXCertPathBuilderResult)certPathBuilderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final X509Certificate trustedRoot_delegate$lambda$0() {
        X509Certificate x509Certificate;
        InputStream inputStream = ToolboxFeedSignatureManager.class.getClassLoader().getResourceAsStream("toolbox-feed-ca.crt");
        if (inputStream == null) {
            throw new IllegalStateException("Unable to load toolbox feed CA from resources".toString());
        }
        InputStream trustedRootStream = inputStream;
        Closeable closeable = trustedRootStream;
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Certificate certificate = factory.generateCertificate(input);
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            x509Certificate = (X509Certificate)certificate;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return x509Certificate;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/gateway/internal/toolboxFeed/ToolboxFeedSignatureManager$WhitelistedSignatureAlgorithmIdentifierFinder;", "Lorg/bouncycastle/operator/SignatureAlgorithmIdentifierFinder;", "<init>", "()V", "whitelistedAlgNamePrefixes", "", "", "default", "Lorg/bouncycastle/operator/DefaultSignatureAlgorithmIdentifierFinder;", "find", "Lorg/bouncycastle/asn1/x509/AlgorithmIdentifier;", "algName", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nToolboxFeedSignatureManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxFeedSignatureManager.kt\ncom/jetbrains/gateway/internal/toolboxFeed/ToolboxFeedSignatureManager$WhitelistedSignatureAlgorithmIdentifierFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n2746#2,3:109\n*S KotlinDebug\n*F\n+ 1 ToolboxFeedSignatureManager.kt\ncom/jetbrains/gateway/internal/toolboxFeed/ToolboxFeedSignatureManager$WhitelistedSignatureAlgorithmIdentifierFinder\n*L\n100#1:109,3\n*E\n"})
    private static final class WhitelistedSignatureAlgorithmIdentifierFinder
    implements SignatureAlgorithmIdentifierFinder {
        @NotNull
        private final List<String> whitelistedAlgNamePrefixes;
        @NotNull
        private final DefaultSignatureAlgorithmIdentifierFinder default;

        public WhitelistedSignatureAlgorithmIdentifierFinder() {
            Object[] objectArray = new String[]{"SHA256", "SHA384", "SHA512", "SHA3-256", "SHA3-384", "SHA3-512"};
            this.whitelistedAlgNamePrefixes = CollectionsKt.listOf((Object[])objectArray);
            this.default = new DefaultSignatureAlgorithmIdentifierFinder();
        }

        @NotNull
        public AlgorithmIdentifier find(@NotNull String algName) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)algName, (String)"algName");
                Iterable $this$none$iv = this.whitelistedAlgNamePrefixes;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String prefix = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)algName, (String)prefix, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (bl) {
                throw new IllegalStateException(("Signature algorithm " + algName + " is not whitelisted").toString());
            }
            AlgorithmIdentifier algorithmIdentifier = this.default.find(algName);
            Intrinsics.checkNotNullExpressionValue((Object)algorithmIdentifier, (String)"find(...)");
            return algorithmIdentifier;
        }
    }
}

