/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.ui.chat.view;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.aiplayground.ui.AIPlaygroundIcons;
import com.intellij.aiplayground.ui.AIPlaygroundUIBundle;
import com.intellij.aiplayground.ui.chat.view.RoundedBorder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\"\u001a\u00020\u001fH\u0002J\u0006\u0010#\u001a\u00020\tJ\u000e\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\tJ\b\u0010(\u001a\u00020\tH\u0016J\u0006\u0010)\u001a\u00020&J\b\u0010*\u001a\u00020\tH\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/aiplayground/ui/chat/view/MessageInput;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "onUpdateMessage", "Lkotlin/Function1;", "", "onSendMessage", "onStop", "Lkotlin/Function0;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getOnUpdateMessage", "()Lkotlin/jvm/functions/Function1;", "getOnSendMessage", "getOnStop", "()Lkotlin/jvm/functions/Function0;", "isStreaming", "", "()Z", "setStreaming", "(Z)V", "value", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "textArea", "Lcom/intellij/ui/EditorTextField;", "roundedBorder", "Lcom/intellij/aiplayground/ui/chat/view/RoundedBorder;", "createTextArea", "sendMessage", "replaceBottomToolbar", "toolbar", "Ljavax/swing/JComponent;", "addDefaultBottomToolbar", "dispose", "getPreferredFocusedComponent", "removeNotify", "intellij.aiplayground.ui"})
@StabilityInferred(parameters=0)
public final class MessageInput
extends JPanel
implements Disposable {
    @NotNull
    private final Function1<String, Unit> onUpdateMessage;
    @NotNull
    private final Function1<String, Unit> onSendMessage;
    @NotNull
    private final Function0<Unit> onStop;
    private boolean isStreaming;
    @NotNull
    private final EditorTextField textArea;
    @NotNull
    private final RoundedBorder roundedBorder;
    public static final int $stable = 8;

    public MessageInput(@NotNull Project project, @NotNull String text, @NotNull Function1<? super String, Unit> onUpdateMessage, @NotNull Function1<? super String, Unit> onSendMessage, @NotNull Function0<Unit> onStop) {
        JPanel $this$roundedBorder_u24lambda_u240;
        RoundedBorder roundedBorder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(onUpdateMessage, (String)"onUpdateMessage");
        Intrinsics.checkNotNullParameter(onSendMessage, (String)"onSendMessage");
        Intrinsics.checkNotNullParameter(onStop, (String)"onStop");
        super(new BorderLayout());
        this.onUpdateMessage = onUpdateMessage;
        this.onSendMessage = onSendMessage;
        this.onStop = onStop;
        RoundedBorder roundedBorder2 = roundedBorder = new RoundedBorder();
        MessageInput messageInput = this;
        boolean bl = false;
        ((RoundedBorder)((Object)$this$roundedBorder_u24lambda_u240)).setArcDiameterSupplier((Function1<? super Component, Integer>)((Function1)MessageInput::roundedBorder$lambda$0$0));
        JBInsets jBInsets = JBUI.insets((int)12, (int)8, (int)6, (int)8);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        ((RoundedBorder)((Object)$this$roundedBorder_u24lambda_u240)).setInsets((Insets)jBInsets);
        messageInput.roundedBorder = roundedBorder;
        this.setOpaque(false);
        this.textArea = this.createTextArea();
        this.textArea.setText(text);
        this.textArea.setPlaceholder((CharSequence)AIPlaygroundUIBundle.message("input.placeholder.text", new Object[0]));
        this.setBorder(this.roundedBorder);
        JPanel $this$_init__u24lambda_u240 = $this$roundedBorder_u24lambda_u240 = new JPanel(new BorderLayout());
        boolean bl2 = false;
        $this$_init__u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        $this$_init__u24lambda_u240.setOpaque(false);
        $this$_init__u24lambda_u240.add((Component)this.textArea, "Center");
        JPanel mainPanel = $this$roundedBorder_u24lambda_u240;
        this.add((Component)mainPanel, "Center");
        DocumentListener documentListener2 = new DocumentListener(this){
            final /* synthetic */ MessageInput this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (MessageInput.access$getTextArea$p((MessageInput)this.this$0).getPreferredSize().height != MessageInput.access$getTextArea$p(this.this$0).getHeight()) {
                    this.this$0.revalidate();
                }
                Function1<String, Unit> function1 = this.this$0.getOnUpdateMessage();
                String string = MessageInput.access$getTextArea$p(this.this$0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                function1.invoke((Object)string);
            }
        };
        this.textArea.getDocument().addDocumentListener(documentListener2, (Disposable)this);
        Shortcut[] shortcutArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(10, 64), null), new KeyboardShortcut(KeyStroke.getKeyStroke(10, 128), null)};
        DumbAwareAction.create(arg_0 -> MessageInput._init_$lambda$2(arg_0 -> MessageInput._init_$lambda$1(this, project, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)this.textArea);
        DumbAwareAction.create(arg_0 -> MessageInput._init_$lambda$4(arg_0 -> MessageInput._init_$lambda$3(this, arg_0), arg_0)).registerCustomShortcutSet(10, 0, (JComponent)this.textArea);
    }

    public /* synthetic */ MessageInput(Project project, String string, Function1 function1, Function1 function12, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(project, string, (Function1<? super String, Unit>)function1, (Function1<? super String, Unit>)function12, (Function0<Unit>)function0);
    }

    @NotNull
    public final Function1<String, Unit> getOnUpdateMessage() {
        return this.onUpdateMessage;
    }

    @NotNull
    public final Function1<String, Unit> getOnSendMessage() {
        return this.onSendMessage;
    }

    @NotNull
    public final Function0<Unit> getOnStop() {
        return this.onStop;
    }

    public final boolean isStreaming() {
        return this.isStreaming;
    }

    public final void setStreaming(boolean bl) {
        this.isStreaming = bl;
    }

    @NotNull
    public final String getText() {
        String string = this.textArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public final void setText(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.textArea.setText(value);
    }

    private final EditorTextField createTextArea() {
        EditorTextField editorTextField;
        EditorTextField $this$createTextArea_u24lambda_u240 = editorTextField = new EditorTextField();
        boolean bl = false;
        $this$createTextArea_u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        $this$createTextArea_u24lambda_u240.setOneLineMode(false);
        $this$createTextArea_u24lambda_u240.setOpaque(false);
        $this$createTextArea_u24lambda_u240.setFontInheritedFromLAF(true);
        $this$createTextArea_u24lambda_u240.ensureWillComputePreferredSize();
        $this$createTextArea_u24lambda_u240.setDisposedWith((Disposable)this);
        $this$createTextArea_u24lambda_u240.addSettingsProvider(arg_0 -> MessageInput.createTextArea$lambda$0$0($this$createTextArea_u24lambda_u240, this, arg_0));
        return editorTextField;
    }

    public final void sendMessage() {
        String string = this.textArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String message = ((Object)StringsKt.trim((CharSequence)string)).toString();
        this.onSendMessage.invoke((Object)message);
    }

    public final void replaceBottomToolbar(@NotNull JComponent toolbar) {
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        LayoutManager layoutManager = this.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.BorderLayout");
        Component component = ((BorderLayout)layoutManager).getLayoutComponent("South");
        if (component != null) {
            Component old = component;
            boolean bl = false;
            this.remove(old);
        }
        this.add((Component)toolbar, "South");
    }

    /*
     * WARNING - void declaration
     */
    public final void addDefaultBottomToolbar() {
        void $this$addDefaultBottomToolbar_u24lambda_u241;
        JComponent jComponent;
        ActionManager service = ActionManager.getInstance();
        AnAction[] anActionArray = new AnAction[2];
        Icon icon = AIPlaygroundIcons.Send;
        anActionArray[0] = new AnAction(this, icon){
            final /* synthetic */ MessageInput this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.sendMessage();
            }

            /*
             * WARNING - void declaration
             */
            public void update(AnActionEvent e) {
                void $this$update_u24lambda_u240;
                HelpTooltip helpTooltip;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabledAndVisible(!this.this$0.isStreaming());
                HelpTooltip helpTooltip2 = helpTooltip = new HelpTooltip();
                Key key = ActionButton.CUSTOM_HELP_TOOLTIP;
                Presentation presentation = e.getPresentation();
                boolean bl = false;
                $this$update_u24lambda_u240.setTitle(AIPlaygroundUIBundle.message("tooltip.title.send", new Object[0]));
                $this$update_u24lambda_u240.setShortcut("Enter");
                Unit unit = Unit.INSTANCE;
                presentation.putClientProperty(key, (Object)helpTooltip);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        };
        icon = AllIcons.Run.Stop;
        anActionArray[1] = new AnAction(this, icon){
            final /* synthetic */ MessageInput this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getOnStop().invoke();
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabledAndVisible(this.this$0.isStreaming());
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        };
        ActionToolbar actionToolbar = service.createActionToolbar("MessageInputToolbar", (ActionGroup)new DefaultActionGroup(anActionArray), true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar buttonPanel2 = actionToolbar;
        JComponent $this$addDefaultBottomToolbar_u24lambda_u240 = jComponent = buttonPanel2.getComponent();
        boolean bl = false;
        $this$addDefaultBottomToolbar_u24lambda_u240.setOpaque(false);
        $this$addDefaultBottomToolbar_u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        buttonPanel2.setTargetComponent((JComponent)this);
        $this$addDefaultBottomToolbar_u24lambda_u240 = jComponent = new JPanel(new BorderLayout());
        MessageInput messageInput = this;
        boolean bl2 = false;
        $this$addDefaultBottomToolbar_u24lambda_u241.setOpaque(false);
        $this$addDefaultBottomToolbar_u24lambda_u241.setBorder((Border)JBUI.Borders.empty());
        $this$addDefaultBottomToolbar_u24lambda_u241.add((Component)buttonPanel2.getComponent(), "East");
        messageInput.replaceBottomToolbar(jComponent);
    }

    public void dispose() {
    }

    @NotNull
    public final JComponent getPreferredFocusedComponent() {
        return (JComponent)this.textArea;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Disposer.dispose((Disposable)this);
    }

    private static final int roundedBorder$lambda$0$0(Component it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return 12;
    }

    private static final Unit _init_$lambda$1(MessageInput this$0, Project $project, AnActionEvent it) {
        block0: {
            Editor editor = this$0.textArea.getEditor();
            if (editor == null) break block0;
            Editor it2 = editor;
            boolean bl = false;
            CommandProcessor.getInstance().executeCommand($project, () -> MessageInput.lambda$1$0$0(it2, this$0), null, null);
        }
        return Unit.INSTANCE;
    }

    private static final void lambda$1$0$0(Editor $it, MessageInput this$0) {
        ApplicationManager.getApplication().runWriteAction(() -> MessageInput.lambda$1$0$0$0($it, this$0));
    }

    private static final void lambda$1$0$0$0(Editor $it, MessageInput this$0) {
        block0: {
            String eol = "\n";
            int caretOffset = $it.getCaretModel().getOffset();
            this$0.textArea.getDocument().insertString(caretOffset, (CharSequence)eol);
            $it.getCaretModel().moveToOffset(caretOffset + eol.length());
            Editor editor = this$0.textArea.getEditor();
            if (editor == null || (editor = editor.getScrollingModel()) == null) break block0;
            editor.scrollToCaret(ScrollType.RELATIVE);
        }
    }

    private static final void _init_$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$3(MessageInput this$0, AnActionEvent it) {
        this$0.sendMessage();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void createTextArea$lambda$0$0(EditorTextField $this_apply, MessageInput this$0, EditorEx it) {
        it.getColorsScheme().setLineSpacing(1.0f);
        it.getSettings().setUseSoftWraps(true);
        it.getSettings().setPaintSoftWraps(false);
        it.setEmbeddedIntoDialogWrapper(true);
        $this_apply.setBorder((Border)JBUI.Borders.empty());
        it.setVerticalScrollbarVisible(true);
        it.getScrollPane().getVerticalScrollBar().setOpaque(false);
        it.addFocusListener(new FocusChangeListener(this$0){
            final /* synthetic */ MessageInput this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusGained(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                MessageInput.access$getRoundedBorder$p(this.this$0).setThickness(JBUIScale.scale((int)2));
                RoundedBorder roundedBorder = MessageInput.access$getRoundedBorder$p(this.this$0);
                Color color = JBUI.CurrentTheme.Focus.focusColor();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"focusColor(...)");
                roundedBorder.setColor(color);
                MessageInput.access$getTextArea$p(this.this$0).repaint();
            }

            public void focusLost(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                MessageInput.access$getRoundedBorder$p(this.this$0).setThickness(JBUIScale.scale((int)1));
                RoundedBorder roundedBorder = MessageInput.access$getRoundedBorder$p(this.this$0);
                Color color = DarculaUIUtil.getOutlineColor((boolean)editor.getContentComponent().isEnabled(), (boolean)false);
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getOutlineColor(...)");
                roundedBorder.setColor(color);
                MessageInput.access$getTextArea$p(this.this$0).repaint();
            }
        });
    }

    public static final /* synthetic */ RoundedBorder access$getRoundedBorder$p(MessageInput $this) {
        return $this.roundedBorder;
    }

    public static final /* synthetic */ EditorTextField access$getTextArea$p(MessageInput $this) {
        return $this.textArea;
    }
}

