/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.bundle;

import com.jetbrains.mlapi.bundle.JvmBundleLoader;
import com.jetbrains.mlapi.bundle.JvmBundleLoadingException;
import com.jetbrains.mlapi.model.pipeline.ThisThreadExecutorService;
import com.jetbrains.mlapi.model.pipeline.VFSNode;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH$J%\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\rJ\u001e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007J\u0013\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/mlapi/bundle/JvmBundleLoader;", "T", "", "()V", "doLoad", "Ljava/util/concurrent/CompletableFuture;", "executor", "Ljava/util/concurrent/ExecutorService;", "dumpRoot", "Lcom/jetbrains/mlapi/model/pipeline/VFSNode$Directory;", "metadata", "Lkotlinx/serialization/json/JsonObject;", "load", "load$mlapi_core", "dumpContent", "Ljava/io/InputStream;", "dumpPath", "Ljava/nio/file/Path;", "loadBlocking", "(Ljava/io/InputStream;)Ljava/lang/Object;", "path", "(Ljava/nio/file/Path;)Ljava/lang/Object;", "loadBlockingOrNull", "inputStream", "mlapi-core"})
@SourceDebugExtension(value={"SMAP\nJvmBundleLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmBundleLoader.kt\ncom/jetbrains/mlapi/bundle/JvmBundleLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public abstract class JvmBundleLoader<T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CompletableFuture<? extends T> load(@NotNull InputStream dumpContent, @NotNull ExecutorService executor2) {
        Intrinsics.checkNotNullParameter((Object)dumpContent, (String)"dumpContent");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        try {
            Closeable closeable = dumpContent;
            int n = 8192;
            closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
            Throwable throwable = null;
            try {
                ZipInputStream zip = (ZipInputStream)closeable;
                boolean bl = false;
                VFSNode.Directory root = VFSNode.Companion.fromZipInputStream(zip);
                CompletableFuture<T> completableFuture = this.load$mlapi_core(root, executor2);
                return completableFuture;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable ex) {
            CompletableFuture completableFuture = CompletableFuture.failedFuture(new JvmBundleLoadingException("Could not load JVM bundle", ex));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
            return completableFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CompletableFuture<? extends T> load(@NotNull Path dumpPath, @NotNull ExecutorService executor2) {
        CompletableFuture<T> completableFuture;
        Intrinsics.checkNotNullParameter((Object)dumpPath, (String)"dumpPath");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(dumpPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this, *options)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            completableFuture = this.load(it, executor2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return completableFuture;
    }

    public final T loadBlocking(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.load(path, (ExecutorService)new ThisThreadExecutorService()).join();
    }

    public final T loadBlocking(@NotNull InputStream dumpContent) {
        Intrinsics.checkNotNullParameter((Object)dumpContent, (String)"dumpContent");
        return this.load(dumpContent, (ExecutorService)new ThisThreadExecutorService()).join();
    }

    @Nullable
    public final T loadBlockingOrNull(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return ((CompletableFuture)this.load(inputStream, (ExecutorService)new ThisThreadExecutorService()).exceptionally((Function)loadBlockingOrNull.1.INSTANCE)).join();
    }

    @Nullable
    public final T loadBlockingOrNull(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        return ((CompletableFuture)this.load(path, (ExecutorService)new ThisThreadExecutorService()).exceptionally((Function)loadBlockingOrNull.2.INSTANCE)).join();
    }

    @NotNull
    public final CompletableFuture<? extends T> load$mlapi_core(@NotNull VFSNode.Directory dumpRoot, @NotNull ExecutorService executor2) {
        Intrinsics.checkNotNullParameter((Object)dumpRoot, (String)"dumpRoot");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        try {
            JsonObject metadata = JsonElementKt.getJsonObject((JsonElement)dumpRoot.getFile("metadata.json").getAsJson());
            JsonObject userData = JsonElementKt.getJsonObject((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)metadata), (Object)"data")));
            CompletionStage completionStage = this.doLoad(executor2, dumpRoot, userData).exceptionally((Function)load.3.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"exceptionally(...)");
            return completionStage;
        }
        catch (Throwable ex) {
            CompletableFuture completableFuture = CompletableFuture.failedFuture(new JvmBundleLoadingException("Could not load JVM bundle", ex));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
            return completableFuture;
        }
    }

    @NotNull
    protected abstract CompletableFuture<? extends T> doLoad(@NotNull ExecutorService var1, @NotNull VFSNode.Directory var2, @NotNull JsonObject var3);
}

