/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeLink;
import com.jetbrains.ide.model.uiautomation.BeUserAction;
import com.jetbrains.ide.model.uiautomation.ScreenPositionModel_GeneratedKt;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ui.ComponentActionWrapper;
import com.jetbrains.rd.ui.MaximumAndPreferredSizeLimitedComponentWrapperKt;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.ui.bindable.views.LinkViewControl;
import com.jetbrains.rd.ui.bindable.views.listControl.IActionOwner;
import com.jetbrains.rd.ui.bindable.views.listControl.IRendererOwner;
import com.jetbrains.rd.ui.bindable.views.listControl.renderers.BeLinkRenderer;
import com.jetbrains.rd.ui.bindable.views.listControl.renderers.RdMultiRenderer;
import com.jetbrains.rd.ui.bindable.views.utils.BeComponentsKt;
import com.jetbrains.rd.ui.bindable.views.utils.BeTextSettingsUtilKt;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rdclient.ui.bindableUi.views.utils.BeUtilKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u00032\b\u0012\u0004\u0012\u00020\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\r\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/LinkViewControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeLink;", "Lcom/jetbrains/rd/ui/bindable/views/listControl/IRendererOwner;", "Lcom/jetbrains/rd/ui/bindable/views/listControl/IActionOwner;", "<init>", "()V", "getRenderer", "Lcom/jetbrains/rd/ui/bindable/views/listControl/renderers/RdMultiRenderer;", "Ljavax/swing/JPanel;", "viewModel", "bind", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLinkCss", "", "Lorg/jetbrains/annotations/NonNls;", "getAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nLinkViewControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkViewControl.kt\ncom/jetbrains/rd/ui/bindable/views/LinkViewControl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class LinkViewControl
implements ViewBinder<BeLink>,
IRendererOwner<BeLink>,
IActionOwner<BeLink> {
    @NotNull
    public RdMultiRenderer<JPanel, BeLink> getRenderer(@NotNull BeLink viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        return new BeLinkRenderer();
    }

    @Override
    @NotNull
    public JComponent bind(@NotNull BeLink viewModel, @NotNull Lifetime lifetime) {
        ActionLink actionLink;
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        String prefixText = BeTextSettingsUtilKt.getSimpleText(viewModel.getPrefix());
        String postfixText = BeTextSettingsUtilKt.getSimpleText(viewModel.getPostfix());
        String linkText = viewModel.getContent();
        BeUserAction action3 = viewModel.getAction();
        if (viewModel.getWrapText()) {
            JBLabel jBLabel;
            JBLabel $this$bind_u24lambda_u240 = jBLabel = new JBLabel(action3){
                final /* synthetic */ BeUserAction $action;
                {
                    this.$action = $action;
                }

                protected HyperlinkListener createHyperlinkListener() {
                    HyperlinkListener hyperlinkListener;
                    if (this.$action instanceof BeUserAction) {
                        hyperlinkListener = arg_0 -> bind.1.createHyperlinkListener$lambda$0(this.$action, arg_0);
                    } else {
                        BrowserHyperlinkListener browserHyperlinkListener = BrowserHyperlinkListener.INSTANCE;
                        Intrinsics.checkNotNullExpressionValue((Object)browserHyperlinkListener, (String)"INSTANCE");
                        hyperlinkListener = (HyperlinkListener)browserHyperlinkListener;
                    }
                    return hyperlinkListener;
                }

                private static final void createHyperlinkListener$lambda$0(BeUserAction $action, HyperlinkEvent it) {
                    if (Intrinsics.areEqual((Object)it.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                        $action.getClick().fire((Object)Unit.INSTANCE);
                    }
                }
            };
            boolean bl = false;
            $this$bind_u24lambda_u240.setAllowAutoWrapping(true);
            $this$bind_u24lambda_u240.setCopyable(true);
            HtmlBuilder body = new HtmlBuilder().append(prefixText + " ").appendLink("#sometext", linkText).append(" " + postfixText);
            String linkCss = this.getLinkCss();
            $this$bind_u24lambda_u240.setText(new HtmlBuilder().append(HtmlChunk.raw((String)linkCss)).append((HtmlChunk)body.wrapWith("body")).wrapWith("html").toString());
            BeComponentsKt.bindDefaultProperties((BeControl)viewModel, lifetime, (JComponent)$this$bind_u24lambda_u240);
            return MaximumAndPreferredSizeLimitedComponentWrapperKt.fillWidthButDoNotOverflow((JComponent)jBLabel, false);
        }
        if (((CharSequence)prefixText).length() > 0 || ((CharSequence)postfixText).length() > 0) {
            HyperlinkLabel hyperlinkLabel;
            HyperlinkLabel $this$bind_u24lambda_u241 = hyperlinkLabel = new HyperlinkLabel();
            boolean bl = false;
            String linkHtml = prefixText + " <hyperlink>" + linkText + "</hyperlink> " + postfixText;
            $this$bind_u24lambda_u241.setTextWithHyperlink(linkHtml);
            if (viewModel.isExternal()) {
                $this$bind_u24lambda_u241.setIcon(AllIcons.Ide.External_link_arrow);
                $this$bind_u24lambda_u241.setIconAtRight(true);
            }
            BeComponentsKt.bindDefaultProperties((BeControl)viewModel, lifetime, (JComponent)$this$bind_u24lambda_u241);
            viewModel.getIcon().advise(lifetime, arg_0 -> LinkViewControl.bind$lambda$1$0($this$bind_u24lambda_u241, arg_0));
            $this$bind_u24lambda_u241.addHyperlinkListener(arg_0 -> LinkViewControl.bind$lambda$1$1(viewModel, arg_0));
            return (JComponent)hyperlinkLabel;
        }
        IProperty clientBounds = ScreenPositionModel_GeneratedKt.getScreenPositionModel((BeControl)((BeControl)viewModel)).getClientBounds();
        ActionLink $this$bind_u24lambda_u243 = actionLink = new ActionLink(linkText, arg_0 -> LinkViewControl.bind$lambda$2(viewModel, clientBounds, arg_0));
        boolean bl = false;
        if (viewModel.isExternal()) {
            $this$bind_u24lambda_u243.setExternalLinkIcon();
        }
        BeComponentsKt.bindDefaultProperties((BeControl)viewModel, lifetime, (JComponent)$this$bind_u24lambda_u243);
        return (JComponent)actionLink;
    }

    private final String getLinkCss() {
        return StringsKt.trimIndent((String)("\n      <head><style type=\"text/css\">\n      a, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + ";}\n      a:visited {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.VISITED) + ";}\n      a:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.HOVERED) + ";}\n      a:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.PRESSED) + ";}\n      </style>\n      </head>\n     "));
    }

    @Override
    @NotNull
    public AnAction getAction(@NotNull Lifetime lifetime, @NotNull BeLink viewModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        return (AnAction)new ComponentActionWrapper((Function0<? extends JComponent>)((Function0)() -> LinkViewControl.getAction$lambda$0(this, viewModel, lifetime)));
    }

    private static final Unit bind$lambda$1$0(HyperlinkLabel $this_apply, IconModel it) {
        IconModel iconModel = it;
        $this_apply.setIcon(iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null);
        return Unit.INSTANCE;
    }

    private static final void bind$lambda$1$1(BeLink $viewModel, HyperlinkEvent it) {
        $viewModel.getAction().getClick().fire((Object)Unit.INSTANCE);
    }

    private static final Unit bind$lambda$2(BeLink $viewModel, IProperty $clientBounds, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (((Boolean)$viewModel.getEnabled().getValue()).booleanValue()) {
            Rectangle bounds;
            Rectangle rectangle;
            Object object = it.getSource();
            Component component = object instanceof Component ? (Component)object : null;
            if (component != null) {
                Component $this$bind_u24lambda_u242_u240 = component;
                boolean bl = false;
                rectangle = new Rectangle($this$bind_u24lambda_u242_u240.getLocationOnScreen(), $this$bind_u24lambda_u242_u240.getSize());
            } else {
                rectangle = null;
            }
            Rectangle rectangle2 = bounds = rectangle;
            $clientBounds.set(rectangle2 != null ? BeUtilKt.toModel(rectangle2) : null);
            $viewModel.getAction().getClick().fire((Object)Unit.INSTANCE);
        }
        return Unit.INSTANCE;
    }

    private static final JComponent getAction$lambda$0(LinkViewControl this$0, BeLink $viewModel, Lifetime $lifetime) {
        return this$0.bind($viewModel, $lifetime);
    }
}

