/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.PuppetFileType;
import com.intellij.lang.puppet.run.PuppetRunnerParameters;
import com.intellij.lang.puppet.run.PuppetRunningState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class PuppetRunConfiguration
extends LocatableConfigurationBase {
    private final PuppetRunnerParameters myRunnerParameters = new PuppetRunnerParameters();

    PuppetRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public PuppetRunnerParameters getRunnerParameters() {
        return this.myRunnerParameters;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        if (null == null) {
            PuppetRunConfiguration.$$$reportNull$$$0(0);
        }
        return null;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            PuppetRunConfiguration.$$$reportNull$$$0(1);
        }
        if (env == null) {
            PuppetRunConfiguration.$$$reportNull$$$0(2);
        }
        Project project = env.getProject();
        @NlsSafe String path = this.myRunnerParameters.getFilePath();
        if (path == null || VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path)) == null) {
            throw new ExecutionException(PuppetBundle.message("dialog.message.can.t.find.file", path));
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
        assert (virtualFile != null);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            throw new ExecutionException(PuppetBundle.message("dialog.message.can.t.find.module.for.file", new Object[0]));
        }
        return new PuppetRunningState(env, this.myRunnerParameters);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        String path = this.myRunnerParameters.getFilePath();
        if (path == null || VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path)) == null) {
            throw new RuntimeConfigurationException(PuppetBundle.message("run.configuration.exception.no.file", path));
        }
        if (!FileUtilRt.extensionEquals((String)path, (String)PuppetFileType.INSTANCE.getDefaultExtension())) {
            throw new RuntimeConfigurationException(PuppetBundle.message("run.configuration.exception.non.puppet.file", new Object[0]));
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            PuppetRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            PuppetRunConfiguration.$$$reportNull$$$0(4);
        }
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/run/PuppetRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/run/PuppetRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

