/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.dap.run.providers;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.python.dap.PythonDapBundle;
import com.intellij.python.dap.run.DebugpyRunConfig;
import com.intellij.util.PathUtil;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bg\u0018\u0000 \r*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003:\u0001\rJ\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0002H&J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\bH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/intellij/python/dap/run/providers/DebugpyConfigProvider;", "C", "Lcom/jetbrains/python/run/AbstractPythonRunConfiguration;", "", "supports", "", "configuration", "addCustomArgs", "Lcom/intellij/python/dap/run/DebugpyRunConfig;", "commonConfig", "(Lcom/jetbrains/python/run/AbstractPythonRunConfiguration;Lcom/intellij/python/dap/run/DebugpyRunConfig;)Lcom/intellij/python/dap/run/DebugpyRunConfig;", "createConfig", "(Lcom/jetbrains/python/run/AbstractPythonRunConfiguration;)Lcom/intellij/python/dap/run/DebugpyRunConfig;", "Companion", "intellij.python.dap"})
@ApiStatus.Internal
public interface DebugpyConfigProvider<C extends AbstractPythonRunConfiguration<?>> {
    @NotNull
    public static final Companion Companion = com.intellij.python.dap.run.providers.DebugpyConfigProvider$Companion.$$INSTANCE;

    public boolean supports(@NotNull AbstractPythonRunConfiguration<?> var1);

    @NotNull
    public DebugpyRunConfig addCustomArgs(@NotNull C var1, @NotNull DebugpyRunConfig var2);

    @NotNull
    default public DebugpyRunConfig createConfig(@NotNull C configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Sdk sdk = configuration.getSdk();
        if (sdk == null) {
            throw new IllegalArgumentException("Python interpreter is not specified");
        }
        Sdk sdk2 = sdk;
        if (PythonSdkUtil.isRemote((Sdk)sdk2)) {
            throw new ExecutionException(PythonDapBundle.message("pythonDap.run.configuration.remoteSdk.notSupported.error", new Object[0]));
        }
        String string = PathUtil.toSystemDependentName((String)sdk2.getHomePath());
        if (string == null) {
            throw new IllegalArgumentException("Python interpreter path is not specified");
        }
        String pythonPath = string;
        List list = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)configuration.getInterpreterOptions());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expandMacrosAndParseParameters(...)");
        List pythonOptions = list;
        PythonCommandLineState.buildPythonPath(configuration, (boolean)true, (boolean)true);
        Map map = configuration.getEnvs();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvs(...)");
        DebugpyRunConfig commonDebugpyRunConfig = new DebugpyRunConfig(null, pythonPath, pythonOptions, null, null, map, null, false, false, false, false, null, false, false, false, false, false, null, null, false, 1048537, null);
        String cwd = configuration.getWorkingDirectory();
        Intrinsics.checkNotNull((Object)cwd);
        if (!StringsKt.isBlank((CharSequence)cwd)) {
            commonDebugpyRunConfig.setCwd(cwd);
        }
        return this.addCustomArgs(configuration, commonDebugpyRunConfig);
    }

    @NotNull
    public static ExtensionPointName<DebugpyConfigProvider<?>> getEP_NAME() {
        return Companion.getEP_NAME();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/python/dap/run/providers/DebugpyConfigProvider$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/python/dap/run/providers/DebugpyConfigProvider;", "getEP_NAME$annotations", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.python.dap"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final ExtensionPointName<DebugpyConfigProvider<?>> EP_NAME;

        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<DebugpyConfigProvider<?>> getEP_NAME() {
            return EP_NAME;
        }

        @JvmStatic
        public static /* synthetic */ void getEP_NAME$annotations() {
        }

        static {
            $$INSTANCE = new Companion();
            EP_NAME = ExtensionPointName.Companion.create("com.intellij.python.dap.run.debugpyConfigProvider");
        }
    }
}

