/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.settings;

import com.intellij.application.options.GeneralCodeStyleOptionsProvider;
import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.Utils;
import org.editorconfig.settings.EditorConfigExportProviderEP;
import org.editorconfig.settings.EditorConfigListener;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/editorconfig/settings/EditorConfigConfigurable;", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsProvider;", "Lcom/intellij/application/options/GeneralCodeStyleOptionsProvider;", "<init>", "()V", "myCbEnabled", "Ljavax/swing/JCheckBox;", "createComponent", "Ljavax/swing/JComponent;", "isModified", "", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "apply", "", "reset", "disposeUIResources", "hasSettingsPage", "createCustomSettings", "Lcom/intellij/psi/codeStyle/CustomCodeStyleSettings;", "intellij.editorconfig.backend"})
public final class EditorConfigConfigurable
extends CodeStyleSettingsProvider
implements GeneralCodeStyleOptionsProvider {
    private JCheckBox myCbEnabled;

    @NotNull
    public JComponent createComponent() {
        return (JComponent)BuilderKt.panel(arg_0 -> EditorConfigConfigurable.createComponent$lambda$0(this, arg_0));
    }

    public boolean isModified(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        JCheckBox jCheckBox = this.myCbEnabled;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myCbEnabled");
            jCheckBox = null;
        }
        return jCheckBox.isSelected() != ((EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class)).ENABLED;
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        boolean newValue;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        JCheckBox jCheckBox = this.myCbEnabled;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myCbEnabled");
            jCheckBox = null;
        }
        ((EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class)).ENABLED = newValue = jCheckBox.isSelected();
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        MessageBus bus = messageBus;
        Topic<EditorConfigListener> topic = EditorConfigSettings.EDITOR_CONFIG_ENABLED_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"EDITOR_CONFIG_ENABLED_TOPIC");
        ((EditorConfigListener)bus.syncPublisher(topic)).valueChanged(newValue);
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        JCheckBox jCheckBox = this.myCbEnabled;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myCbEnabled");
            jCheckBox = null;
        }
        jCheckBox.setSelected(((EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class)).ENABLED);
    }

    public void disposeUIResources() {
    }

    public boolean isModified() {
        return false;
    }

    public void apply() {
    }

    public boolean hasSettingsPage() {
        return false;
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new EditorConfigSettings(settings);
    }

    private static final Unit createComponent$lambda$0(EditorConfigConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> EditorConfigConfigurable.createComponent$lambda$0$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$0(EditorConfigConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.myCbEnabled = (JCheckBox)Cell.comment$default((Cell)$this$row.checkBox(EditorConfigBundle.message((String)"config.enable")), (String)EditorConfigBundle.message((String)"config.warning"), (int)0, null, (int)6, null).getComponent();
        if (EditorConfigExportProviderEP.shouldShowExportButton()) {
            $this$row.button(EditorConfigBundle.message((String)"config.export"), arg_0 -> EditorConfigConfigurable.createComponent$lambda$0$0$0(this$0, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$0$0(EditorConfigConfigurable this$0, ActionEvent it) {
        Project project;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JCheckBox jCheckBox = this$0.myCbEnabled;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myCbEnabled");
            jCheckBox = null;
        }
        if ((project = ProjectUtil.getProjectForComponent((Component)jCheckBox)) != null) {
            if (EditorConfigExportProviderEP.tryExportViaProviders(project)) {
                return Unit.INSTANCE;
            }
            Utils.INSTANCE.export(project);
        }
        return Unit.INSTANCE;
    }
}

