/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.connection.throwable.KnownDatabaseException;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SslConnectionInterceptor;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.remote.jdbc.RemoteProcessController;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.run.ConsoleConfigurationParamProvider;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.ConsoleRunContextParametersTuner;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathsList;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u00012\u00020\u00022\u00020\u0003:\u0003\u0019\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\u000bJ,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0018H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dataSource/SslConnectionInterceptor;", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor;", "Lcom/intellij/database/run/ConsoleConfigurationParamProvider;", "Lcom/intellij/database/run/ConsoleRunContextParametersTuner;", "<init>", "()V", "interceptConnection", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "populate", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "params", "Lcom/intellij/execution/configurations/ParametersList;", "env", "", "", "tuneParams", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "UserKeyPasswordErrorInfo", "InitializationContext", "Companion", "intellij.database.connectivity"})
public final class SslConnectionInterceptor
implements DatabaseConnectionInterceptor,
ConsoleConfigurationParamProvider,
ConsoleRunContextParametersTuner {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Object interceptConnection(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent, @NotNull Continuation<? super Boolean> $completion) {
        LocalDataSource localDataSource = proto.getConnectionPoint().getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        LocalDataSource dataSource = localDataSource;
        DataSourceSslConfiguration ssl = dataSource.getSslCfg();
        if (ssl == null || !ssl.myEnabled) {
            return Boxing.boxBoolean((boolean)false);
        }
        JdbcSettings.SSL_MODE.put(proto.getExtraProperties(), (Object)ssl.myMode);
        return Boxing.boxBoolean((boolean)true);
    }

    public void populate(@NotNull LocalDataSource dataSource, @NotNull ParametersList params, @NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        DataSourceSslConfiguration ssl = dataSource.getSslCfg();
        if (ssl != null && ssl.myEnabled) {
            if (Registry.Companion.is("database.ssl.use.socket.factory", false)) {
                SslConnectionInterceptor.Companion.addNotEmpty(params, SslConnectionInterceptor.Companion.getCaCertPath(ssl), "sslCaCertPath");
                SslConnectionInterceptor.Companion.addNotEmpty(params, SslConnectionInterceptor.Companion.getClientCertPath(ssl), "sslClientCertPath");
                SslConnectionInterceptor.Companion.addNotEmpty(params, SslConnectionInterceptor.Companion.getClientKeyPath(ssl), "sslClientKeyPath");
                SslConnectionInterceptor.Companion.addNotEmpty(params, "true", "sslUseFactory");
            } else {
                if (StringUtil.isNotEmpty((String)SslConnectionInterceptor.Companion.getCaCertPath(ssl)) || ssl.myUseIdeStore || ssl.myUseJavaStore || ssl.myUseSystemStore) {
                    SslConnectionInterceptor.Companion.addNotEmpty(params, "true", "sslDeferredCaLoading");
                }
                if (StringUtil.isNotEmpty((String)SslConnectionInterceptor.Companion.getClientKeyPath(ssl))) {
                    SslConnectionInterceptor.Companion.addNotEmpty(params, "true", "sslDeferredKeyLoading");
                }
            }
            if (ssl.myUseSystemStore && JdbcConsoleRunContext.shouldPassJnaPath(dataSource)) {
                JdbcConsoleRunContext.passJnaPath(params);
            }
        }
    }

    @Override
    public void tuneParams(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull SimpleJavaParameters params) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        PathsList cp = params.getClassPath();
        JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "org.bouncycastle.jce.provider.BouncyCastleProvider");
        JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "org.bouncycastle.openssl.PEMParser");
        DataSourceSslConfiguration ssl = dataSource.getSslCfg();
        if (ssl != null && ssl.myEnabled && ssl.myUseSystemStore) {
            JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "org.jetbrains.nativecerts.NativeTrustedCertificates");
            JdbcConsoleRunContext.addClassJar(cp, JdbcNativeUtil.class, "com.sun.jna.Library");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0082@\u00a2\u0006\u0002\u0010\u0010J0\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0082@\u00a2\u0006\u0002\u0010\u0016J8\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00052\b\b\u0001\u0010\u0019\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0002\u0010\u001aJ\u001b\u0010\u001b\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0002J*\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0016\u0010#\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fJ\u0018\u0010$\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u0018\u0010%\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u0018\u0010&\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0002J\"\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u00052\u0006\u0010+\u001a\u00020\u0005H\u0002J(\u0010,\u001a\u0004\u0018\u00010\u00152\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0013H\u0082@\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u0010\u00104\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u0010\u00105\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u000fH\u0002\u00a8\u00066"}, d2={"Lcom/intellij/database/dataSource/SslConnectionInterceptor$Companion;", "", "<init>", "()V", "getUserKeyPasswordErrorMessage", "", "Lorg/jetbrains/annotations/Nls;", "originalMessage", "initProcess", "", "context", "Lcom/intellij/database/dataSource/SslConnectionInterceptor$InitializationContext;", "(Lcom/intellij/database/dataSource/SslConnectionInterceptor$InitializationContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initClientCert", "sslConfig", "Lcom/intellij/database/dataSource/DataSourceSslConfiguration;", "(Lcom/intellij/database/dataSource/SslConnectionInterceptor$InitializationContext;Lcom/intellij/database/dataSource/DataSourceSslConfiguration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initClientCertImpl", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "password", "Lcom/intellij/credentialStore/OneTimeString;", "(Lcom/intellij/database/dataSource/SslConnectionInterceptor$InitializationContext;Lcom/intellij/database/dataSource/DataSourceSslConfiguration;Lcom/intellij/database/access/DatabaseCredentials;Lcom/intellij/credentialStore/OneTimeString;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryLoadUserCertificatesWithNewPassword", "keyPath", "errorMessage", "(Lcom/intellij/database/dataSource/SslConnectionInterceptor$InitializationContext;Lcom/intellij/database/dataSource/DataSourceSslConfiguration;Lcom/intellij/database/access/DatabaseCredentials;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getKnownExceptionMessage", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "loadUserCertificates", "controller", "Lcom/intellij/database/remote/jdbc/RemoteProcessController;", "ssl", "initCaCert", "initIdeStore", "initJavaStore", "initSystemStore", "addNotEmpty", "props", "Lcom/intellij/execution/configurations/ParametersList;", "value", "key", "askNoCredentials", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "dc", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/access/DatabaseCredentials;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCaCertPath", "getClientCertPath", "getClientKeyPath", "intellij.database.connectivity"})
    public static final class Companion {
        private Companion() {
        }

        private final String getUserKeyPasswordErrorMessage(String originalMessage) {
            Object[] objectArray = new Object[]{originalMessage};
            String string = DatabaseBundle.message((String)"dialog.message.wrong.ssl.key.password", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Nullable
        public final Object initProcess(@NotNull InitializationContext context, @NotNull Continuation<? super Unit> $completion) {
            DataSourceSslConfiguration sslConfig = context.getSslConfig();
            if (sslConfig == null || !sslConfig.myEnabled) {
                return Unit.INSTANCE;
            }
            RemoteProcessController controller = context.getController();
            this.initCaCert(controller, sslConfig);
            this.initIdeStore(controller, sslConfig);
            this.initJavaStore(controller, sslConfig);
            this.initSystemStore(controller, sslConfig);
            Object object = this.initClientCert(context, sslConfig, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private final Object initClientCert(InitializationContext context, DataSourceSslConfiguration sslConfig, Continuation<? super Unit> $completion) {
            if (!($completion instanceof initClientCert.1)) ** GOTO lbl-1000
            var9_4 = $completion;
            if ((var9_4.label & -2147483648) != 0) {
                var9_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return com.intellij.database.dataSource.SslConnectionInterceptor$Companion.access$initClientCert(this.this$0, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (StringUtil.isEmpty((String)this.getClientKeyPath(sslConfig))) {
                        return Unit.INSTANCE;
                    }
                    v0 = DatabaseUiService.Companion.getInstance();
                    v1 = context.getRunConfiguration().CREDENTIALS;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"CREDENTIALS");
                    credentials = v0.newOneTimeInstance(v1);
                    dataSource = context.getDataSource();
                    project = context.getProject();
                    v2 = sslConfig.myPasswordStorage;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"myPasswordStorage");
                    $continuation.L$0 = context;
                    $continuation.L$1 = sslConfig;
                    $continuation.L$2 = credentials;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)dataSource);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.label = 1;
                    v3 = DatabaseCredentials.Companion.getInitialCredentials(v2, context.getSilent() == false, (Function1)new Function1<Continuation<? super OneTimeString>, Object>(credentials, dataSource, null){
                        int label;
                        final /* synthetic */ DatabaseCredentials $credentials;
                        final /* synthetic */ LocalDataSource $dataSource;
                        {
                            this.$credentials = $credentials;
                            this.$dataSource = $dataSource;
                            super(1, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super OneTimeString>, Object>(this.$credentials, this.$dataSource, null){
                                        int label;
                                        final /* synthetic */ DatabaseCredentials $credentials;
                                        final /* synthetic */ LocalDataSource $dataSource;
                                        {
                                            this.$credentials = $credentials;
                                            this.$dataSource = $dataSource;
                                            super(2, $completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    return this.$credentials.getSslPassphrase((DasDataSource)this.$dataSource);
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super OneTimeString> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)((Continuation)this));
                                    if (object2 != object) return object2;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return object2;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(Continuation<? super OneTimeString> p1) {
                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, (Function2)new Function2<Throwable, Continuation<? super OneTimeString>, Object>(project, dataSource, credentials, null){
                        int label;
                        /* synthetic */ Object L$0;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ LocalDataSource $dataSource;
                        final /* synthetic */ DatabaseCredentials $credentials;
                        {
                            this.$project = $project;
                            this.$dataSource = $dataSource;
                            this.$credentials = $credentials;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var2_2 = (Throwable)this.L$0;
                            var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    if (th != null) break;
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)th);
                                    this.label = 1;
                                    v0 = com.intellij.database.dataSource.SslConnectionInterceptor$Companion.access$askNoCredentials(SslConnectionInterceptor.Companion, this.$project, this.$dataSource, this.$credentials, (Continuation)this);
                                    if (v0 == var3_3) {
                                        return var3_3;
                                    }
                                    ** GOTO lbl16
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl16:
                                    // 2 sources

                                    v1 = (OneTimeString)v0;
                                    ** GOTO lbl28
                                }
                            }
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)th);
                            this.label = 2;
                            v2 = DatabaseUiService.Companion.getInstance().askSslCredentials(this.$project, this.$dataSource, this.$credentials, th.getMessage(), true, (Continuation<? super OneTimeString>)((Continuation)this));
                            if (v2 == var3_3) {
                                return var3_3;
                            }
                            ** GOTO lbl27
                            {
                                case 2: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl27:
                                    // 2 sources

                                    v1 = (OneTimeString)v2;
lbl28:
                                    // 2 sources

                                    return v1;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(Throwable p1, Continuation<? super OneTimeString> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, initClientCert$lambda$0(com.intellij.credentialStore.OneTimeString ), (Lcom/intellij/credentialStore/OneTimeString;)Ljava/lang/Boolean;)(), (Continuation)$continuation);
                    if (v3 == var10_6) {
                        return var10_6;
                    }
                    ** GOTO lbl40
                }
                case 1: {
                    project = (Project)$continuation.L$4;
                    dataSource = (LocalDataSource)$continuation.L$3;
                    credentials = (DatabaseCredentials)$continuation.L$2;
                    sslConfig = (DataSourceSslConfiguration)$continuation.L$1;
                    context = (InitializationContext)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl40:
                    // 2 sources

                    p = (OneTimeString)v3;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)sslConfig);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)credentials);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)dataSource);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)p);
                    $continuation.label = 2;
                    v4 = this.initClientCertImpl(context, sslConfig, credentials, p, (Continuation<? super Unit>)$continuation);
                    if (v4 == var10_6) {
                        return var10_6;
                    }
                    ** GOTO lbl61
                }
                case 2: {
                    p = (OneTimeString)$continuation.L$5;
                    project = (Project)$continuation.L$4;
                    dataSource = (LocalDataSource)$continuation.L$3;
                    credentials = (DatabaseCredentials)$continuation.L$2;
                    sslConfig = (DataSourceSslConfiguration)$continuation.L$1;
                    context = (InitializationContext)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl61:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final Object initClientCertImpl(InitializationContext context, DataSourceSslConfiguration sslConfig, DatabaseCredentials credentials, OneTimeString password, Continuation<? super Unit> $completion) {
            block4: {
                String keyPath = StringKt.nullize$default((String)this.getClientKeyPath(sslConfig), (boolean)false, (int)1, null);
                if (keyPath == null) {
                    return Unit.INSTANCE;
                }
                RemoteProcessController controller = context.getController();
                try {
                    this.loadUserCertificates(controller, sslConfig, keyPath, password);
                }
                catch (Exception e) {
                    String knownMessage = this.getKnownExceptionMessage(e);
                    if (knownMessage == null || context.getSilent()) {
                        throw e;
                    }
                    Object object = this.tryLoadUserCertificatesWithNewPassword(context, sslConfig, credentials, keyPath, knownMessage, $completion);
                    if (object != IntrinsicsKt.getCOROUTINE_SUSPENDED()) break block4;
                    return object;
                }
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private final Object tryLoadUserCertificatesWithNewPassword(InitializationContext context, DataSourceSslConfiguration sslConfig, DatabaseCredentials credentials, String keyPath, @Nls String errorMessage, Continuation<? super Unit> $completion) throws Exception {
            if (!($completion instanceof tryLoadUserCertificatesWithNewPassword.1)) ** GOTO lbl-1000
            var17_7 = $completion;
            if ((var17_7.label & -2147483648) != 0) {
                var17_7.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return com.intellij.database.dataSource.SslConnectionInterceptor$Companion.access$tryLoadUserCertificatesWithNewPassword(this.this$0, null, null, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var18_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    dataSource = context.getDataSource();
                    project = context.getProject();
                    controller = context.getController();
                    maxWrongPasswordAttempts = 2;
                    currentErrorMessage = errorMessage;
                    attempt = 1;
                    while (true) {
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                        $continuation.L$1 = sslConfig;
                        $continuation.L$2 = credentials;
                        $continuation.L$3 = keyPath;
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)errorMessage);
                        $continuation.L$5 = dataSource;
                        $continuation.L$6 = project;
                        $continuation.L$7 = controller;
                        $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)currentErrorMessage);
                        $continuation.I$0 = maxWrongPasswordAttempts;
                        $continuation.I$1 = ++attempt;
                        $continuation.label = 1;
                        v0 = DatabaseUiService.Companion.getInstance().askSslCredentials(project, dataSource, credentials, currentErrorMessage, true, (Continuation<? super OneTimeString>)$continuation);
                        if (v0 == var18_9) {
                            return var18_9;
                        }
                        ** GOTO lbl49
                        break;
                    }
                }
                case 1: {
                    attempt = $continuation.I$1;
                    maxWrongPasswordAttempts = $continuation.I$0;
                    currentErrorMessage = (String)$continuation.L$8;
                    controller = (RemoteProcessController)$continuation.L$7;
                    project = (Project)$continuation.L$6;
                    dataSource = (LocalDataSource)$continuation.L$5;
                    errorMessage = (String)$continuation.L$4;
                    keyPath = (String)$continuation.L$3;
                    credentials = (DatabaseCredentials)$continuation.L$2;
                    sslConfig = (DataSourceSslConfiguration)$continuation.L$1;
                    context = (InitializationContext)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl49:
                    // 2 sources

                    currentPassword = (OneTimeString)v0;
                    try {
                        this.loadUserCertificates(controller, sslConfig, keyPath, currentPassword);
                        return Unit.INSTANCE;
                    }
                    catch (Exception e) {
                        knownMessage = this.getKnownExceptionMessage(e);
                        if (knownMessage == null) {
                            throw e;
                        }
                        if (attempt == maxWrongPasswordAttempts) {
                            throw new KnownDatabaseException((ErrorInfo)new UserKeyPasswordErrorInfo(dataSource, e));
                        }
                        currentErrorMessage = knownMessage;
                        if (attempt != maxWrongPasswordAttempts) ** continue;
                        return Unit.INSTANCE;
                    }
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final String getKnownExceptionMessage(Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                return null;
            }
            if (StringsKt.contains$default((CharSequence)msg, (CharSequence)"JCE error: Password is not ASCII", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)msg, (CharSequence)"JCE error: Cannot retrieve the PKCS8EncodedKeySpec", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)msg, (CharSequence)"Password verification failed", (boolean)false, (int)2, null)) {
                return this.getUserKeyPasswordErrorMessage(msg);
            }
            return null;
        }

        private final void loadUserCertificates(RemoteProcessController controller, DataSourceSslConfiguration ssl, String keyPath, OneTimeString password) throws Exception {
            String certPath = StringUtil.nullize((String)this.getClientCertPath(ssl));
            if (StringsKt.endsWith$default((String)keyPath, (String)".jks", (boolean)false, (int)2, null) && certPath == null) {
                OneTimeString oneTimeString = password;
                controller.loadUserCertificates(keyPath, oneTimeString != null ? OneTimeString.toCharArray$default((OneTimeString)oneTimeString, (boolean)false, (int)1, null) : null);
            } else {
                OneTimeString oneTimeString = password;
                controller.loadUserCertificate("user-provided-key", keyPath, certPath, oneTimeString != null ? OneTimeString.toCharArray$default((OneTimeString)oneTimeString, (boolean)false, (int)1, null) : null);
            }
        }

        public final void initCaCert(@NotNull RemoteProcessController controller, @NotNull DataSourceSslConfiguration ssl) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
            String caPath = StringUtil.nullize((String)this.getCaCertPath(ssl));
            if (caPath != null) {
                try {
                    if (StringsKt.endsWith$default((String)caPath, (String)".jks", (boolean)false, (int)2, null)) {
                        controller.loadTrustedCertificates(caPath, null);
                    } else {
                        controller.loadTrustedCertificate("user-provided-ca", caPath);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to load CA certificate", e);
                }
            }
        }

        private final void initIdeStore(RemoteProcessController controller, DataSourceSslConfiguration ssl) {
            Pair<String, String> pair = DatabaseUiService.Companion.getInstance().getIdeStoreParams();
            String storePath = (String)pair.component1();
            String storePassword = (String)pair.component2();
            boolean enabled = ssl.myUseIdeStore;
            if (!enabled || !new File(storePath).exists()) {
                return;
            }
            try {
                char[] cArray = storePassword.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                controller.loadTrustedCertificates(storePath, cArray);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load IDE store", e);
            }
        }

        private final void initJavaStore(RemoteProcessController controller, DataSourceSslConfiguration ssl) {
            if (!ssl.myUseJavaStore) {
                return;
            }
            try {
                controller.loadJavaTrustedCertificates();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load java store", e);
            }
        }

        private final void initSystemStore(RemoteProcessController controller, DataSourceSslConfiguration ssl) {
            if (!ssl.myUseSystemStore) {
                return;
            }
            try {
                controller.loadSystemTrustedCertificates();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load system store", e);
            }
        }

        private final void addNotEmpty(ParametersList props, String value, String key) {
            CharSequence charSequence = value;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                props.addProperty(key, value);
            }
        }

        private final Object askNoCredentials(Project project, LocalDataSource dataSource, DatabaseCredentials dc, Continuation<? super OneTimeString> $completion) {
            return DatabaseUiService.Companion.getInstance().askSslCredentials(project, dataSource, dc, DatabaseBundle.message((String)"dialog.message.html.please.provide.ssl.private.key.passphrase.html", (Object[])new Object[0]), false, $completion);
        }

        private final String getCaCertPath(DataSourceSslConfiguration ssl) {
            String string = OSAgnosticPathUtil.expandUserHome((String)ssl.myCaCertPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expandUserHome(...)");
            return string;
        }

        private final String getClientCertPath(DataSourceSslConfiguration ssl) {
            String string = OSAgnosticPathUtil.expandUserHome((String)ssl.myClientCertPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expandUserHome(...)");
            return string;
        }

        private final String getClientKeyPath(DataSourceSslConfiguration ssl) {
            String string = OSAgnosticPathUtil.expandUserHome((String)ssl.myClientKeyPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expandUserHome(...)");
            return string;
        }

        private static final boolean initClientCert$lambda$0(OneTimeString it) {
            return it == null;
        }

        public static final /* synthetic */ Object access$initClientCert(Companion $this, InitializationContext context, DataSourceSslConfiguration sslConfig, Continuation $completion) {
            return $this.initClientCert(context, sslConfig, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$askNoCredentials(Companion $this, Project project, LocalDataSource dataSource, DatabaseCredentials dc, Continuation $completion) {
            return $this.askNoCredentials(project, dataSource, dc, (Continuation<? super OneTimeString>)$completion);
        }

        public static final /* synthetic */ Object access$initClientCertImpl(Companion $this, InitializationContext context, DataSourceSslConfiguration sslConfig, DatabaseCredentials credentials, OneTimeString password, Continuation $completion) {
            return $this.initClientCertImpl(context, sslConfig, credentials, password, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$tryLoadUserCertificatesWithNewPassword(Companion $this, InitializationContext context, DataSourceSslConfiguration sslConfig, DatabaseCredentials credentials, String keyPath, String errorMessage, Continuation $completion) {
            return $this.tryLoadUserCertificatesWithNewPassword(context, sslConfig, credentials, keyPath, errorMessage, (Continuation<? super Unit>)$completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dataSource/SslConnectionInterceptor$InitializationContext;", "", "controller", "Lcom/intellij/database/remote/jdbc/RemoteProcessController;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "runConfiguration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "silent", "", "<init>", "(Lcom/intellij/database/remote/jdbc/RemoteProcessController;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/run/ConsoleRunConfiguration;Z)V", "getController", "()Lcom/intellij/database/remote/jdbc/RemoteProcessController;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getRunConfiguration", "()Lcom/intellij/database/run/ConsoleRunConfiguration;", "getSilent", "()Z", "sslConfig", "Lcom/intellij/database/dataSource/DataSourceSslConfiguration;", "getSslConfig", "()Lcom/intellij/database/dataSource/DataSourceSslConfiguration;", "intellij.database.connectivity"})
    public static final class InitializationContext {
        @NotNull
        private final RemoteProcessController controller;
        @NotNull
        private final Project project;
        @NotNull
        private final LocalDataSource dataSource;
        @NotNull
        private final ConsoleRunConfiguration runConfiguration;
        private final boolean silent;
        @Nullable
        private final DataSourceSslConfiguration sslConfig;

        public InitializationContext(@NotNull RemoteProcessController controller, @NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull ConsoleRunConfiguration runConfiguration, boolean silent) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
            this.controller = controller;
            this.project = project;
            this.dataSource = dataSource;
            this.runConfiguration = runConfiguration;
            this.silent = silent;
            this.sslConfig = this.dataSource.getSslCfg();
        }

        @NotNull
        public final RemoteProcessController getController() {
            return this.controller;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final LocalDataSource getDataSource() {
            return this.dataSource;
        }

        @NotNull
        public final ConsoleRunConfiguration getRunConfiguration() {
            return this.runConfiguration;
        }

        public final boolean getSilent() {
            return this.silent;
        }

        @Nullable
        public final DataSourceSslConfiguration getSslConfig() {
            return this.sslConfig;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ,\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u00100\fj\u0007`\u000e\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dataSource/SslConnectionInterceptor$UserKeyPasswordErrorInfo;", "Lcom/intellij/database/dialects/BaseDatabaseErrorHandler$DatabaseErrorInfo;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "(Lcom/intellij/database/dataSource/LocalDataSource;Ljava/lang/Exception;)V", "fillInfoData", "", "sb", "Ljava/lang/StringBuilder;", "Lorg/jetbrains/annotations/Nls;", "Lkotlin/text/StringBuilder;", "fixes", "", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "intellij.database.connectivity"})
    public static final class UserKeyPasswordErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        public UserKeyPasswordErrorInfo(@NotNull LocalDataSource dataSource, @NotNull Exception e) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super(dataSource, (Throwable)e, (Throwable)e);
        }

        protected void fillInfoData(@NotNull StringBuilder sb, @NotNull List<? extends ErrorInfo.Fix> fixes) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
            String string = this.getOriginalThrowable().getMessage();
            if (string == null) {
                string = "";
            }
            String msg = string;
            sb.append(Companion.getUserKeyPasswordErrorMessage(msg));
        }
    }
}

