/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.MatchingProcess;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchScriptException;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UsageViewContext;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SearchCommand {
    @NotNull
    protected final SearchContext mySearchContext;
    @NotNull
    protected final Configuration myConfiguration;
    private FindUsagesProcessPresentation myProcessPresentation;

    public SearchCommand(@NotNull Configuration configuration, @NotNull SearchContext searchContext) {
        if (configuration == null) {
            SearchCommand.$$$reportNull$$$0(0);
        }
        if (searchContext == null) {
            SearchCommand.$$$reportNull$$$0(1);
        }
        this.myConfiguration = configuration;
        this.mySearchContext = searchContext;
    }

    @NotNull
    protected UsageViewContext createUsageViewContext() {
        Runnable searchStarter = () -> new SearchCommand(this.myConfiguration, this.mySearchContext).startSearching();
        return new UsageViewContext(this.myConfiguration, this.mySearchContext, searchStarter);
    }

    public void startSearching() {
        final UsageViewContext context = this.createUsageViewContext();
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setOpenInNewTab(FindSettings.getInstance().isShowResultsInSeparateView());
        context.configure(presentation);
        this.myProcessPresentation = new FindUsagesProcessPresentation(presentation);
        this.myProcessPresentation.setShowNotFoundMessage(true);
        this.myProcessPresentation.setShowPanelIfOnlyOneUsage(true);
        PsiDocumentManager.getInstance((Project)this.mySearchContext.getProject()).commitAllDocuments();
        ConfigurableUsageTarget target = context.getTarget();
        ((FindManagerImpl)FindManager.getInstance((Project)this.mySearchContext.getProject())).getFindUsagesManager().addToHistory(target);
        UsageViewManager.getInstance((Project)this.mySearchContext.getProject()).searchAndShowUsages(new UsageTarget[]{target}, () -> processor -> this.findUsages((Processor<? super Usage>)processor), this.myProcessPresentation, presentation, new UsageViewManager.UsageViewStateListener(){

            public void usageViewCreated(@NotNull UsageView usageView) {
                if (usageView == null) {
                    1.$$$reportNull$$$0(0);
                }
                context.setUsageView(usageView);
                context.configureActions();
            }

            public void findingUsagesFinished(UsageView usageView) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/structuralsearch/plugin/ui/SearchCommand$1", "usageViewCreated"));
            }
        });
    }

    public void findUsages(final @NotNull Processor<? super Usage> processor) {
        if (processor == null) {
            SearchCommand.$$$reportNull$$$0(2);
        }
        final ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        progress.setIndeterminate(false);
        MatchResultSink sink = new MatchResultSink(){
            int count;

            @Override
            public void setMatchingProcess(@NotNull MatchingProcess _process) {
                if (_process == null) {
                    2.$$$reportNull$$$0(0);
                }
                SearchCommand.this.findStarted();
            }

            @Override
            public void processFile(@NotNull PsiFile element) {
                VirtualFile virtualFile;
                if (element == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((virtualFile = element.getVirtualFile()) != null) {
                    progress.setText(SSRBundle.message("looking.in.progress.message", virtualFile.getPresentableName()));
                }
            }

            @Override
            public void matchingFinished() {
                if (SearchCommand.this.mySearchContext.getProject().isDisposed()) {
                    return;
                }
                SearchCommand.this.findEnded();
                progress.setText(SSRBundle.message("found.progress.message", this.count));
            }

            @Override
            public ProgressIndicator getProgressIndicator() {
                return progress;
            }

            @Override
            public void newMatch(@NotNull MatchResult result) {
                UsageInfo info;
                if (result == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ("__multi_line__".equals(result.getName())) {
                    int start2 = -1;
                    int end = -1;
                    PsiElement parent = result.getMatch().getParent();
                    for (MatchResult matchResult : result.getChildren()) {
                        int newend;
                        PsiElement el = matchResult.getMatch();
                        int elementStart = el.getTextRange().getStartOffset();
                        if (start2 == -1 || start2 > elementStart) {
                            start2 = elementStart;
                        }
                        if ((newend = elementStart + el.getTextLength()) <= end) continue;
                        end = newend;
                    }
                    int parentStart = parent.getTextRange().getStartOffset();
                    int startOffset = start2 - parentStart;
                    info = new UsageInfo(parent, startOffset, end - parentStart);
                } else {
                    PsiElement match = result.getMatch();
                    if (!match.isPhysical()) {
                        return;
                    }
                    info = new UsageInfo(match);
                }
                UsageInfo2UsageAdapter usage = new UsageInfo2UsageAdapter(info);
                SearchCommand.this.foundUsage(result, (Usage)usage);
                processor.process((Object)usage);
                ++this.count;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "_process";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SearchCommand$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setMatchingProcess";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "newMatch";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        try {
            new Matcher(this.mySearchContext.getProject(), this.myConfiguration.getMatchOptions()).findMatches(sink);
        }
        catch (StructuralSearchException e) {
            this.myProcessPresentation.setShowNotFoundMessage(false);
            String content = e instanceof StructuralSearchScriptException ? SSRBundle.message("search.script.problem", e.getCause().toString().replace("a3cd264774bf4efb9ab609b250c5165c", "")) : SSRBundle.message("search.template.problem", e.getMessage());
            NotificationGroupManager.getInstance().getNotificationGroup("Structural Search").createNotification(content, NotificationType.ERROR).setImportant(true).notify(this.mySearchContext.getProject());
        }
    }

    protected void findStarted() {
    }

    protected void findEnded() {
    }

    protected void foundUsage(MatchResult result, Usage usage) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SearchCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

