/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.printing;

import com.intellij.ide.actions.PrintActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.printing.DarculaAwareGraph2DPrinter;
import com.intellij.openapi.graph.builder.actions.printing.PrintOptionsDialog;
import com.intellij.openapi.graph.builder.actions.printing.PrintUtil;
import com.intellij.openapi.graph.option.OptionHandler;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.view.BackgroundRenderer;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DPrinter;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.PrintPreviewPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramPrintHandler
extends PrintActionHandler {
    private static final Logger LOG = Logger.getInstance(DiagramPrintHandler.class);

    public boolean canPrint(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DiagramPrintHandler.I(0);
        }
        return GraphDataKeys.GRAPH_BUILDER.getData(dataContext) != null;
    }

    public void print(@NotNull DataContext dataContext) {
        GraphBuilder graphBuilder;
        if (dataContext == null) {
            DiagramPrintHandler.I(1);
        }
        if ((graphBuilder = (GraphBuilder)GraphDataKeys.GRAPH_BUILDER.getData(dataContext)) == null) {
            return;
        }
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        final Project project = graphBuilder.getProject();
        final Graph2D graph2D = graphBuilder.getGraph();
        Graph2DView graph2DView = AbstractGraphAction.getGraph2DView((Graph2D)graph2D);
        final BackgroundRenderer backgroundRenderer = graph2DView.getBackgroundRenderer();
        DarculaAwareGraph2DPrinter darculaAwareGraph2DPrinter = new DarculaAwareGraph2DPrinter(graph2DView);
        PrintPreviewPanel printPreviewPanel = GraphManager.getGraphManager().createPrintPreviewPanel(printerJob, (Printable)darculaAwareGraph2DPrinter, darculaAwareGraph2DPrinter.getPosterColumns(), darculaAwareGraph2DPrinter.getPosterColumns() * darculaAwareGraph2DPrinter.getPosterRows(), printerJob.defaultPage());
        printPreviewPanel.setThreadingEnabled(false);
        final OptionHandler optionHandler = PrintUtil.createPrintOptions();
        AbstractAction abstractAction = new AbstractAction(GraphBundle.message((String)"button.text.print.options", (Object[])new Object[0]), (Graph2DPrinter)darculaAwareGraph2DPrinter, printPreviewPanel){
            final /* synthetic */ Graph2DPrinter val$gp;
            final /* synthetic */ PrintPreviewPanel val$panel;
            {
                this.val$gp = graph2DPrinter;
                this.val$panel = printPreviewPanel;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent ev2) {
                PrintOptionsDialog printOptionsDialog = new PrintOptionsDialog(project, optionHandler);
                if (!printOptionsDialog.showAndGet()) {
                    return;
                }
                PrintUtil.initGraph2DPrinter((Graph2DPrinter)this.val$gp, (OptionHandler)optionHandler);
                this.val$panel.setPages(0, this.val$gp.getPosterColumns(), this.val$gp.getPosterColumns() * this.val$gp.getPosterRows());
            }
        };
        printPreviewPanel.addControlComponent((JComponent)new JButton(abstractAction));
        final JPanel jPanel = printPreviewPanel.getJPanel();
        UIUtil.uiTraverser((Component)jPanel).filter(JButton.class).filter(jButton -> jButton.getText().startsWith("Print")).consumeEach(jButton -> jButton.setVisible(false));
        new DialogWrapper(this, project, (Graph2DPrinter)darculaAwareGraph2DPrinter, printPreviewPanel){
            final /* synthetic */ Graph2DPrinter val$gp;
            final /* synthetic */ PrintPreviewPanel val$panel;
            {
                this.val$gp = graph2DPrinter;
                this.val$panel = printPreviewPanel;
                super(arg0);
                this.setTitle(GraphBundle.message((String)"dialog.title.print.preview", (Object[])new Object[0]));
                this.init();
                this.getOKAction().putValue("Name", GraphBundle.message((String)"button.print", (Object[])new Object[0]));
            }

            protected String getDimensionServiceKey() {
                return "Diagram.Print.Preview.Dialog";
            }

            protected JComponent createCenterPanel() {
                DiagramPrintHandler.I(graph2D, backgroundRenderer, graphBuilder);
                ApplicationManager.getApplication().invokeLater(() -> DiagramPrintHandler.I(backgroundRenderer, graphBuilder));
                return jPanel;
            }

            protected void doOKAction() {
                super.doOKAction();
                printerJob.setPrintable((Printable)this.val$gp, this.val$panel.getPageFormat());
                DiagramPrintHandler.I(graph2D, backgroundRenderer, graphBuilder, printerJob);
            }
        }.show();
    }

    private static void I(@NotNull Graph2D graph2D, @Nullable BackgroundRenderer backgroundRenderer, @Nullable GraphBuilder graphBuilder) {
        if (graph2D == null) {
            DiagramPrintHandler.I(2);
        }
        if (!StartupUiUtil.isUnderDarcula()) {
            return;
        }
        if (backgroundRenderer instanceof DefaultBackgroundRenderer) {
            ((DefaultBackgroundRenderer)backgroundRenderer).setColor(Color.white);
        }
        JBColor.setDark((boolean)false);
        GraphExportService.getInstance().setPrintMode(true);
        graph2D.getCurrentView().updateView();
        if (graphBuilder != null) {
            graphBuilder.queryGraphUpdate().withDataReload().withRelayout().run();
            graphBuilder.getGraph().updateViews();
        }
    }

    private static void I(@Nullable BackgroundRenderer backgroundRenderer, @Nullable GraphBuilder graphBuilder) {
        if (!StartupUiUtil.isUnderDarcula()) {
            return;
        }
        GraphExportService.getInstance().setPrintMode(false);
        JBColor.setDark((boolean)StartupUiUtil.isUnderDarcula());
        if (backgroundRenderer instanceof DefaultBackgroundRenderer) {
            ((DefaultBackgroundRenderer)backgroundRenderer).setColor(JBColor.background());
        }
        if (graphBuilder != null) {
            graphBuilder.queryGraphUpdate().withDataReload().withRelayout().run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void I(@NotNull Graph2D graph2D, BackgroundRenderer backgroundRenderer, GraphBuilder graphBuilder, PrinterJob printerJob) {
        if (graph2D == null) {
            DiagramPrintHandler.I(3);
        }
        if (printerJob.printDialog()) {
            try {
                DiagramPrintHandler.I(graph2D, backgroundRenderer, graphBuilder);
                printerJob.print();
            }
            catch (Exception exception) {
                LOG.error((Throwable)exception);
            }
            finally {
                DiagramPrintHandler.I(backgroundRenderer, graphBuilder);
            }
        }
    }

    private static /* synthetic */ void I(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph2D";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/graph/builder/actions/printing/DiagramPrintHandler";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canPrint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "print";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setupBackgroundBeforePrint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doPrint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

