/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 53676807901954L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1693424400 - (char)-12612, 1693293330 + (char)-5590, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1693424400 - (char)-12613, 1693424400 - (char)-21485, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 62066576971437L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.I();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 == 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-4587450 - -18867, 4587450 - 4659, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-4587450 - -18866, -4587450 - -17347, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-4587450 - -18873, -4587450 - -3128, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 82629713501821L;
                Object object = this.lock;
                n2 = SshAgentIpcService.f();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1162328760 - (char)-18038, 1162328760 - 24273, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1162328760 - (char)-18037, -1162328760 - -24820, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1162328760 - (char)-18036, -1162328760 - -((char)-30843), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (n2 != 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1162328760 - (char)-18027, 1162328760 - (char)-20454, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1162328760 - (char)-18026, -1162328760 - -((char)-23239), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1162328760 - (char)-18025, -1162328760 - -((char)-18726), (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1162328760 - (char)-18027, 1162328760 - (char)-20454, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1162328760 - (char)-18024, -1162328760 - -24929, (int)l2));
            if (ActionTimestamp.I() == null) {
                SshAgentIpcService.I(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 39104078701083L;
                    n3 = SshAgentIpcService.f();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 != 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 != 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int n2;
        long l2;
        block27: {
            block28: {
                l2 = 84777680253605L;
                int n3 = SshAgentIpcService.f();
                this.assertConnectionThread();
                Object object3 = this.lock;
                n2 = n3;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 != 0) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(679204740 - 10629, 679204740 - 10583, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(679204740 - 10633, 679204740 - 12606, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(679204740 - 10630, -679204740 - -8288, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(679204740 - 10633, 679204740 - 12606, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(679204740 - 10631, 679204740 + 3286, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(679204740 - 10629, 679204740 - 10583, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(679204740 - 10633, 679204740 - 12606, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(679204740 - 10632, 679204740 + 2096, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (n2 != 0) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n4 = Kernel32.INSTANCE.GetLastError();
                if (n4 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(679204740 - 10629, 679204740 - 10583, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(679204740 - 10633, 679204740 - 12606, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(679204740 - 10657, 679204740 - 10577, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(679204740 - 10633, 679204740 - 12606, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(679204740 - 10658, -679204740 + -8221, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n4)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 != 0) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(679204740 - 10633, 679204740 - 12606, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(679204740 - 10631, 679204740 + 3286, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(679204740 - 10629, 679204740 - 10583, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(679204740 - 10633, 679204740 - 12606, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(679204740 - 10659, 679204740 - 22044, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 57749223475786L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-906742260 + -23214, -906742260 + -21942, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 7376276774207L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1817940900 - (char)-30854, -1817940900 - -7337, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00e8\u00c1\u00f9\u00e8\u00f7\u00ee\u009c_\u0080U\u000b\n\u00dfQ\u0016_\u00f1~\u00c3\u0014\u00dbJ\u009f\u009f \u00c2\u001b_\u00f2S\u0080\u001el*\u00a1\u00bb\u00ea$\u00a7\u00a5";
                        var4_3 = "\u00e8\u00c1\u00f9\u00e8\u00f7\u00ee\u009c_\u0080U\u000b\n\u00dfQ\u0016_\u00f1~\u00c3\u0014\u00dbJ\u009f\u009f \u00c2\u001b_\u00f2S\u0080\u001el*\u00a1\u00bb\u00ea$\u00a7\u00a5".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 24;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 17;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 97;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 9;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 103;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 5;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 20;
                                        break;
                                    }
                                    default: {
                                        v11 = 15;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x5114) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 134;
                            case 1 -> 111;
                            case 2 -> 180;
                            case 3 -> 170;
                            case 4 -> 118;
                            case 5 -> 216;
                            case 6 -> 2;
                            case 7 -> 127;
                            case 8 -> 132;
                            case 9 -> 62;
                            case 10 -> 32;
                            case 11 -> 218;
                            case 12 -> 57;
                            case 13 -> 18;
                            case 14 -> 0;
                            case 15 -> 90;
                            case 16 -> 17;
                            case 17 -> 245;
                            case 18 -> 128;
                            case 19 -> 11;
                            case 20 -> 137;
                            case 21 -> 224;
                            case 22 -> 114;
                            case 23 -> 35;
                            case 24 -> 55;
                            case 25 -> 188;
                            case 26 -> 142;
                            case 27 -> 174;
                            case 28 -> 19;
                            case 29 -> 79;
                            case 30 -> 30;
                            case 31 -> 172;
                            case 32 -> 31;
                            case 33 -> 95;
                            case 34 -> 225;
                            case 35 -> 88;
                            case 36 -> 161;
                            case 37 -> 66;
                            case 38 -> 53;
                            case 39 -> 91;
                            case 40 -> 179;
                            case 41 -> 181;
                            case 42 -> 197;
                            case 43 -> 169;
                            case 44 -> 203;
                            case 45 -> 68;
                            case 46 -> 36;
                            case 47 -> 110;
                            case 48 -> 154;
                            case 49 -> 246;
                            case 50 -> 59;
                            case 51 -> 77;
                            case 52 -> 39;
                            case 53 -> 151;
                            case 54 -> 47;
                            case 55 -> 116;
                            case 56 -> 41;
                            case 57 -> 12;
                            case 58 -> 99;
                            case 59 -> 109;
                            case 60 -> 63;
                            case 61 -> 20;
                            case 62 -> 152;
                            case 63 -> 164;
                            case 64 -> 250;
                            case 65 -> 228;
                            case 66 -> 207;
                            case 67 -> 81;
                            case 68 -> 198;
                            case 69 -> 240;
                            case 70 -> 192;
                            case 71 -> 94;
                            case 72 -> 97;
                            case 73 -> 71;
                            case 74 -> 201;
                            case 75 -> 24;
                            case 76 -> 122;
                            case 77 -> 155;
                            case 78 -> 25;
                            case 79 -> 23;
                            case 80 -> 243;
                            case 81 -> 189;
                            case 82 -> 76;
                            case 83 -> 158;
                            case 84 -> 182;
                            case 85 -> 222;
                            case 86 -> 69;
                            case 87 -> 165;
                            case 88 -> 21;
                            case 89 -> 80;
                            case 90 -> 160;
                            case 91 -> 146;
                            case 92 -> 50;
                            case 93 -> 168;
                            case 94 -> 49;
                            case 95 -> 219;
                            case 96 -> 178;
                            case 97 -> 136;
                            case 98 -> 133;
                            case 99 -> 185;
                            case 100 -> 148;
                            case 101 -> 4;
                            case 102 -> 87;
                            case 103 -> 248;
                            case 104 -> 26;
                            case 105 -> 102;
                            case 106 -> 230;
                            case 107 -> 231;
                            case 108 -> 191;
                            case 109 -> 65;
                            case 110 -> 166;
                            case 111 -> 177;
                            case 112 -> 238;
                            case 113 -> 106;
                            case 114 -> 51;
                            case 115 -> 140;
                            case 116 -> 199;
                            case 117 -> 239;
                            case 118 -> 96;
                            case 119 -> 254;
                            case 120 -> 212;
                            case 121 -> 119;
                            case 122 -> 43;
                            case 123 -> 247;
                            case 124 -> 167;
                            case 125 -> 220;
                            case 126 -> 251;
                            case 127 -> 150;
                            case 128 -> 186;
                            case 129 -> 156;
                            case 130 -> 196;
                            case 131 -> 221;
                            case 132 -> 235;
                            case 133 -> 226;
                            case 134 -> 252;
                            case 135 -> 29;
                            case 136 -> 130;
                            case 137 -> 120;
                            case 138 -> 234;
                            case 139 -> 27;
                            case 140 -> 48;
                            case 141 -> 56;
                            case 142 -> 42;
                            case 143 -> 44;
                            case 144 -> 229;
                            case 145 -> 14;
                            case 146 -> 58;
                            case 147 -> 143;
                            case 148 -> 8;
                            case 149 -> 149;
                            case 150 -> 75;
                            case 151 -> 232;
                            case 152 -> 124;
                            case 153 -> 157;
                            case 154 -> 117;
                            case 155 -> 210;
                            case 156 -> 176;
                            case 157 -> 54;
                            case 158 -> 5;
                            case 159 -> 138;
                            case 160 -> 108;
                            case 161 -> 67;
                            case 162 -> 175;
                            case 163 -> 194;
                            case 164 -> 82;
                            case 165 -> 10;
                            case 166 -> 46;
                            case 167 -> 195;
                            case 168 -> 206;
                            case 169 -> 6;
                            case 170 -> 104;
                            case 171 -> 84;
                            case 172 -> 153;
                            case 173 -> 83;
                            case 174 -> 171;
                            case 175 -> 1;
                            case 176 -> 163;
                            case 177 -> 131;
                            case 178 -> 89;
                            case 179 -> 135;
                            case 180 -> 60;
                            case 181 -> 241;
                            case 182 -> 115;
                            case 183 -> 183;
                            case 184 -> 173;
                            case 185 -> 217;
                            case 186 -> 92;
                            case 187 -> 113;
                            case 188 -> 204;
                            case 189 -> 223;
                            case 190 -> 9;
                            case 191 -> 72;
                            case 192 -> 200;
                            case 193 -> 233;
                            case 194 -> 227;
                            case 195 -> 184;
                            case 196 -> 144;
                            case 197 -> 40;
                            case 198 -> 28;
                            case 199 -> 214;
                            case 200 -> 22;
                            case 201 -> 190;
                            case 202 -> 123;
                            case 203 -> 162;
                            case 204 -> 13;
                            case 205 -> 215;
                            case 206 -> 213;
                            case 207 -> 7;
                            case 208 -> 93;
                            case 209 -> 147;
                            case 210 -> 126;
                            case 211 -> 187;
                            case 212 -> 101;
                            case 213 -> 38;
                            case 214 -> 3;
                            case 215 -> 70;
                            case 216 -> 15;
                            case 217 -> 249;
                            case 218 -> 33;
                            case 219 -> 208;
                            case 220 -> 139;
                            case 221 -> 61;
                            case 222 -> 86;
                            case 223 -> 37;
                            case 224 -> 100;
                            case 225 -> 141;
                            case 226 -> 107;
                            case 227 -> 73;
                            case 228 -> 242;
                            case 229 -> 45;
                            case 230 -> 52;
                            case 231 -> 121;
                            case 232 -> 236;
                            case 233 -> 159;
                            case 234 -> 209;
                            case 235 -> 193;
                            case 236 -> 244;
                            case 237 -> 34;
                            case 238 -> 145;
                            case 239 -> 253;
                            case 240 -> 125;
                            case 241 -> 112;
                            case 242 -> 64;
                            case 243 -> 129;
                            case 244 -> 16;
                            case 245 -> 255;
                            case 246 -> 78;
                            case 247 -> 98;
                            case 248 -> 105;
                            case 249 -> 103;
                            case 250 -> 237;
                            case 251 -> 211;
                            case 252 -> 205;
                            case 253 -> 74;
                            case 254 -> 85;
                            default -> 202;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (n2 != 0) {
                ActionTimestamp.I(new int[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 20214317254158L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.f();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 != 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2093843250 - (char)-5666, 2093843250 - (char)-5972, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(2093843250 - (char)-5662, 2093843250 - (char)-4027, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(2093843250 - (char)-5657, 2093843250 - (char)-21132, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2093843250 - (char)-5666, 2093843250 - (char)-5972, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(2093843250 - (char)-5662, 2093843250 - (char)-4027, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(2093843250 - (char)-5658, 2093843250 - (char)-23376, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 27200951499552L;
                        int n3 = SshAgentIpcService.I();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-923650290 - -27989, -923650290 - -((char)-29207), (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 == 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 == 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-923650290 - -27986, -923650290 - -27466, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 == 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 43660687301258L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    n2 = SshAgentIpcService.I();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 == 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 == 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1950190530 + (char)-17906, 1950190530 + (char)-17856, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1950190530 + (char)-17902, 1950190530 + (char)-15705, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1950190530 + (char)-17911, -1950190530 + -((char)-25701), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1950190530 + (char)-17902, 1950190530 + (char)-15705, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1950190530 + (char)-17904, 1950190530 + (char)-32589, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1950190530 + (char)-17906, 1950190530 + (char)-17856, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1950190530 + (char)-17902, 1950190530 + (char)-15705, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1950190530 + (char)-17918, -1950190530 + -((char)-7807), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 == 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1950190530 + (char)-17906, 1950190530 + (char)-17856, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1950190530 + (char)-17902, 1950190530 + (char)-15705, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1950190530 + (char)-17917, 1950190530 + (char)-29802, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 == 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1950190530 + (char)-17906, 1950190530 + (char)-17856, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1950190530 + (char)-17902, 1950190530 + (char)-15705, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1950190530 + (char)-17916, 1950190530 + (char)-21803, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 95468708108549L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                n3 = SshAgentIpcService.f();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 != 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-175109520 - -31727, -175109520 - -31517, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-175109520 - -31723, -175109520 - -((char)-31882), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-175109520 - -31704, -175109520 - -((char)-4828), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-175109520 - -31711, 175109520 - (char)-22002, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-175109520 - -31727, -175109520 - -31517, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-175109520 - -31723, -175109520 - -((char)-31882), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-175109520 - -31710, 175109520 - (char)-17995, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 != 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 != 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-175109520 - -31727, -175109520 - -31517, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-175109520 - -31723, -175109520 - -((char)-31882), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-175109520 - -31709, -175109520 - -((char)-26895), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-175109520 - -31727, -175109520 - -31517, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-175109520 - -31723, -175109520 - -((char)-31882), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-175109520 - -31708, -175109520 - -((char)-8941), (int)l2));
                    if (n3 != 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-175109520 - -31727, -175109520 - -31517, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-175109520 - -31723, -175109520 - -((char)-31882), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-175109520 - -31747, -175109520 - -((char)-17348), (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-175109520 - -31746, -175109520 - -((char)-11623), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u0090\u001d\u0086\u00bbq\u00ef\u00dc\u001d\u0014\u00df*W\u00ba\u00b5G\u00eb\u0012\u00e1-\n\u0007\u00ba\u00b5\b\u0015nK~\u00d9\u0006\u00b4\u0080\u0002\b\u008b\u00d8\u0018X!\u00c7\u00eb%\u00a8\u00fb/+\u00f7\\,\u0016/\u00cf\u00c4?\u0018z..jC#\t\u00ed\u00c4\u00ef\u00e6K\u0096.\u00a0\u00ad\u0005\u00c5\u00bd,\u00afT\b\u00196\u00b7\u00af\u0005KTk\u0014#\u0090\u00b0v$\u00d6\u00ec\u00b7oDp\u009e\u00bf%\u0013\u00ea\u001fg\u00a9\u001e\u0005g\u0091x*\u00de\u001e&\u0098Eo\u00e4\u00fca\u00df\u00dd\u00fd\u00c9\u00ea\u00e8\u00d7\u00b2\u00bfq\u00e6a\u0005\u00e1 \u00b6\u00a7\u00b7\u00f3Y\u00f1\u00a0\u0099\u0010Xcn\u00d5\u00d6\u0099\u00d1\u008a\u00b6\u00e5)\u0014\u00f2]^q\t[\u0081\u00ef_\u0018\u0086b=\u00ca\u0010\u00ed\u00cf\u00d8@\u0000+\u000b\u00dc\u00ed/BM\u009fv\u00f3\u0014?+r\u00ec2\u00dc^\u00e3\u00e7\u00fc+\u00a8\u00cb{\u0005\u00fd\u00dc]\u00ef\u0099\u00e1p\u00ee\u00ff\u0018\u008e\u00ecs\u00a6\u00d2%G\u00cb\u00c5\u0016,g\u000f\u009d\u00ab\u001f\u00ca\u0094V\u00cf1\u00e3e\u009b\u00d2-\u0005\u0011\u00f3\u00d2\u00f3\u00d6aZ\u00e6\u000e\u00dd\u00d9\u00a0\b.#Q\r\u00d9\u001f\u00cf\u00e1\f\u0088J\u0095;\\\u00bb\u0091r\u0097\u00b2_\u00faF\u0098\u00a0\u0097f\u001c\u0010\u0099\u0007\u0096\u0010ujV9G}\u00f6\u00bc\u00ec$\u00cc\u0004kw**\u0014u\u0081v\u0017\u009d\u00f3j(\u00c9U\u0005K\u00c8E{,\u00c9\u00a0\u00a6\u0003N\u00f9o\u0006\u00f3|\u0018\u0014\u0094\u0002f\u001c5\u00b1\u00d7q\u00d5\u001e\u0084c\u009ev.\u001f]\u00bb*\u000b\tp\u00dcNj\u00cf?\u00ac6\u0002b\u00b4\u0010o0\u00fe\u0000\u00df]\u00f3\u00ab\u00a9\u00cdv/\u0098\u00c0\u000bfjH?\u00e7;\u00e6by\u00bc\u0088\u0015\u00ec)\u0019T\u00ca>\u00af\u00bfn\u00e7\u00a2b;w\u00deL|\u00e4`\u00f6<)\u008e\u00d4P\u00e6F\u00cd5\u00f9W9\u0098r\u00c6\u00d3\u00e2\u008b_\u0000\u0002\u00b4\u00b6\u00eeM\u00cd\u00c6'\u00b7\u00dfOYNF&\u00b4\u00f4\u009f\u00d0\u00d2p\u009b\u0081\u0007\u00a4B\u001f.\u008b\u0089\u0017\u0007\u0010\u000f\u00ed\u00eb2\u00de6(\u00ad\u0007x\u00bd\u00f3\u00ccu\u00fe/\u000e\u00bd\u00a2AHP{\u000e\u00b3\u0086\u0081Gv\u001c\u0015|\u0080VPD\u00c8\u00f4m\u008a\u00ba\u00ff\u00f3\u000b\"\u0098v\u000f\u00cd\u00d8:oS\u00fa\u00c4\u00fbl#tV\u00d8\u0082\u00fd\"\u00b1\u0092\u00b7.\u00ba\u00d4\u00aa\u00da\u00a4]\u00e6\u00fe\nN\u001f\u00f6\u000b\u0086\u0002&\\\u00bc\u00b0\u00d7\u00ea0\u00ff\u00e3b\u00ecI\u00f7\u00e8q\u000e\u00fc\u0085\u001c\u00c4\u0097\u008f\\U\u007f\u00f6\u0016\u00ec\u0098\u00df\u001b:\u00b9\u00c3F\u0097j\u00c9\u00b5\u009am'\u009e\u00ee\u00a7\u00a5\u00dd\u00f4I@C/$\u00adb\u0002\u00eb\u00b7\n\u00e6\u009d\u009c\u00c5h\u00fe\u00e5\r\u00b4\u0018\u0018K\u0091\u00edNS\u00d7p\\\u00b3\u0099\u00c0\u009f\u00ab\u00d4\u00f1\u0092\t\u00a1('Z\u00e3X\u00c9)x\u00f2\u008e\"\u009dUN\u00ea8[u>\u007fSJ\u00e04\u0018\u00b0r\u00da&\u0089\u00d8+\u0017\u00975\u0018X\u001f\u00f7)\\\u00c0\u0016\u0088\u00c7{9\u00e0\tm\u00c3)\t\u00ca\u0083n\u00c6\u00f6";
                var4_3 = "\u0090\u001d\u0086\u00bbq\u00ef\u00dc\u001d\u0014\u00df*W\u00ba\u00b5G\u00eb\u0012\u00e1-\n\u0007\u00ba\u00b5\b\u0015nK~\u00d9\u0006\u00b4\u0080\u0002\b\u008b\u00d8\u0018X!\u00c7\u00eb%\u00a8\u00fb/+\u00f7\\,\u0016/\u00cf\u00c4?\u0018z..jC#\t\u00ed\u00c4\u00ef\u00e6K\u0096.\u00a0\u00ad\u0005\u00c5\u00bd,\u00afT\b\u00196\u00b7\u00af\u0005KTk\u0014#\u0090\u00b0v$\u00d6\u00ec\u00b7oDp\u009e\u00bf%\u0013\u00ea\u001fg\u00a9\u001e\u0005g\u0091x*\u00de\u001e&\u0098Eo\u00e4\u00fca\u00df\u00dd\u00fd\u00c9\u00ea\u00e8\u00d7\u00b2\u00bfq\u00e6a\u0005\u00e1 \u00b6\u00a7\u00b7\u00f3Y\u00f1\u00a0\u0099\u0010Xcn\u00d5\u00d6\u0099\u00d1\u008a\u00b6\u00e5)\u0014\u00f2]^q\t[\u0081\u00ef_\u0018\u0086b=\u00ca\u0010\u00ed\u00cf\u00d8@\u0000+\u000b\u00dc\u00ed/BM\u009fv\u00f3\u0014?+r\u00ec2\u00dc^\u00e3\u00e7\u00fc+\u00a8\u00cb{\u0005\u00fd\u00dc]\u00ef\u0099\u00e1p\u00ee\u00ff\u0018\u008e\u00ecs\u00a6\u00d2%G\u00cb\u00c5\u0016,g\u000f\u009d\u00ab\u001f\u00ca\u0094V\u00cf1\u00e3e\u009b\u00d2-\u0005\u0011\u00f3\u00d2\u00f3\u00d6aZ\u00e6\u000e\u00dd\u00d9\u00a0\b.#Q\r\u00d9\u001f\u00cf\u00e1\f\u0088J\u0095;\\\u00bb\u0091r\u0097\u00b2_\u00faF\u0098\u00a0\u0097f\u001c\u0010\u0099\u0007\u0096\u0010ujV9G}\u00f6\u00bc\u00ec$\u00cc\u0004kw**\u0014u\u0081v\u0017\u009d\u00f3j(\u00c9U\u0005K\u00c8E{,\u00c9\u00a0\u00a6\u0003N\u00f9o\u0006\u00f3|\u0018\u0014\u0094\u0002f\u001c5\u00b1\u00d7q\u00d5\u001e\u0084c\u009ev.\u001f]\u00bb*\u000b\tp\u00dcNj\u00cf?\u00ac6\u0002b\u00b4\u0010o0\u00fe\u0000\u00df]\u00f3\u00ab\u00a9\u00cdv/\u0098\u00c0\u000bfjH?\u00e7;\u00e6by\u00bc\u0088\u0015\u00ec)\u0019T\u00ca>\u00af\u00bfn\u00e7\u00a2b;w\u00deL|\u00e4`\u00f6<)\u008e\u00d4P\u00e6F\u00cd5\u00f9W9\u0098r\u00c6\u00d3\u00e2\u008b_\u0000\u0002\u00b4\u00b6\u00eeM\u00cd\u00c6'\u00b7\u00dfOYNF&\u00b4\u00f4\u009f\u00d0\u00d2p\u009b\u0081\u0007\u00a4B\u001f.\u008b\u0089\u0017\u0007\u0010\u000f\u00ed\u00eb2\u00de6(\u00ad\u0007x\u00bd\u00f3\u00ccu\u00fe/\u000e\u00bd\u00a2AHP{\u000e\u00b3\u0086\u0081Gv\u001c\u0015|\u0080VPD\u00c8\u00f4m\u008a\u00ba\u00ff\u00f3\u000b\"\u0098v\u000f\u00cd\u00d8:oS\u00fa\u00c4\u00fbl#tV\u00d8\u0082\u00fd\"\u00b1\u0092\u00b7.\u00ba\u00d4\u00aa\u00da\u00a4]\u00e6\u00fe\nN\u001f\u00f6\u000b\u0086\u0002&\\\u00bc\u00b0\u00d7\u00ea0\u00ff\u00e3b\u00ecI\u00f7\u00e8q\u000e\u00fc\u0085\u001c\u00c4\u0097\u008f\\U\u007f\u00f6\u0016\u00ec\u0098\u00df\u001b:\u00b9\u00c3F\u0097j\u00c9\u00b5\u009am'\u009e\u00ee\u00a7\u00a5\u00dd\u00f4I@C/$\u00adb\u0002\u00eb\u00b7\n\u00e6\u009d\u009c\u00c5h\u00fe\u00e5\r\u00b4\u0018\u0018K\u0091\u00edNS\u00d7p\\\u00b3\u0099\u00c0\u009f\u00ab\u00d4\u00f1\u0092\t\u00a1('Z\u00e3X\u00c9)x\u00f2\u008e\"\u009dUN\u00ea8[u>\u007fSJ\u00e04\u0018\u00b0r\u00da&\u0089\u00d8+\u0017\u00975\u0018X\u001f\u00f7)\\\u00c0\u0016\u0088\u00c7{9\u00e0\tm\u00c3)\t\u00ca\u0083n\u00c6\u00f6".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 91;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00e84`\u0006\u00bc-\u0096\u0019\u00df\u00d9u\u0092\u0083:)1\u00a4\u00d2\u000eS\u00a4\u00c1I\u0006d,\u0013\u00eb\u00e4\u0014\u000bh1\u000e\u0085-\u0011\u00a3B\u00e7\u0082\u00a2W\u00fdI\u00e0\u00ba\t\u0018m";
                    var4_3 = "\u00e84`\u0006\u00bc-\u0096\u0019\u00df\u00d9u\u0092\u0083:)1\u00a4\u00d2\u000eS\u00a4\u00c1I\u0006d,\u0013\u00eb\u00e4\u0014\u000bh1\u000e\u0085-\u0011\u00a3B\u00e7\u0082\u00a2W\u00fdI\u00e0\u00ba\t\u0018m".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 68;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 117;
                            break;
                        }
                        case 1: {
                            v15 = 73;
                            break;
                        }
                        case 2: {
                            v15 = 4;
                            break;
                        }
                        case 3: {
                            v15 = 32;
                            break;
                        }
                        case 4: {
                            v15 = 63;
                            break;
                        }
                        case 5: {
                            v15 = 4;
                            break;
                        }
                        default: {
                            v15 = 11;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFF9F56) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 197;
                case 1 -> 22;
                case 2 -> 11;
                case 3 -> 70;
                case 4 -> 65;
                case 5 -> 58;
                case 6 -> 29;
                case 7 -> 196;
                case 8 -> 202;
                case 9 -> 41;
                case 10 -> 178;
                case 11 -> 132;
                case 12 -> 9;
                case 13 -> 98;
                case 14 -> 32;
                case 15 -> 204;
                case 16 -> 167;
                case 17 -> 152;
                case 18 -> 201;
                case 19 -> 28;
                case 20 -> 99;
                case 21 -> 126;
                case 22 -> 0;
                case 23 -> 222;
                case 24 -> 67;
                case 25 -> 17;
                case 26 -> 233;
                case 27 -> 93;
                case 28 -> 5;
                case 29 -> 121;
                case 30 -> 147;
                case 31 -> 75;
                case 32 -> 104;
                case 33 -> 185;
                case 34 -> 231;
                case 35 -> 252;
                case 36 -> 44;
                case 37 -> 89;
                case 38 -> 182;
                case 39 -> 7;
                case 40 -> 149;
                case 41 -> 26;
                case 42 -> 8;
                case 43 -> 124;
                case 44 -> 194;
                case 45 -> 131;
                case 46 -> 120;
                case 47 -> 253;
                case 48 -> 61;
                case 49 -> 155;
                case 50 -> 164;
                case 51 -> 225;
                case 52 -> 1;
                case 53 -> 55;
                case 54 -> 235;
                case 55 -> 52;
                case 56 -> 30;
                case 57 -> 23;
                case 58 -> 153;
                case 59 -> 107;
                case 60 -> 19;
                case 61 -> 171;
                case 62 -> 43;
                case 63 -> 97;
                case 64 -> 80;
                case 65 -> 6;
                case 66 -> 66;
                case 67 -> 13;
                case 68 -> 176;
                case 69 -> 138;
                case 70 -> 68;
                case 71 -> 2;
                case 72 -> 91;
                case 73 -> 170;
                case 74 -> 243;
                case 75 -> 27;
                case 76 -> 106;
                case 77 -> 168;
                case 78 -> 159;
                case 79 -> 31;
                case 80 -> 108;
                case 81 -> 118;
                case 82 -> 81;
                case 83 -> 100;
                case 84 -> 47;
                case 85 -> 192;
                case 86 -> 248;
                case 87 -> 77;
                case 88 -> 251;
                case 89 -> 33;
                case 90 -> 187;
                case 91 -> 88;
                case 92 -> 69;
                case 93 -> 234;
                case 94 -> 206;
                case 95 -> 123;
                case 96 -> 247;
                case 97 -> 3;
                case 98 -> 72;
                case 99 -> 229;
                case 100 -> 154;
                case 101 -> 127;
                case 102 -> 128;
                case 103 -> 125;
                case 104 -> 141;
                case 105 -> 119;
                case 106 -> 35;
                case 107 -> 156;
                case 108 -> 249;
                case 109 -> 237;
                case 110 -> 150;
                case 111 -> 214;
                case 112 -> 37;
                case 113 -> 4;
                case 114 -> 245;
                case 115 -> 177;
                case 116 -> 175;
                case 117 -> 133;
                case 118 -> 78;
                case 119 -> 50;
                case 120 -> 90;
                case 121 -> 122;
                case 122 -> 12;
                case 123 -> 14;
                case 124 -> 56;
                case 125 -> 59;
                case 126 -> 203;
                case 127 -> 48;
                case 128 -> 188;
                case 129 -> 193;
                case 130 -> 226;
                case 131 -> 134;
                case 132 -> 84;
                case 133 -> 79;
                case 134 -> 20;
                case 135 -> 244;
                case 136 -> 148;
                case 137 -> 145;
                case 138 -> 221;
                case 139 -> 180;
                case 140 -> 38;
                case 141 -> 96;
                case 142 -> 36;
                case 143 -> 101;
                case 144 -> 18;
                case 145 -> 16;
                case 146 -> 217;
                case 147 -> 40;
                case 148 -> 158;
                case 149 -> 51;
                case 150 -> 137;
                case 151 -> 215;
                case 152 -> 183;
                case 153 -> 86;
                case 154 -> 64;
                case 155 -> 42;
                case 156 -> 211;
                case 157 -> 254;
                case 158 -> 49;
                case 159 -> 45;
                case 160 -> 242;
                case 161 -> 224;
                case 162 -> 82;
                case 163 -> 162;
                case 164 -> 15;
                case 165 -> 181;
                case 166 -> 117;
                case 167 -> 115;
                case 168 -> 179;
                case 169 -> 199;
                case 170 -> 21;
                case 171 -> 218;
                case 172 -> 25;
                case 173 -> 208;
                case 174 -> 207;
                case 175 -> 161;
                case 176 -> 109;
                case 177 -> 151;
                case 178 -> 130;
                case 179 -> 173;
                case 180 -> 240;
                case 181 -> 212;
                case 182 -> 10;
                case 183 -> 223;
                case 184 -> 87;
                case 185 -> 186;
                case 186 -> 103;
                case 187 -> 157;
                case 188 -> 160;
                case 189 -> 236;
                case 190 -> 112;
                case 191 -> 63;
                case 192 -> 139;
                case 193 -> 136;
                case 194 -> 184;
                case 195 -> 228;
                case 196 -> 227;
                case 197 -> 129;
                case 198 -> 230;
                case 199 -> 238;
                case 200 -> 163;
                case 201 -> 114;
                case 202 -> 220;
                case 203 -> 143;
                case 204 -> 34;
                case 205 -> 189;
                case 206 -> 140;
                case 207 -> 195;
                case 208 -> 205;
                case 209 -> 24;
                case 210 -> 53;
                case 211 -> 216;
                case 212 -> 209;
                case 213 -> 113;
                case 214 -> 83;
                case 215 -> 144;
                case 216 -> 142;
                case 217 -> 198;
                case 218 -> 60;
                case 219 -> 110;
                case 220 -> 135;
                case 221 -> 219;
                case 222 -> 165;
                case 223 -> 172;
                case 224 -> 246;
                case 225 -> 73;
                case 226 -> 210;
                case 227 -> 94;
                case 228 -> 174;
                case 229 -> 92;
                case 230 -> 213;
                case 231 -> 62;
                case 232 -> 95;
                case 233 -> 116;
                case 234 -> 250;
                case 235 -> 255;
                case 236 -> 239;
                case 237 -> 39;
                case 238 -> 57;
                case 239 -> 241;
                case 240 -> 200;
                case 241 -> 71;
                case 242 -> 102;
                case 243 -> 190;
                case 244 -> 191;
                case 245 -> 105;
                case 246 -> 74;
                case 247 -> 169;
                case 248 -> 46;
                case 249 -> 76;
                case 250 -> 111;
                case 251 -> 146;
                case 252 -> 54;
                case 253 -> 85;
                case 254 -> 232;
                default -> 166;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 96506325576442L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1589616960 - (char)-20205, 1589616960 - (char)-1925, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 42225627040874L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.f();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 != 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 != 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1803523200 + -((char)-27452), 1803523200 + (char)-6011, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1803523200 + -((char)-27455), 1803523200 + (char)-12914, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1803523200 + -((char)-27454), -1803523200 + -((char)-20252), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "PN\u00cb\u009c\u0012\u0004\u00db\u009f\u0010d,\u00bcqF\u0002\u00a8\u0006\u00b6!dFT|uz";
                    var4_3 = "PN\u00cb\u009c\u0012\u0004\u00db\u009f\u0010d,\u00bcqF\u0002\u00a8\u0006\u00b6!dFT|uz".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 97;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0087\u00e4C\u00bb\u00015|\u00e2+\u0017\u00de\u0085\u00d1/\u009c\u00cd\u00c1ie\u0001$-_'\u00f6\u0014\u0098X\u0013\u00bdMOi\u00e1\u008c\u00a0z\u0003&\u00ceM\u00b0\u00bbjF2\u00ba\u0007B\b\u00c1\u00cf1\u00f1\u00f5\u001b\u00af\u00d5\u00dc";
                        var4_3 = "\u0087\u00e4C\u00bb\u00015|\u00e2+\u0017\u00de\u0085\u00d1/\u009c\u00cd\u00c1ie\u0001$-_'\u00f6\u0014\u0098X\u0013\u00bdMOi\u00e1\u008c\u00a0z\u0003&\u00ceM\u00b0\u00bbjF2\u00ba\u0007B\b\u00c1\u00cf1\u00f1\u00f5\u001b\u00af\u00d5\u00dc".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 56;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 85;
                                break;
                            }
                            case 1: {
                                v15 = 17;
                                break;
                            }
                            case 2: {
                                v15 = 40;
                                break;
                            }
                            case 3: {
                                v15 = 27;
                                break;
                            }
                            case 4: {
                                v15 = 13;
                                break;
                            }
                            case 5: {
                                v15 = 17;
                                break;
                            }
                            default: {
                                v15 = 91;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFDAD7) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 85;
                    case 1 -> 112;
                    case 2 -> 20;
                    case 3 -> 204;
                    case 4 -> 125;
                    case 5 -> 37;
                    case 6 -> 193;
                    case 7 -> 156;
                    case 8 -> 135;
                    case 9 -> 35;
                    case 10 -> 137;
                    case 11 -> 143;
                    case 12 -> 178;
                    case 13 -> 4;
                    case 14 -> 119;
                    case 15 -> 209;
                    case 16 -> 145;
                    case 17 -> 203;
                    case 18 -> 118;
                    case 19 -> 54;
                    case 20 -> 51;
                    case 21 -> 155;
                    case 22 -> 89;
                    case 23 -> 177;
                    case 24 -> 36;
                    case 25 -> 213;
                    case 26 -> 38;
                    case 27 -> 41;
                    case 28 -> 159;
                    case 29 -> 102;
                    case 30 -> 17;
                    case 31 -> 247;
                    case 32 -> 22;
                    case 33 -> 127;
                    case 34 -> 243;
                    case 35 -> 49;
                    case 36 -> 131;
                    case 37 -> 229;
                    case 38 -> 26;
                    case 39 -> 254;
                    case 40 -> 228;
                    case 41 -> 78;
                    case 42 -> 121;
                    case 43 -> 237;
                    case 44 -> 123;
                    case 45 -> 11;
                    case 46 -> 93;
                    case 47 -> 69;
                    case 48 -> 188;
                    case 49 -> 58;
                    case 50 -> 210;
                    case 51 -> 99;
                    case 52 -> 18;
                    case 53 -> 50;
                    case 54 -> 219;
                    case 55 -> 73;
                    case 56 -> 166;
                    case 57 -> 239;
                    case 58 -> 100;
                    case 59 -> 192;
                    case 60 -> 246;
                    case 61 -> 95;
                    case 62 -> 255;
                    case 63 -> 29;
                    case 64 -> 181;
                    case 65 -> 67;
                    case 66 -> 33;
                    case 67 -> 154;
                    case 68 -> 80;
                    case 69 -> 117;
                    case 70 -> 86;
                    case 71 -> 169;
                    case 72 -> 205;
                    case 73 -> 249;
                    case 74 -> 195;
                    case 75 -> 116;
                    case 76 -> 84;
                    case 77 -> 163;
                    case 78 -> 42;
                    case 79 -> 92;
                    case 80 -> 56;
                    case 81 -> 240;
                    case 82 -> 233;
                    case 83 -> 217;
                    case 84 -> 111;
                    case 85 -> 120;
                    case 86 -> 45;
                    case 87 -> 24;
                    case 88 -> 211;
                    case 89 -> 230;
                    case 90 -> 65;
                    case 91 -> 179;
                    case 92 -> 170;
                    case 93 -> 74;
                    case 94 -> 206;
                    case 95 -> 104;
                    case 96 -> 106;
                    case 97 -> 64;
                    case 98 -> 241;
                    case 99 -> 21;
                    case 100 -> 43;
                    case 101 -> 161;
                    case 102 -> 15;
                    case 103 -> 25;
                    case 104 -> 91;
                    case 105 -> 16;
                    case 106 -> 134;
                    case 107 -> 28;
                    case 108 -> 115;
                    case 109 -> 103;
                    case 110 -> 150;
                    case 111 -> 139;
                    case 112 -> 5;
                    case 113 -> 98;
                    case 114 -> 251;
                    case 115 -> 234;
                    case 116 -> 30;
                    case 117 -> 171;
                    case 118 -> 90;
                    case 119 -> 13;
                    case 120 -> 142;
                    case 121 -> 6;
                    case 122 -> 72;
                    case 123 -> 172;
                    case 124 -> 107;
                    case 125 -> 46;
                    case 126 -> 227;
                    case 127 -> 76;
                    case 128 -> 149;
                    case 129 -> 242;
                    case 130 -> 108;
                    case 131 -> 23;
                    case 132 -> 61;
                    case 133 -> 173;
                    case 134 -> 168;
                    case 135 -> 198;
                    case 136 -> 244;
                    case 137 -> 88;
                    case 138 -> 7;
                    case 139 -> 114;
                    case 140 -> 52;
                    case 141 -> 207;
                    case 142 -> 40;
                    case 143 -> 189;
                    case 144 -> 197;
                    case 145 -> 200;
                    case 146 -> 12;
                    case 147 -> 160;
                    case 148 -> 83;
                    case 149 -> 222;
                    case 150 -> 122;
                    case 151 -> 218;
                    case 152 -> 96;
                    case 153 -> 190;
                    case 154 -> 215;
                    case 155 -> 101;
                    case 156 -> 232;
                    case 157 -> 186;
                    case 158 -> 138;
                    case 159 -> 176;
                    case 160 -> 129;
                    case 161 -> 48;
                    case 162 -> 183;
                    case 163 -> 97;
                    case 164 -> 236;
                    case 165 -> 133;
                    case 166 -> 8;
                    case 167 -> 151;
                    case 168 -> 55;
                    case 169 -> 1;
                    case 170 -> 148;
                    case 171 -> 3;
                    case 172 -> 57;
                    case 173 -> 252;
                    case 174 -> 14;
                    case 175 -> 31;
                    case 176 -> 153;
                    case 177 -> 94;
                    case 178 -> 68;
                    case 179 -> 2;
                    case 180 -> 187;
                    case 181 -> 128;
                    case 182 -> 194;
                    case 183 -> 113;
                    case 184 -> 224;
                    case 185 -> 157;
                    case 186 -> 235;
                    case 187 -> 199;
                    case 188 -> 226;
                    case 189 -> 44;
                    case 190 -> 130;
                    case 191 -> 87;
                    case 192 -> 212;
                    case 193 -> 147;
                    case 194 -> 70;
                    case 195 -> 152;
                    case 196 -> 180;
                    case 197 -> 175;
                    case 198 -> 250;
                    case 199 -> 110;
                    case 200 -> 165;
                    case 201 -> 132;
                    case 202 -> 223;
                    case 203 -> 32;
                    case 204 -> 185;
                    case 205 -> 238;
                    case 206 -> 167;
                    case 207 -> 75;
                    case 208 -> 214;
                    case 209 -> 9;
                    case 210 -> 105;
                    case 211 -> 34;
                    case 212 -> 141;
                    case 213 -> 82;
                    case 214 -> 19;
                    case 215 -> 191;
                    case 216 -> 248;
                    case 217 -> 245;
                    case 218 -> 71;
                    case 219 -> 231;
                    case 220 -> 164;
                    case 221 -> 182;
                    case 222 -> 146;
                    case 223 -> 196;
                    case 224 -> 216;
                    case 225 -> 124;
                    case 226 -> 53;
                    case 227 -> 184;
                    case 228 -> 174;
                    case 229 -> 0;
                    case 230 -> 126;
                    case 231 -> 62;
                    case 232 -> 162;
                    case 233 -> 140;
                    case 234 -> 202;
                    case 235 -> 81;
                    case 236 -> 208;
                    case 237 -> 225;
                    case 238 -> 79;
                    case 239 -> 220;
                    case 240 -> 109;
                    case 241 -> 158;
                    case 242 -> 10;
                    case 243 -> 60;
                    case 244 -> 47;
                    case 245 -> 66;
                    case 246 -> 59;
                    case 247 -> 253;
                    case 248 -> 27;
                    case 249 -> 201;
                    case 250 -> 136;
                    case 251 -> 39;
                    case 252 -> 144;
                    case 253 -> 77;
                    case 254 -> 221;
                    default -> 63;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 37274569893192L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "y\u0007{\b}D\u000f \t~\rh\u00020\u0006\u0012<K";
                    var5_4 = "y\u0007{\b}D\u000f \t~\rh\u00020\u0006\u0012<K".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 33;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 51;
                                    break;
                                }
                                case 1: {
                                    v11 = 67;
                                    break;
                                }
                                case 2: {
                                    v11 = 40;
                                    break;
                                }
                                case 3: {
                                    v11 = 71;
                                    break;
                                }
                                case 4: {
                                    v11 = 57;
                                    break;
                                }
                                case 5: {
                                    v11 = 9;
                                    break;
                                }
                                default: {
                                    v11 = 29;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 110024889536997L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "0r\tHM\u000b\u0007\u00046l\u0005R\n:s\u000eRA\t\u001f\u0010r\u0007\t:s\u000eRA\t\u001f\u001cx\r=u\u0013_K\u0004\u0005\u001c\u007f\u0014UJ\r";
                    var5_4 = "0r\tHM\u000b\u0007\u00046l\u0005R\n:s\u000eRA\t\u001f\u0010r\u0007\t:s\u000eRA\t\u001f\u001cx\r=u\u0013_K\u0004\u0005\u001c\u007f\u0014UJ\r".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 123;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "x2M\r\u000fFN\u0006x2M\r\u0003L";
                        var5_4 = "x2M\r\u000fFN\u0006x2M\r\u0003L".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 57;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 2;
                                break;
                            }
                            case 1: {
                                v15 = 103;
                                break;
                            }
                            case 2: {
                                v15 = 27;
                                break;
                            }
                            case 3: {
                                v15 = 71;
                                break;
                            }
                            case 4: {
                                v15 = 95;
                                break;
                            }
                            case 5: {
                                v15 = 17;
                                break;
                            }
                            default: {
                                v15 = 16;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 74055471540771L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1645452780 - -((char)-25964), -1645452780 - -((char)-31171), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 102638205638283L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "k\u00d4\u00db\u00df\u0082\u0003x\u00f0\r\u0005{\u001e\u00ffB\u00e5\r\u00f3p\u00d8\u00c5\u00f4\u0099\u00b2\u00a2\u00b9`\u00b2\"\u00f0\u0010\u0086\u00ba\u00b1w\u00e6Z\u00db\u00e7]L\u00cd\u00ea\u00f9\u008e*\u00a1\u0005\u00cdu)/?3\u00e7\u0002}\u00b6\u00aa&b|\u0017\u00c2\u000f\u0012g\u00c0\u00d5wr\u00d1W \u001e@R\u0015\b\u00b6\u00c2\u009d\u00dfl\faZ\u00ce7C\u00f9u\u0018\u00a8\u0006\u001b\\NP\u00d3\u001e\u00b2\u008c\u00db\u0087";
                    var4_3 = "k\u00d4\u00db\u00df\u0082\u0003x\u00f0\r\u0005{\u001e\u00ffB\u00e5\r\u00f3p\u00d8\u00c5\u00f4\u0099\u00b2\u00a2\u00b9`\u00b2\"\u00f0\u0010\u0086\u00ba\u00b1w\u00e6Z\u00db\u00e7]L\u00cd\u00ea\u00f9\u008e*\u00a1\u0005\u00cdu)/?3\u00e7\u0002}\u00b6\u00aa&b|\u0017\u00c2\u000f\u0012g\u00c0\u00d5wr\u00d1W \u001e@R\u0015\b\u00b6\u00c2\u009d\u00dfl\faZ\u00ce7C\u00f9u\u0018\u00a8\u0006\u001b\\NP\u00d3\u001e\u00b2\u008c\u00db\u0087".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 116;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00f5\n\u00f4Je\u00d6\u0080]\u001d0\u00eeN\u00b61\u00e8}L\u00d3*\u00c7\u0084)\u00c7g\u0011h*\u00ec\u00b4\u00f8\u00e0\u00b2>\u00b0\u0002\u00db\u0087\u00cc\u00fb\t\u00ebk\u00a9\u00a0\u0093B\u00cf{Q\u008f\r\u00d7\f\u00fci\u00a9f-\u0014\u00dd\u00f9^\u00d0?\u00c1q\u00aa\u00fb\u007f\u00b1&\u00f8\u009d:fm\u0002x\u009c\u009b\u00f7\u00b7\u00ef\u001er\u00cc\u00c3b\u008aE\u00abh%";
                        var4_3 = "\u00f5\n\u00f4Je\u00d6\u0080]\u001d0\u00eeN\u00b61\u00e8}L\u00d3*\u00c7\u0084)\u00c7g\u0011h*\u00ec\u00b4\u00f8\u00e0\u00b2>\u00b0\u0002\u00db\u0087\u00cc\u00fb\t\u00ebk\u00a9\u00a0\u0093B\u00cf{Q\u008f\r\u00d7\f\u00fci\u00a9f-\u0014\u00dd\u00f9^\u00d0?\u00c1q\u00aa\u00fb\u007f\u00b1&\u00f8\u009d:fm\u0002x\u009c\u009b\u00f7\u00b7\u00ef\u001er\u00cc\u00c3b\u008aE\u00abh%".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 55;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 72;
                                break;
                            }
                            case 1: {
                                v15 = 65;
                                break;
                            }
                            case 2: {
                                v15 = 109;
                                break;
                            }
                            case 3: {
                                v15 = 114;
                                break;
                            }
                            case 4: {
                                v15 = 19;
                                break;
                            }
                            case 5: {
                                v15 = 19;
                                break;
                            }
                            default: {
                                v15 = 72;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFD68B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 165;
                    case 1 -> 84;
                    case 2 -> 79;
                    case 3 -> 151;
                    case 4 -> 74;
                    case 5 -> 110;
                    case 6 -> 53;
                    case 7 -> 69;
                    case 8 -> 223;
                    case 9 -> 118;
                    case 10 -> 123;
                    case 11 -> 19;
                    case 12 -> 164;
                    case 13 -> 22;
                    case 14 -> 207;
                    case 15 -> 233;
                    case 16 -> 85;
                    case 17 -> 166;
                    case 18 -> 230;
                    case 19 -> 226;
                    case 20 -> 153;
                    case 21 -> 251;
                    case 22 -> 39;
                    case 23 -> 248;
                    case 24 -> 55;
                    case 25 -> 0;
                    case 26 -> 112;
                    case 27 -> 100;
                    case 28 -> 224;
                    case 29 -> 18;
                    case 30 -> 150;
                    case 31 -> 232;
                    case 32 -> 201;
                    case 33 -> 192;
                    case 34 -> 50;
                    case 35 -> 8;
                    case 36 -> 255;
                    case 37 -> 145;
                    case 38 -> 78;
                    case 39 -> 212;
                    case 40 -> 28;
                    case 41 -> 246;
                    case 42 -> 157;
                    case 43 -> 174;
                    case 44 -> 88;
                    case 45 -> 102;
                    case 46 -> 83;
                    case 47 -> 229;
                    case 48 -> 47;
                    case 49 -> 156;
                    case 50 -> 121;
                    case 51 -> 108;
                    case 52 -> 141;
                    case 53 -> 21;
                    case 54 -> 116;
                    case 55 -> 249;
                    case 56 -> 31;
                    case 57 -> 209;
                    case 58 -> 93;
                    case 59 -> 152;
                    case 60 -> 87;
                    case 61 -> 26;
                    case 62 -> 52;
                    case 63 -> 58;
                    case 64 -> 134;
                    case 65 -> 114;
                    case 66 -> 5;
                    case 67 -> 2;
                    case 68 -> 95;
                    case 69 -> 4;
                    case 70 -> 16;
                    case 71 -> 202;
                    case 72 -> 142;
                    case 73 -> 127;
                    case 74 -> 190;
                    case 75 -> 144;
                    case 76 -> 227;
                    case 77 -> 163;
                    case 78 -> 250;
                    case 79 -> 191;
                    case 80 -> 170;
                    case 81 -> 210;
                    case 82 -> 247;
                    case 83 -> 36;
                    case 84 -> 66;
                    case 85 -> 228;
                    case 86 -> 244;
                    case 87 -> 60;
                    case 88 -> 46;
                    case 89 -> 193;
                    case 90 -> 11;
                    case 91 -> 70;
                    case 92 -> 130;
                    case 93 -> 214;
                    case 94 -> 129;
                    case 95 -> 61;
                    case 96 -> 71;
                    case 97 -> 67;
                    case 98 -> 196;
                    case 99 -> 24;
                    case 100 -> 139;
                    case 101 -> 189;
                    case 102 -> 149;
                    case 103 -> 171;
                    case 104 -> 133;
                    case 105 -> 200;
                    case 106 -> 162;
                    case 107 -> 253;
                    case 108 -> 32;
                    case 109 -> 126;
                    case 110 -> 146;
                    case 111 -> 216;
                    case 112 -> 135;
                    case 113 -> 185;
                    case 114 -> 12;
                    case 115 -> 27;
                    case 116 -> 33;
                    case 117 -> 215;
                    case 118 -> 64;
                    case 119 -> 195;
                    case 120 -> 154;
                    case 121 -> 124;
                    case 122 -> 217;
                    case 123 -> 219;
                    case 124 -> 234;
                    case 125 -> 115;
                    case 126 -> 206;
                    case 127 -> 29;
                    case 128 -> 213;
                    case 129 -> 104;
                    case 130 -> 239;
                    case 131 -> 122;
                    case 132 -> 15;
                    case 133 -> 80;
                    case 134 -> 96;
                    case 135 -> 220;
                    case 136 -> 119;
                    case 137 -> 72;
                    case 138 -> 86;
                    case 139 -> 188;
                    case 140 -> 172;
                    case 141 -> 34;
                    case 142 -> 82;
                    case 143 -> 41;
                    case 144 -> 161;
                    case 145 -> 111;
                    case 146 -> 113;
                    case 147 -> 211;
                    case 148 -> 186;
                    case 149 -> 187;
                    case 150 -> 48;
                    case 151 -> 106;
                    case 152 -> 155;
                    case 153 -> 254;
                    case 154 -> 245;
                    case 155 -> 128;
                    case 156 -> 90;
                    case 157 -> 240;
                    case 158 -> 94;
                    case 159 -> 237;
                    case 160 -> 243;
                    case 161 -> 98;
                    case 162 -> 25;
                    case 163 -> 241;
                    case 164 -> 59;
                    case 165 -> 160;
                    case 166 -> 125;
                    case 167 -> 218;
                    case 168 -> 57;
                    case 169 -> 143;
                    case 170 -> 51;
                    case 171 -> 23;
                    case 172 -> 148;
                    case 173 -> 37;
                    case 174 -> 109;
                    case 175 -> 40;
                    case 176 -> 92;
                    case 177 -> 56;
                    case 178 -> 107;
                    case 179 -> 169;
                    case 180 -> 68;
                    case 181 -> 179;
                    case 182 -> 204;
                    case 183 -> 54;
                    case 184 -> 75;
                    case 185 -> 131;
                    case 186 -> 30;
                    case 187 -> 208;
                    case 188 -> 184;
                    case 189 -> 35;
                    case 190 -> 62;
                    case 191 -> 42;
                    case 192 -> 65;
                    case 193 -> 183;
                    case 194 -> 199;
                    case 195 -> 117;
                    case 196 -> 159;
                    case 197 -> 194;
                    case 198 -> 167;
                    case 199 -> 103;
                    case 200 -> 132;
                    case 201 -> 10;
                    case 202 -> 77;
                    case 203 -> 175;
                    case 204 -> 158;
                    case 205 -> 63;
                    case 206 -> 197;
                    case 207 -> 73;
                    case 208 -> 182;
                    case 209 -> 91;
                    case 210 -> 81;
                    case 211 -> 181;
                    case 212 -> 17;
                    case 213 -> 137;
                    case 214 -> 147;
                    case 215 -> 45;
                    case 216 -> 136;
                    case 217 -> 1;
                    case 218 -> 43;
                    case 219 -> 138;
                    case 220 -> 180;
                    case 221 -> 9;
                    case 222 -> 168;
                    case 223 -> 203;
                    case 224 -> 238;
                    case 225 -> 221;
                    case 226 -> 76;
                    case 227 -> 236;
                    case 228 -> 235;
                    case 229 -> 176;
                    case 230 -> 252;
                    case 231 -> 44;
                    case 232 -> 231;
                    case 233 -> 225;
                    case 234 -> 222;
                    case 235 -> 105;
                    case 236 -> 6;
                    case 237 -> 205;
                    case 238 -> 198;
                    case 239 -> 101;
                    case 240 -> 20;
                    case 241 -> 7;
                    case 242 -> 13;
                    case 243 -> 178;
                    case 244 -> 99;
                    case 245 -> 49;
                    case 246 -> 38;
                    case 247 -> 140;
                    case 248 -> 89;
                    case 249 -> 3;
                    case 250 -> 120;
                    case 251 -> 242;
                    case 252 -> 177;
                    case 253 -> 173;
                    case 254 -> 97;
                    default -> 14;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 134106265519921L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-206697390 - -23236, -206697390 - -18699, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 3335405706030L;
                    int n3 = SshAgentIpcService.f();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1783862700 + 25948, 1783862700 + 5767, (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 != 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 90465965514903L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00a8h\u0096?\u00ee\u0003rq\u009b";
                var4_3 = "\u00a8h\u0096?\u00ee\u0003rq\u009b".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 66;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 63;
                                break;
                            }
                            case 1: {
                                v11 = 87;
                                break;
                            }
                            case 2: {
                                v11 = 70;
                                break;
                            }
                            case 3: {
                                v11 = 55;
                                break;
                            }
                            case 4: {
                                v11 = 67;
                                break;
                            }
                            case 5: {
                                v11 = 13;
                                break;
                            }
                            default: {
                                v11 = 36;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFE027) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 100;
                    case 1 -> 129;
                    case 2 -> 154;
                    case 3 -> 28;
                    case 4 -> 150;
                    case 5 -> 23;
                    case 6 -> 193;
                    case 7 -> 194;
                    case 8 -> 198;
                    case 9 -> 186;
                    case 10 -> 69;
                    case 11 -> 41;
                    case 12 -> 118;
                    case 13 -> 65;
                    case 14 -> 203;
                    case 15 -> 161;
                    case 16 -> 238;
                    case 17 -> 117;
                    case 18 -> 127;
                    case 19 -> 141;
                    case 20 -> 92;
                    case 21 -> 160;
                    case 22 -> 124;
                    case 23 -> 210;
                    case 24 -> 199;
                    case 25 -> 128;
                    case 26 -> 3;
                    case 27 -> 53;
                    case 28 -> 185;
                    case 29 -> 130;
                    case 30 -> 25;
                    case 31 -> 121;
                    case 32 -> 230;
                    case 33 -> 255;
                    case 34 -> 8;
                    case 35 -> 240;
                    case 36 -> 169;
                    case 37 -> 136;
                    case 38 -> 95;
                    case 39 -> 80;
                    case 40 -> 190;
                    case 41 -> 217;
                    case 42 -> 11;
                    case 43 -> 91;
                    case 44 -> 182;
                    case 45 -> 44;
                    case 46 -> 247;
                    case 47 -> 195;
                    case 48 -> 77;
                    case 49 -> 73;
                    case 50 -> 104;
                    case 51 -> 187;
                    case 52 -> 245;
                    case 53 -> 209;
                    case 54 -> 200;
                    case 55 -> 168;
                    case 56 -> 180;
                    case 57 -> 228;
                    case 58 -> 226;
                    case 59 -> 155;
                    case 60 -> 93;
                    case 61 -> 153;
                    case 62 -> 192;
                    case 63 -> 146;
                    case 64 -> 189;
                    case 65 -> 188;
                    case 66 -> 216;
                    case 67 -> 148;
                    case 68 -> 139;
                    case 69 -> 164;
                    case 70 -> 108;
                    case 71 -> 26;
                    case 72 -> 85;
                    case 73 -> 196;
                    case 74 -> 253;
                    case 75 -> 61;
                    case 76 -> 58;
                    case 77 -> 208;
                    case 78 -> 211;
                    case 79 -> 109;
                    case 80 -> 32;
                    case 81 -> 252;
                    case 82 -> 30;
                    case 83 -> 16;
                    case 84 -> 2;
                    case 85 -> 7;
                    case 86 -> 112;
                    case 87 -> 5;
                    case 88 -> 254;
                    case 89 -> 19;
                    case 90 -> 165;
                    case 91 -> 38;
                    case 92 -> 231;
                    case 93 -> 119;
                    case 94 -> 59;
                    case 95 -> 221;
                    case 96 -> 56;
                    case 97 -> 204;
                    case 98 -> 134;
                    case 99 -> 122;
                    case 100 -> 45;
                    case 101 -> 229;
                    case 102 -> 173;
                    case 103 -> 123;
                    case 104 -> 131;
                    case 105 -> 9;
                    case 106 -> 67;
                    case 107 -> 64;
                    case 108 -> 97;
                    case 109 -> 34;
                    case 110 -> 6;
                    case 111 -> 132;
                    case 112 -> 47;
                    case 113 -> 83;
                    case 114 -> 249;
                    case 115 -> 223;
                    case 116 -> 219;
                    case 117 -> 12;
                    case 118 -> 37;
                    case 119 -> 54;
                    case 120 -> 133;
                    case 121 -> 63;
                    case 122 -> 166;
                    case 123 -> 239;
                    case 124 -> 142;
                    case 125 -> 49;
                    case 126 -> 244;
                    case 127 -> 242;
                    case 128 -> 183;
                    case 129 -> 22;
                    case 130 -> 143;
                    case 131 -> 76;
                    case 132 -> 99;
                    case 133 -> 236;
                    case 134 -> 225;
                    case 135 -> 94;
                    case 136 -> 72;
                    case 137 -> 140;
                    case 138 -> 201;
                    case 139 -> 116;
                    case 140 -> 156;
                    case 141 -> 13;
                    case 142 -> 1;
                    case 143 -> 159;
                    case 144 -> 111;
                    case 145 -> 43;
                    case 146 -> 90;
                    case 147 -> 167;
                    case 148 -> 163;
                    case 149 -> 31;
                    case 150 -> 70;
                    case 151 -> 218;
                    case 152 -> 205;
                    case 153 -> 158;
                    case 154 -> 68;
                    case 155 -> 48;
                    case 156 -> 102;
                    case 157 -> 78;
                    case 158 -> 175;
                    case 159 -> 212;
                    case 160 -> 87;
                    case 161 -> 181;
                    case 162 -> 113;
                    case 163 -> 138;
                    case 164 -> 179;
                    case 165 -> 74;
                    case 166 -> 51;
                    case 167 -> 24;
                    case 168 -> 246;
                    case 169 -> 151;
                    case 170 -> 33;
                    case 171 -> 60;
                    case 172 -> 243;
                    case 173 -> 191;
                    case 174 -> 81;
                    case 175 -> 147;
                    case 176 -> 114;
                    case 177 -> 125;
                    case 178 -> 220;
                    case 179 -> 157;
                    case 180 -> 213;
                    case 181 -> 176;
                    case 182 -> 36;
                    case 183 -> 215;
                    case 184 -> 17;
                    case 185 -> 197;
                    case 186 -> 71;
                    case 187 -> 105;
                    case 188 -> 96;
                    case 189 -> 46;
                    case 190 -> 15;
                    case 191 -> 20;
                    case 192 -> 75;
                    case 193 -> 171;
                    case 194 -> 14;
                    case 195 -> 145;
                    case 196 -> 232;
                    case 197 -> 115;
                    case 198 -> 233;
                    case 199 -> 149;
                    case 200 -> 103;
                    case 201 -> 107;
                    case 202 -> 241;
                    case 203 -> 137;
                    case 204 -> 135;
                    case 205 -> 39;
                    case 206 -> 237;
                    case 207 -> 10;
                    case 208 -> 57;
                    case 209 -> 21;
                    case 210 -> 40;
                    case 211 -> 206;
                    case 212 -> 42;
                    case 213 -> 184;
                    case 214 -> 224;
                    case 215 -> 29;
                    case 216 -> 101;
                    case 217 -> 174;
                    case 218 -> 79;
                    case 219 -> 88;
                    case 220 -> 98;
                    case 221 -> 170;
                    case 222 -> 62;
                    case 223 -> 18;
                    case 224 -> 50;
                    case 225 -> 120;
                    case 226 -> 84;
                    case 227 -> 86;
                    case 228 -> 162;
                    case 229 -> 55;
                    case 230 -> 0;
                    case 231 -> 177;
                    case 232 -> 27;
                    case 233 -> 152;
                    case 234 -> 251;
                    case 235 -> 66;
                    case 236 -> 207;
                    case 237 -> 178;
                    case 238 -> 248;
                    case 239 -> 235;
                    case 240 -> 250;
                    case 241 -> 126;
                    case 242 -> 52;
                    case 243 -> 82;
                    case 244 -> 144;
                    case 245 -> 4;
                    case 246 -> 214;
                    case 247 -> 89;
                    case 248 -> 227;
                    case 249 -> 35;
                    case 250 -> 110;
                    case 251 -> 106;
                    case 252 -> 172;
                    case 253 -> 234;
                    case 254 -> 222;
                    default -> 202;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

